/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.impl;

import com.cognos.cm.util.clock.CMClock;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfTimer;

public class PerfTimerImpl
implements PerfTimer {
    private long nStartTicks;
    private long nFinishTicks;
    private PerfMeasure mEntry = null;
    private boolean m_started;

    public PerfTimerImpl(PerfMeasure entry) {
        this.mEntry = entry;
    }

    @Override
    public PerfMeasure getMeasure() {
        return this.mEntry;
    }

    @Override
    public void start() {
        try {
            this.nStartTicks = this.getSystemTicks();
            this.m_started = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected long getSystemTicks() {
        long ticks = 0L;
        try {
            ticks = CMClock.getTicks();
        }
        catch (Exception e) {
            ticks = 0L;
        }
        return ticks;
    }

    @Override
    public long stop() {
        long nTotalMillis = 0L;
        try {
            this.nFinishTicks = this.getSystemTicks();
            this.m_started = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long nTotalTicks = this.nFinishTicks - this.nStartTicks;
        if (nTotalTicks > 0L) {
            nTotalMillis = this.ticksToMillisRounded(nTotalTicks);
            if (this.mEntry.isEnabled()) {
                this.mEntry.incr(nTotalMillis);
            }
        }
        return nTotalMillis;
    }

    protected long ticksToMillisRounded(long totalTicks) {
        return (long)CMClock.convertAndRoundTicksToMillis(totalTicks);
    }

    @Override
    public boolean isStarted() {
        return this.m_started;
    }
}

