/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.impl;

import com.cognos.cm.util.clock.CMClock;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfTimer;

public class PerfTimerThreadLocalImpl
implements PerfTimer {
    private ThreadLocalState mState = new ThreadLocalState();
    private PerfMeasure mEntry = null;

    public PerfTimerThreadLocalImpl(PerfMeasure entry) {
        this.mEntry = entry;
    }

    @Override
    public PerfMeasure getMeasure() {
        return this.mEntry;
    }

    @Override
    public void start() {
        if (this.mEntry.isEnabled()) {
            TimerState state = this.mState.getState();
            try {
                state.nStartTicks = this.getSystemTicks();
                state.m_started = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected long getSystemTicks() {
        long ticks = 0L;
        try {
            ticks = CMClock.getTicks();
        }
        catch (Exception e) {
            ticks = 0L;
        }
        return ticks;
    }

    @Override
    public long stop() {
        long nTotalMillis = 0L;
        TimerState state = this.mState.getState();
        if (this.mEntry.isEnabled() && state.m_started) {
            long nTotalTicks;
            boolean bRecordTicks = true;
            state.m_started = false;
            try {
                state.nFinishTicks = this.getSystemTicks();
            }
            catch (Throwable t) {
                bRecordTicks = false;
            }
            if (bRecordTicks && (nTotalTicks = state.nFinishTicks - this.mState.getState().nStartTicks) > 0L) {
                nTotalMillis = this.ticksToMillisRounded(nTotalTicks);
                this.mEntry.incr(nTotalMillis);
            }
        }
        return nTotalMillis;
    }

    protected long ticksToMillisRounded(long totalTicks) {
        return (long)CMClock.convertAndRoundTicksToMillis(totalTicks);
    }

    @Override
    public boolean isStarted() {
        return this.mState.getState().m_started;
    }

    private static class ThreadLocalState
    extends ThreadLocal<TimerState> {
        private ThreadLocalState() {
        }

        @Override
        public TimerState initialValue() {
            return new TimerState();
        }

        public TimerState getState() {
            return (TimerState)super.get();
        }
    }

    private static class TimerState {
        long nStartTicks;
        long nFinishTicks;
        boolean m_started;

        private TimerState() {
        }
    }
}

