/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logging;

import com.cognos.indications.LogAuditIndication;
import com.cognos.logging.LogExecutionContext;
import com.cognos.logging.LogNameValueCollection;
import com.cognos.logging.LogNameValueElem;

public class LogAuditMessage
extends LogAuditIndication {
    public final String LOG_START_REQUEST_TAG = "<request>";
    public final String LOG_STOP_REQUEST_TAG = "</request>";
    public final String LOG_START_RESPONSE_TAG = "<response>";
    public final String LOG_STOP_RESPONSE_TAG = "</response>";
    public final String LOG_START_THIRDPARTY_TAG = "<thirdparty>";
    public final String LOG_STOP_THIRDPARTY_TAG = "</thirdparty>";
    public final String LOG_START_TRACE_TAG = "<trace>";
    public final String LOG_STOP_TRACE_TAG = "</trace>";
    public final String LOG_START_FUNCTION_TAG = "<function ";
    public final String LOG_STOP_FUNCTION_TAG = "</function>";
    public static final String LOG_START_ITEM_TAG = "<item ";
    public static final String LOG_STOP_ITEM_TAG = "</item>";
    public final String LOG_START_RETURNVALUE_TAG = "<returnvalue>";
    public final String LOG_STOP_RETURNVALUE_TAG = "</returnvalue>";
    public static final String LOG_START_PARAMETERS_TAG = "<parameters>";
    public static final String LOG_STOP_PARAMETERS_TAG = "</parameters>";
    public static final String LOG_NAME_ATTR_TAG = "name=\"";
    public static final String LOG_START_CDATA_TAG = "<![CDATA[";
    public static final String LOG_STOP_CDATA_TAG = "]]>";

    public LogAuditMessage(String compName, int buildNum) {
        super(compName, buildNum);
    }

    public LogAuditMessage() {
    }

    public LogAuditMessage(LogExecutionContext c0) {
        super(c0.m_compID, c0.m_buildNo);
        this.setExecutionContext(c0);
    }

    public void setExecutionContext(LogExecutionContext c0) {
        this.setSessionID(c0.m_sessionID);
        this.setRequestID(c0.m_requestID);
        this.setStepID(c0.m_stepID);
        this.setSubRequestID(c0.m_subRequestID);
    }

    public void setBusRequestLogData(String logData) {
        if (null == logData) {
            logData = "";
        }
        this.m_logData = "<request>" + logData + "</request>";
        if (this.m_level == Integer.MAX_VALUE) {
            this.m_level = 20000;
        }
        if (null == this.m_operation || this.m_operation.equals("")) {
            this.m_operation = "Request";
        }
    }

    public void setBusResponseLogData(String logData) {
        if (null == logData) {
            logData = "";
        }
        this.m_logData = "<response>" + logData + "</response>";
        if (this.m_level == Integer.MAX_VALUE) {
            this.m_level = 20000;
        }
        if (null == this.m_operation || this.m_operation.equals("")) {
            this.m_operation = "Response";
        }
    }

    public void setThirdPartyLogData(String logData) {
        if (null == logData) {
            logData = "";
        }
        this.m_logData = "<thirdparty>" + logData + "</thirdparty>";
        if (this.m_level == Integer.MAX_VALUE) {
            this.m_level = 10000;
        }
        if (null == this.m_operation || this.m_operation.equals("")) {
            this.m_operation = "NativeQuery";
        }
    }

    protected static String buildCDATA(String dataStr) {
        String retStr = LOG_START_CDATA_TAG + dataStr + LOG_STOP_CDATA_TAG;
        return retStr;
    }

    protected static String buildNameAttr(String nameStr) {
        String retStr = LOG_NAME_ATTR_TAG + nameStr + "\"";
        return retStr;
    }

    protected static String buildParameters(LogNameValueCollection c) {
        int colSize = c.size();
        StringBuilder retStr = new StringBuilder();
        for (int ii = 0; ii < colSize; ++ii) {
            LogNameValueElem e1;
            try {
                e1 = c.get(ii);
            }
            catch (Exception e3) {
                return null;
            }
            catch (Error e2) {
                return null;
            }
            retStr.append(LOG_START_ITEM_TAG);
            retStr.append(LogAuditMessage.buildNameAttr(e1.m_name));
            retStr.append(">");
            retStr.append(LogAuditMessage.buildCDATA(e1.m_value));
            retStr.append(LOG_STOP_ITEM_TAG);
        }
        return LOG_START_PARAMETERS_TAG + retStr + LOG_STOP_PARAMETERS_TAG;
    }

    public void setFunctionLogData(String funcName, String funcRetType, LogNameValueCollection c) {
        this.m_logData = "<function " + LogAuditMessage.buildNameAttr(funcName) + ">" + "<returnvalue>" + LogAuditMessage.buildCDATA(funcRetType) + "</returnvalue>" + LogAuditMessage.buildParameters(c) + "</function>";
        if (this.m_level == Integer.MAX_VALUE) {
            this.m_level = 10000;
        }
    }
}

