/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.exceptions;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.exceptions.ICCLExceptionHandling;
import com.cognos.ccl4j.message.CCLMsg;
import com.cognos.ccl4j.message.CCLMsgInfo;
import com.cognos.ccl4j.message.CCLMsgParam;
import com.cognos.ccl4j.resource.CCLResource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class CCLExceptionImpl {
    private ICCLExceptionHandling _exOwner = null;
    private HashMap _mProperties = null;
    private CCLMsgInfo _miException = null;
    private String _sPreparedMessage = null;
    private Throwable _exRootException = null;
    private CCLMsg _msg = null;
    private boolean _bIsSystemProblem = true;
    private boolean _bIsRecoverable = false;
    private int _nOnClientError = -1;
    private String _sApplicationAction = null;
    private static Class _clsSoapFaultException = null;
    private static boolean _bGetClassSoapFault = true;

    void copyFromCCLExceptionImpl(CCLExceptionImpl exSrc) {
        this._mProperties = exSrc._mProperties;
        this._miException = exSrc._miException;
        this._exRootException = exSrc._exRootException;
        if (this._exRootException instanceof CCLException) {
            CCLException cclex = (CCLException)this._exRootException;
            cclex._impl._exRootException = null;
        } else if (this._exRootException instanceof CCLRuntimeException) {
            CCLRuntimeException cclrex = (CCLRuntimeException)this._exRootException;
            cclrex._impl._exRootException = null;
        }
        this._bIsSystemProblem = exSrc._bIsSystemProblem;
    }

    void setProperty(String sPropertyKey, Object propertyValue) {
        if (this._mProperties == null) {
            this._mProperties = new HashMap(107);
        }
        this._mProperties.put(sPropertyKey, propertyValue);
    }

    Object getProperty(String sPropertyKey) {
        if (this._mProperties == null) {
            return null;
        }
        return this._mProperties.get(sPropertyKey);
    }

    Map getProperties() {
        return this._mProperties;
    }

    void setIsSystemProblem(boolean b) {
        this._bIsSystemProblem = b;
        if (this._msg != null) {
            this._msg.setIsSystemMessage(b);
        }
    }

    void setIsRecoverableSystemProblem(boolean b) {
        this._bIsSystemProblem = b;
        this._bIsRecoverable = b;
    }

    void setIsRecoverable(boolean b) {
        this._bIsRecoverable = b;
    }

    boolean isRecoverableProblem() {
        return this._bIsRecoverable;
    }

    boolean isClientProblem() {
        return !this._bIsSystemProblem;
    }

    void beClientProblem() {
        this.setIsSystemProblem(false);
        this.setIsRecoverable(true);
    }

    void beSystemProblem() {
        this.setIsSystemProblem(true);
    }

    void beRecoverableSystemProblem() {
        this.setIsRecoverableSystemProblem(true);
    }

    void setOnClientError(int n) {
        this._nOnClientError = n;
    }

    int getOnClientError() {
        return this._nOnClientError;
    }

    void setApplicationAction(String val) {
        this._sApplicationAction = val;
    }

    String getApplicationAction() {
        return this._sApplicationAction;
    }

    void beTextException() {
        if (this._msg != null) {
            this._msg.beTextMessage();
        }
    }

    void bePresentableException() {
        if (this._msg != null) {
            this._msg.bePresentableMessage();
        }
    }

    Throwable getRootException() {
        return this._exRootException;
    }

    CCLMsgInfo getMsgInfo() {
        return this._miException;
    }

    CCLExceptionImpl(ICCLExceptionHandling exICCL, Throwable exIn, String sCode, int nType, CCLMsgParam[] vP, String sText) {
        this._exOwner = exICCL;
        Exception exCCL = null;
        if (exICCL instanceof Exception) {
            exCCL = (Exception)((Object)exICCL);
        }
        this.processChainedException(exIn, exCCL);
        if (this._miException == null) {
            this._miException = new CCLMsgInfo();
        }
        CCLMsg msg = null;
        if (CCLCheck.isValidString(sCode)) {
            msg = this._miException.addMessage(new CCLMsg(sCode, vP));
        } else if (CCLCheck.isValidString(sText)) {
            msg = this._miException.addMessage(new CCLMsg(sText));
            msg.beTextMessage();
        }
        if (msg != null) {
            msg.setType(nType);
            msg.setIsSystemMessage(this._bIsSystemProblem);
        }
        this._msg = msg;
    }

    private static Class getDispatcherSOAPFaultExceptionClass() {
        if (_bGetClassSoapFault && _clsSoapFaultException == null) {
            try {
                _clsSoapFaultException = Class.forName("com.cognos.pogo.bibus.SoapFaultException");
            }
            catch (ClassNotFoundException e) {
                _bGetClassSoapFault = false;
            }
        }
        return _clsSoapFaultException;
    }

    private static String getMessageFromDispatcherSOAPFaultException(Throwable exSOAPFault) {
        CCLCheck.nonNull(exSOAPFault);
        String sRet = null;
        Class clsSOAPFault = CCLExceptionImpl.getDispatcherSOAPFaultExceptionClass();
        if (clsSOAPFault != null) {
            try {
                Method m = clsSOAPFault.getMethod("getDetail", null);
                sRet = (String)m.invoke((Object)exSOAPFault, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sRet == null) {
            sRet = exSOAPFault.getMessage();
        }
        return sRet;
    }

    private void processChainedException(Throwable exIn, Exception exCCL) {
        CCLExceptionImpl implSrc;
        Exception cclex;
        Class clsSOAPFault;
        if (exIn == null) {
            this._exRootException = exCCL;
            return;
        }
        if (exIn instanceof InvocationTargetException && ((clsSOAPFault = CCLExceptionImpl.getDispatcherSOAPFaultExceptionClass()) == null || !clsSOAPFault.isInstance(exIn))) {
            InvocationTargetException ite = (InvocationTargetException)exIn;
            exIn = ite.getTargetException();
        }
        if (exIn instanceof CCLException) {
            cclex = (CCLException)exIn;
            implSrc = cclex._impl;
            this.copyFromCCLExceptionImpl(implSrc);
        } else if (exIn instanceof CCLRuntimeException) {
            cclex = (CCLRuntimeException)exIn;
            implSrc = ((CCLRuntimeException)cclex)._impl;
            this.copyFromCCLExceptionImpl(implSrc);
        } else if (exIn != null) {
            this._exRootException = exIn;
        }
    }

    CCLMsg addMessage(CCLMsg msg) {
        if (this._miException == null) {
            this._miException = new CCLMsgInfo();
        }
        this._miException.addMessage(msg);
        return msg;
    }

    void addMessages(CCLMsgInfo mi) {
        if (mi != null) {
            ArrayList vMsgs = mi.getMessages();
            for (int i = 0; i < vMsgs.size(); ++i) {
                CCLMsg msg = (CCLMsg)vMsgs.get(i);
                this.addMessage(msg);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        sb.append(this._exOwner.getClass().getName());
        if (this._exRootException != null) {
            sb.append(" (root ").append(this._exRootException.getClass().getName()).append(")");
        }
        sb.append(": \r\n").append(this._exOwner.getLocalizedMessage());
        String sRet = sb.toString();
        return sRet;
    }

    void prepareMessage(CCLResource res) {
        this._sPreparedMessage = this.getMessage(res);
    }

    String getMessage() {
        String sRet = this.getMessage(null);
        return sRet;
    }

    String getLocalizedMessage(CCLResource res) {
        return this.getMessage(res);
    }

    String getMessage(CCLResource res) {
        ArrayList vMsg;
        String sRet = null;
        if (res == null && this._sPreparedMessage != null) {
            return this._sPreparedMessage;
        }
        StringBuffer sb = new StringBuffer(1024);
        boolean bCCLRootException = false;
        if (this._exRootException != null) {
            if (this._exRootException instanceof ICCLExceptionHandling) {
                bCCLRootException = true;
            } else {
                Class clsSOAPFault = CCLExceptionImpl.getDispatcherSOAPFaultExceptionClass();
                String sRootMessage = clsSOAPFault != null && clsSOAPFault.isInstance(this._exRootException) ? CCLExceptionImpl.getMessageFromDispatcherSOAPFaultException(this._exRootException) : this._exRootException.getMessage();
                if (sRootMessage == null && this._exRootException != null) {
                    sRootMessage = this._exRootException.toString();
                }
                sb.append('\'').append(sRootMessage).append('\'');
            }
        }
        if (this._miException != null && (vMsg = this._miException.getMessages()) != null) {
            for (int i = 0; i < vMsg.size(); ++i) {
                CCLMsg msg = (CCLMsg)vMsg.get(i);
                if (i == 0) {
                    if (this._exRootException != null && !bCCLRootException) {
                        sb.append("\r\n WHILE ");
                    }
                } else {
                    sb.append("\r\n WHILE ");
                }
                if (res == null) {
                    msg.debugStringToSB(sb);
                    continue;
                }
                if (msg.isTextMessage()) {
                    sb.append(msg.getText());
                    continue;
                }
                String s = res.get(msg);
                sb.append(s);
            }
        }
        sRet = sb.toString();
        return sRet;
    }
}

