/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.exceptions;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLExceptionImpl;
import com.cognos.ccl4j.exceptions.ICCLExceptionHandling;
import com.cognos.ccl4j.message.CCLMsgInfo;
import com.cognos.ccl4j.resource.CCLResource;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public class CCLRuntimeException
extends RuntimeException
implements ICCLExceptionHandling {
    private static final long serialVersionUID = -7529325715186218856L;
    CCLExceptionImpl _impl = null;

    public CCLRuntimeException(String sMsg) {
        this(null, sMsg);
    }

    public CCLRuntimeException(Throwable th, String sMsg) {
        super("CCL Runtime Error: " + sMsg, th);
        CCLCheck.validString(sMsg);
        this._impl = new CCLExceptionImpl(this, th, null, 4, null, sMsg);
    }

    @Override
    public ICCLExceptionHandling setProperty(String sPropertyKey, Object propertyValue) {
        CCLCheck.validString(sPropertyKey);
        CCLCheck.nonNull(propertyValue);
        this._impl.setProperty(sPropertyKey, propertyValue);
        return this;
    }

    @Override
    public Object getProperty(String sPropertyKey) {
        CCLCheck.validString(sPropertyKey);
        return this._impl.getProperty(sPropertyKey);
    }

    @Override
    public Map getProperties() {
        return this._impl.getProperties();
    }

    @Override
    public Throwable getRootException() {
        return this._impl.getRootException();
    }

    @Override
    public void setOnClientError(int n) {
        this._impl.setOnClientError(n);
    }

    @Override
    public int getOnClientError() {
        return this._impl.getOnClientError();
    }

    @Override
    public boolean isClientProblem() {
        return this._impl.isClientProblem();
    }

    public void setIsClientProblem(boolean b) {
        this._impl.setIsSystemProblem(!b);
    }

    @Override
    public boolean isRecoverableProblem() {
        return this._impl.isRecoverableProblem();
    }

    @Override
    public CCLMsgInfo getMsgInfo() {
        return this._impl.getMsgInfo();
    }

    public void setImpl(CCLExceptionImpl impl) {
        CCLCheck.nonNull(impl);
        this._impl = impl;
    }

    public CCLExceptionImpl getImpl() {
        return this._impl;
    }

    @Override
    public String toString() {
        return this._impl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        String sRet = null;
        CCLRuntimeException cCLRuntimeException = this;
        synchronized (cCLRuntimeException) {
            sRet = this._impl.getMessage(null);
        }
        return sRet;
    }

    @Override
    public void prepareMessage(CCLResource res) {
        this._impl.prepareMessage(res);
    }

    @Override
    public String getLocalizedMessage(CCLResource res) {
        return this._impl.getLocalizedMessage(res);
    }

    @Override
    public String getMessage(CCLResource res) {
        return this._impl.getMessage(res);
    }

    @Override
    public synchronized void printStackTrace(CCLResource res) {
        this.prepareMessage(res);
        super.printStackTrace();
    }

    @Override
    public synchronized void printStackTrace(PrintStream printstream, CCLResource res) {
        CCLCheck.nonNull(printstream);
        this.prepareMessage(res);
        super.printStackTrace(printstream);
    }

    @Override
    public synchronized void printStackTrace(PrintWriter printwriter, CCLResource res) {
        CCLCheck.nonNull(printwriter);
        this.prepareMessage(res);
        super.printStackTrace(printwriter);
    }
}

