/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.resource;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.logging.ICCLDebugLogging;
import com.cognos.ccl4j.logging.ICCLServiceAuditLogging;
import com.cognos.ccl4j.resource.CCLResource;
import com.cognos.ccl4j.util.CCLStringUtils;
import com.cognos.ccl4j.util.CCLXMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCLResourceLoader {
    private static final String XML_ATTR_ID = "id";
    private static final String XML_ATTR_NAME = "name";
    private static final String XML_ATTR_TYPE = "type";
    private static final String XML_ATTR_ERRORCODE = "errorCode";
    private static final String XML_ATTR_TRANSLATE = "translate";
    private static final String XML_VALUE_TRANS_NEW = "new";
    private static final String XML_VALUE_TRANS_CHANGED = "changed";
    private static final String XML_VALUE_TYPE_MESSAGES = "Messages";
    private ICCLDebugLogging _logDebug_useWithMethodOnly = null;
    static final String MSG_FAILED_LOADING_INPUT_STREAM = "loading string properties from input-stream";
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_RETURN = '\r';

    public CCLResourceLoader(ICCLServiceAuditLogging logService, ICCLDebugLogging logDebug) {
        this._logDebug_useWithMethodOnly = logDebug;
    }

    public HashMap loadResourceStringMapFromCCLMessageFile(String sFilepath) {
        HashMap mRet = null;
        FileInputStream fis = null;
        try {
            File file = new File(sFilepath);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot find file: " + sFilepath);
            }
            fis = new FileInputStream(file);
            mRet = this.loadResourceStringMapFromCCLMessageFile(fis);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading CCL Message File '" + sFilepath + "'");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {
                    throw new CCLRuntimeException(ioex, "closing input-stream on '" + sFilepath + "'");
                }
            }
        }
        return mRet;
    }

    public synchronized HashMap loadResourceStringMapFromCCLMessageFile(InputStream is) {
        HashMap<String, CCLResource.ResourceString> mRet = new HashMap<String, CCLResource.ResourceString>(300);
        try {
            Document doc = CCLXMLUtils.buildDOM(is);
            Element elemStringTable = doc.getRootElement();
            List vComps = elemStringTable.elements();
            for (Element elemComponent : vComps) {
                String sComponentName = elemComponent.attributeValue(XML_ATTR_NAME);
                List vSections = elemComponent.elements();
                for (Element elemSection : vSections) {
                    String sSectionName = elemSection.attributeValue(XML_ATTR_NAME);
                    String sSectionType = elemSection.attributeValue(XML_ATTR_TYPE);
                    List vStrings = elemSection.elements();
                    for (Element elemString : vStrings) {
                        String sTranslate = elemString.attributeValue(XML_ATTR_TRANSLATE);
                        boolean bNotYetLocalized = false;
                        if (sTranslate != null && (sTranslate.equals(XML_VALUE_TRANS_NEW) || sTranslate.equals(XML_VALUE_TRANS_CHANGED))) {
                            bNotYetLocalized = true;
                        }
                        String sKey = elemString.attributeValue(XML_ATTR_ID);
                        String sErrorCode = null;
                        int nErrorCode = -1;
                        if (sSectionType.equals(XML_VALUE_TYPE_MESSAGES)) {
                            sErrorCode = elemString.attributeValue(XML_ATTR_ERRORCODE);
                            boolean bErrorCodeOK = true;
                            if (sErrorCode != null) {
                                if (sErrorCode.length() == 4) {
                                    try {
                                        nErrorCode = Integer.parseInt(sErrorCode);
                                    }
                                    catch (Exception ex) {
                                        this.printWarningMessage(sKey, "has non-numeric errorCode attribute: '" + sErrorCode + "'");
                                        bErrorCodeOK = false;
                                    }
                                    if (nErrorCode > -1 && (nErrorCode < 1000 || nErrorCode >= 6000)) {
                                        this.printWarningMessage(sKey, "is in a 'Message' string section but has a non-conventional errorCode: '" + sErrorCode + "' (should be between 1000 and 5999)");
                                        bErrorCodeOK = false;
                                    }
                                } else {
                                    this.printWarningMessage(sKey, "has invalid errorCode attribute: '" + sErrorCode + "'");
                                    bErrorCodeOK = false;
                                }
                            } else {
                                this.printWarningMessage(sKey, "is in a 'Message' string section but has no errorCode attribute");
                                bErrorCodeOK = false;
                            }
                            if (!bErrorCodeOK) {
                                this.printWarningMessage(sKey, ": Strings in the 'Messages' type sections must have 'errorCode' attributes with unique 4-digit numbers.");
                            }
                        }
                        String sValue = null;
                        StringBuffer sb = new StringBuffer(512);
                        for (int nIdxSegment = 0; nIdxSegment < elemString.nodeCount(); ++nIdxSegment) {
                            Node ndSegment = elemString.node(nIdxSegment);
                            if (ndSegment.getNodeType() == 3 || ndSegment.getNodeType() == 5) {
                                String sSegment = ndSegment.getText();
                                sb.append(sSegment);
                                continue;
                            }
                            if (ndSegment.getNodeType() != 1) continue;
                            Element elemParam = (Element)ndSegment;
                            String sParamName = elemParam.attributeValue(XML_ATTR_NAME);
                            sb.append('{');
                            if (sParamName != null && sParamName.length() > 0) {
                                sb.append(sParamName);
                            } else {
                                this.printWarningMessage(sKey, "has unnamed parameter");
                            }
                            sb.append('}');
                        }
                        if (sKey == null || sKey.length() <= 0) continue;
                        sValue = sb.toString();
                        sValue = this.normalizeString(sValue);
                        CCLResource.ResourceString rs = new CCLResource.ResourceString();
                        rs.setId(sKey);
                        if (sSectionType.equals(XML_VALUE_TYPE_MESSAGES)) {
                            rs.setErrorCode(nErrorCode);
                            String sCRNMessageCode = sComponentName + "-" + sSectionName + "-" + sErrorCode;
                            rs.setCRNMessageCode(sCRNMessageCode);
                            sValue = sCRNMessageCode + " " + sValue;
                        }
                        rs.setString(sValue);
                        rs.setNotYetLocalized(bNotYetLocalized);
                        mRet.put(sKey, rs);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, MSG_FAILED_LOADING_INPUT_STREAM);
        }
        return mRet;
    }

    private String normalizeString(String sIn) {
        String sRet = null;
        if (sIn != null) {
            StringBuffer sb = new StringBuffer(sIn.length() + 20);
            int nIdx = 0;
            int nIdxMax = sIn.length();
            while (nIdx < nIdxMax) {
                char ch = sIn.charAt(nIdx);
                if (ch == '\\') {
                    int nIdxNext = nIdx + 1;
                    if (nIdxNext >= nIdxMax) break;
                    char chNext = sIn.charAt(nIdxNext);
                    switch (chNext) {
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        default: {
                            sb.append(chNext);
                        }
                    }
                    nIdx += 2;
                    continue;
                }
                sb.append(ch);
                ++nIdx;
            }
            sRet = sb.toString();
        }
        return sRet;
    }

    public synchronized HashMap loadResourceStringMapFromResourceBundle(String sResName, Locale loc, boolean bAllowAbsent) {
        HashMap<String, CCLResource.ResourceString> mRet = null;
        ResourceBundle res = null;
        try {
            block6: {
                try {
                    res = loc != null ? ResourceBundle.getBundle(sResName, loc) : ResourceBundle.getBundle(sResName);
                }
                catch (MissingResourceException ex) {
                    if (bAllowAbsent) break block6;
                    throw new CCLRuntimeException(ex, "loading resource bundle '" + sResName + "'");
                }
            }
            if (res != null) {
                mRet = new HashMap<String, CCLResource.ResourceString>(3007);
                Enumeration<String> enumKeys = res.getKeys();
                while (enumKeys.hasMoreElements()) {
                    String sKey = enumKeys.nextElement();
                    String sValue = res.getString(sKey);
                    CCLResource.ResourceString rs = new CCLResource.ResourceString();
                    rs.parseCCLMessage(sKey, sValue);
                    mRet.put(sKey, rs);
                }
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading message strings from bundle '" + sResName + "'");
        }
        return mRet;
    }

    public void resolveLoadtimeParameters(CCLResource res) {
        res.resolveVariables();
    }

    public void removeDoubledQuotes(HashMap mProps) {
        if (mProps == null) {
            throw new CCLRuntimeException("<null> map.");
        }
        try {
            for (String sKey : mProps.keySet()) {
                CCLResource.ResourceString res = (CCLResource.ResourceString)mProps.get(sKey);
                String sValue = res.getString();
                String sNewValue = CCLStringUtils.replaceAll(sValue, "''", "'");
                res.setString(sNewValue);
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "removing doubled quotes");
        }
    }

    private void printWarningMessage(String sKey, String sMsg) {
        String sMsgToSend = "Resource Loader:  WARNING String '" + sKey + "' " + sMsg + ".";
        this.writeDebugMessage(40000, sMsgToSend);
    }

    private void writeDebugMessage(int nIPFLevel, String sMsg) {
        if (this._logDebug_useWithMethodOnly != null) {
            this._logDebug_useWithMethodOnly.debug(nIPFLevel, sMsg);
        }
    }
}

