/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public final class CCLStacktraceUtils {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int NEWLINE_LEN = NEWLINE.length();

    private CCLStacktraceUtils() {
    }

    public static String getStacktrace() {
        Exception e = new Exception();
        String sRet = CCLStacktraceUtils.getStacktrace(e);
        return sRet;
    }

    public static String getStacktrace(Throwable throwable) {
        String sStacktrace = null;
        java.lang.StackTraceElement[] trace = throwable.getStackTrace();
        StringWriter stringWriter = new StringWriter(trace.length * 256);
        PrintWriter pw = new PrintWriter((Writer)stringWriter, true);
        for (int i = 0; i < trace.length; ++i) {
            pw.println("\tat " + trace[i]);
        }
        pw.close();
        sStacktrace = stringWriter.toString();
        return sStacktrace;
    }

    public static String trimStacktraceStart(String sStacktrace, String sToTrim) {
        String sTextBefore;
        int nLastNL;
        String sRet = sStacktrace;
        int i = sRet.indexOf(sToTrim);
        if (i > -1 && (nLastNL = (sTextBefore = sStacktrace.substring(0, i)).lastIndexOf(NEWLINE)) > -1) {
            sRet = sStacktrace.substring(nLastNL += NEWLINE.length());
        }
        return sRet;
    }

    public static String trimStacktraceEnd(String sStacktrace, String sToTrim) {
        int nLastNL;
        String sRet = sStacktrace;
        int i = sRet.indexOf(sToTrim);
        if (i > -1 && (nLastNL = (sRet = sStacktrace.substring(0, i)).lastIndexOf(NEWLINE)) > -1) {
            sRet = sStacktrace.substring(0, nLastNL);
        }
        return sRet;
    }

    public static StackTraceElement getTopFrame() {
        StackTraceElement sfi = null;
        String sStacktrace = CCLStacktraceUtils.getStacktrace();
        sfi = CCLStacktraceUtils.getTopFrameFromStacktrace(sStacktrace);
        return sfi;
    }

    static StackTraceElement getTopFrameFromStacktrace(String sStacktrace) {
        StackTraceElement sfi = null;
        ArrayList vFrames = CCLStacktraceUtils.getStackFrames(sStacktrace, 12);
        if (vFrames.size() >= 3) {
            sfi = (StackTraceElement)vFrames.get(2);
        }
        return sfi;
    }

    static StackTraceElement getStackFrameFromStacktraceLine(String sStacktraceLine) {
        int nIdxSeparator;
        StackTraceElement retSFI = null;
        int nIdxCloseParen = sStacktraceLine.indexOf(41);
        if (nIdxCloseParen == -1) {
            return null;
        }
        int nIdxOpenParen = sStacktraceLine.indexOf(40);
        if (nIdxOpenParen == -1 || nIdxOpenParen > nIdxCloseParen) {
            return null;
        }
        int nIdxColon = sStacktraceLine.indexOf(58, nIdxOpenParen);
        if (nIdxColon == -1 || nIdxColon > nIdxCloseParen) {
            return null;
        }
        String sClassAndMethodName = sStacktraceLine.substring(0, nIdxOpenParen);
        String AT_PREFIX = "\tat ";
        if (sClassAndMethodName.startsWith("\tat ")) {
            sClassAndMethodName = sClassAndMethodName.substring("\tat ".length());
        }
        if ((nIdxSeparator = sClassAndMethodName.lastIndexOf(46)) == -1) {
            return null;
        }
        String sClassName = sClassAndMethodName.substring(0, nIdxSeparator);
        String sMethodName = sClassAndMethodName.substring(nIdxSeparator + 1);
        String sFileName = sStacktraceLine.substring(nIdxOpenParen + 1, nIdxColon);
        String sLineNumber = sStacktraceLine.substring(nIdxColon + 1, nIdxCloseParen);
        int nLineNumber = Integer.parseInt(sLineNumber);
        retSFI = new StackTraceElement(sClassName, sMethodName, sFileName, nLineNumber);
        return retSFI;
    }

    private static ArrayList toLines(String sLongString) {
        ArrayList<String> vRet = new ArrayList<String>();
        int nIdx_start = 0;
        int nIdx_end = 0;
        int nLen = sLongString.length();
        while (nIdx_start < nLen) {
            String s;
            nIdx_end = sLongString.indexOf(NEWLINE, nIdx_start);
            if (nIdx_end == -1) {
                s = sLongString.substring(nIdx_start);
                vRet.add(s);
            } else {
                s = sLongString.substring(nIdx_start, nIdx_end);
                nIdx_end += NEWLINE_LEN;
                vRet.add(s);
            }
            nIdx_start = nIdx_end;
        }
        return vRet;
    }

    public static ArrayList getStackFrames() {
        Exception ex = new Exception();
        ArrayList vRet = CCLStacktraceUtils.getStackFrames(ex);
        if (vRet.size() > 0) {
            vRet.remove(0);
        }
        return vRet;
    }

    public static ArrayList getStackFrames(Throwable th) {
        return CCLStacktraceUtils.getStackFrames(th, -1);
    }

    public static ArrayList getStackFrames(Throwable th, int nMaxFrames) {
        String sStacktrace = CCLStacktraceUtils.getStacktrace(th);
        ArrayList vFrames = CCLStacktraceUtils.getStackFrames(sStacktrace, nMaxFrames);
        return vFrames;
    }

    public static ArrayList getStackFrames(String sStacktrace) {
        return CCLStacktraceUtils.getStackFrames(sStacktrace, -1);
    }

    public static ArrayList getStackFrames(String sStacktrace, int nMaxFrames) {
        ArrayList<StackTraceElement> vFrames = new ArrayList<StackTraceElement>();
        int nMax = nMaxFrames;
        if (nMax < 0) {
            nMax = 100000;
        }
        ArrayList vLines = CCLStacktraceUtils.toLines(sStacktrace);
        Iterator iterLines = vLines.iterator();
        int nIdxFrame = 0;
        while (iterLines.hasNext() && nIdxFrame < nMax) {
            String sLine = (String)iterLines.next();
            StackTraceElement sfi = CCLStacktraceUtils.getStackFrameFromStacktraceLine(sLine);
            if (sfi == null) continue;
            vFrames.add(sfi);
            ++nIdxFrame;
        }
        return vFrames;
    }

    public static final class StackTraceElement
    implements Serializable {
        private String declaringClass;
        private String methodName;
        private String fileName;
        private int lineNumber;
        private static final long serialVersionUID = 6992337162326171013L;

        StackTraceElement(String sClassName, String sMethodName, String sFileName, int nLineNumber) {
            this.declaringClass = sClassName;
            this.methodName = sMethodName;
            this.fileName = sFileName;
            this.lineNumber = nLineNumber;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getClassName() {
            return this.declaringClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.getClassName() + "." + this.methodName + (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)"));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackTraceElement)) {
                return false;
            }
            StackTraceElement e = (StackTraceElement)obj;
            return e.declaringClass.equals(this.declaringClass) && e.lineNumber == this.lineNumber && this.eq(this.methodName, e.methodName) && this.eq(this.fileName, e.fileName);
        }

        private boolean eq(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        public int hashCode() {
            int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + this.lineNumber;
            return result;
        }
    }
}

