/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CCLTimestampedFileUtils {
    public static File createTimestampedFile(String sDirpath, String sFilenamePrefix, String sFilenameSuffix) {
        Date dtNull = null;
        return CCLTimestampedFileUtils.createTimestampedFile(sDirpath, sFilenamePrefix, sFilenameSuffix, dtNull);
    }

    public static File createTimestampedFile(String sDirpath, String sFilenamePrefix, String sFilenameSuffix, Date ts) {
        File fRet = null;
        int nSeq = 0;
        while (nSeq < 20 && (fRet = CCLTimestampedFileUtils._createTimestampedFile(sDirpath, sFilenamePrefix, sFilenameSuffix, ts, nSeq > 0)) == null) {
        }
        return fRet;
    }

    private static File _createTimestampedFile(String sDirpath, String sFilenamePrefix, String sFilenameSuffix, Date ts, boolean bUseMillis) {
        File fRet = null;
        try {
            if (sDirpath == null) {
                throw new CCLRuntimeException("Creating a timestamped file with no parent directory");
            }
            String sFilepath = CCLTimestampedFileUtils.createTimestampedPath(sDirpath, sFilenamePrefix, sFilenameSuffix, bUseMillis, ts);
            File fDir = new File(sDirpath);
            if (!fDir.exists()) {
                throw new CCLRuntimeException("Directory '" + fDir.getAbsolutePath() + "' does not exist");
            }
            File fTSFile = new File(sFilepath);
            boolean bCreated = fTSFile.createNewFile();
            if (bCreated) {
                fRet = fTSFile;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "Creating timestamped file: dir='" + sDirpath + "' prefix='" + sFilenamePrefix + "' suffix='" + sFilenameSuffix + "'");
        }
        return fRet;
    }

    public static File createTimestampedDirectory(String sParentDirpath, String sDirnamePrefix, String sDirnameSuffix) {
        Date dtNull = null;
        return CCLTimestampedFileUtils.createTimestampedDirectory(sParentDirpath, sDirnamePrefix, sDirnameSuffix, dtNull);
    }

    public static File createTimestampedDirectory(String sDirpath, String sDirnamePrefix, String sDirnameSuffix, Date ts) {
        File fRet = null;
        int nSeq = 0;
        while (nSeq < 20 && (fRet = CCLTimestampedFileUtils._createTimestampedDirectory(sDirpath, sDirnamePrefix, sDirnameSuffix, ts, nSeq > 0)) == null) {
        }
        return fRet;
    }

    private static File _createTimestampedDirectory(String sParentDirpath, String sDirnamePrefix, String sDirnameSuffix, Date ts, boolean bUseMillis) {
        File fRet = null;
        try {
            String sDirpath = CCLTimestampedFileUtils.createTimestampedPath(sParentDirpath, sDirnamePrefix, sDirnameSuffix, bUseMillis, ts);
            if (sParentDirpath == null) {
                throw new CCLRuntimeException("Creating timestamped directory with no parent directory");
            }
            File fDir = new File(sParentDirpath);
            if (!fDir.exists()) {
                throw new CCLRuntimeException("Parent directory '" + fDir.getAbsolutePath() + "' does not exist");
            }
            File fTSFile = new File(sDirpath);
            boolean bCreated = fTSFile.mkdir();
            if (bCreated) {
                fRet = fTSFile;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "Creating timestamped file: dir='" + sParentDirpath + "' prefix='" + sDirnamePrefix + "' suffix='" + sDirnameSuffix + "'");
        }
        return fRet;
    }

    public static String createTimestampedPath(String sParentDirpath, String sFilenamePrefix, String sFilenameSuffix) {
        boolean bUseMillis = false;
        return CCLTimestampedFileUtils.createTimestampedPath(sParentDirpath, sFilenamePrefix, sFilenameSuffix, false, null);
    }

    public static String createTimestampedPath(String sParentDirpath, String sFilenamePrefix, String sFilenameSuffix, boolean bUseMillis, Date ts) {
        if (sParentDirpath == null) {
            throw new CCLRuntimeException("Creating timestamped file/directory path with no parent directory");
        }
        String sRet = sParentDirpath + File.separator + CCLTimestampedFileUtils.createTimestampedFilename(sFilenamePrefix, sFilenameSuffix, bUseMillis, ts);
        return sRet;
    }

    public static String createTimestampedFilename(String sFilenamePrefix, String sFilenameSuffix) {
        boolean bUseMillis = false;
        return CCLTimestampedFileUtils.createTimestampedFilename(sFilenamePrefix, sFilenameSuffix, false, null);
    }

    public static String createTimestampedFilename(String sFilenamePrefix, String sFilenameSuffix, boolean bUseMillis, Date ts) {
        Date dtToUse;
        String sRet = null;
        SimpleDateFormat formatter = null;
        formatter = bUseMillis ? new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS") : new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        StringBuffer sb = new StringBuffer();
        if (sFilenamePrefix != null) {
            sb.append(sFilenamePrefix);
            sb.append('_');
        }
        if ((dtToUse = ts) == null) {
            dtToUse = new Date();
        }
        String sTimestamp = formatter.format(dtToUse);
        sb.append(sTimestamp);
        if (sFilenameSuffix != null) {
            sb.append(sFilenameSuffix);
        }
        sRet = sb.toString();
        return sRet;
    }
}

