/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.api;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.Servlet;
import java.util.HashSet;
import java.util.Set;

public class CAMConnector {
    public static final CAMConnector INSTANCE = new CAMConnector();

    public byte[] executeRequest(byte[] request, String writeTenantId, Set<String> readTenantIds) {
        CMExecutionContext oldContext = null;
        if (CMExecutionContext.hasContext()) {
            oldContext = CMExecutionContext.get();
            CMExecutionContext.set(null);
        }
        CMExecutionContext.setUp();
        CMExecutionContext newContext = CMExecutionContext.get();
        try {
            TenantRegistry registry = newContext.getStore().getTenantRegistry();
            this.setupWriteTenantId(writeTenantId, newContext, registry);
            this.setupReadTenantFilter(newContext, readTenantIds, registry);
            byte[] byArray = this.getServlet().ExecuteStaticRequest(request, true);
            return byArray;
        }
        catch (CMException e) {
            CMIndications.logException(e, new String(request));
            throw new CMRuntimeException(e);
        }
        finally {
            CMExecutionContext.tearDown();
            if (oldContext != null) {
                CMExecutionContext.set(oldContext);
            }
        }
    }

    private void setupWriteTenantId(String writeTenantId, CMExecutionContext newContext, TenantRegistry registry) throws CMException {
        int writeTenantIdInt = writeTenantId != null && registry.isExistingTenant(writeTenantId) ? registry.getTenantIdIntFromString(writeTenantId, false) : 0;
        newContext.setStaticTenantId(writeTenantIdInt);
    }

    private void setupReadTenantFilter(CMExecutionContext newContext, Set<String> readTenantIds, TenantRegistry registry) throws CMException {
        if (readTenantIds != null) {
            if (!readTenantIds.contains("")) {
                readTenantIds = new HashSet<String>(readTenantIds);
                readTenantIds.add("");
            }
            int[] readTenantIdInts = registry.getTenantIdsAsIntArray(readTenantIds, true);
            newContext.setReadTenantFilter(new ReadTenantFilter.FixedListTenantFilter(readTenantIdInts));
        } else {
            newContext.setReadTenantFilter(new ReadTenantFilter.AllowAllTenantFilter());
        }
    }

    public byte[] executeRequest(byte[] request, String tenantId) {
        HashSet<String> readTenantIds = null;
        if (tenantId != null) {
            readTenantIds = new HashSet<String>(2);
            readTenantIds.add(tenantId);
            readTenantIds.add("");
        }
        return this.executeRequest(request, tenantId, readTenantIds);
    }

    protected Servlet getServlet() {
        return ContentManager.servlet_;
    }
}

