/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.archiving;

import com.cognos.cm.archiving.ArchivedDataConfiguration;
import com.cognos.cm.archiving.IArchivedDataConfiguration;
import com.cognos.cm.archiving.IArchivedDataConfigurationBuilder;
import com.cognos.cm.archiving.IArchivedObjectClass;
import com.cognos.cm.archiving.IArchivedProperty;
import com.cognos.cm.archiving.IArchivedPropertyFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ArchivedDataConfigurationBuilder
implements IArchivedDataConfigurationBuilder {
    public static final String RESOURCE_REPOSITORIES_CONFIG_XML_EXTENTION = ".xml";
    public static final String ELEMENT_PROPERTIES = "properties";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ATTR_VALUE_HANDLER = "valueHandler";
    public static final String ATTR_METADATA_PROPERTY_NAME = "metadataPropertyName";
    public static final String ATTR_PROPERTY_NAME = "name";
    public static final String ELEMENT_OBJECT_CLASSES = "objectClasses";
    public static final String ELEMENT_OBJECT_CLASS = "objectClass";
    public static final String ATTR_OBJECT_CLASS_NAME = "name";
    public static final String ATTR_PROPERTY_VALUE_SETTER = "propertyValueSetter";
    public static final String ATTR_USE_TEMP_FILE = "useTempFile";
    private CMResourceLoader resourceLoader;
    private IArchivedPropertyFactory propertyFactory;

    public ArchivedDataConfigurationBuilder(IArchivedPropertyFactory propertyFactory, CMResourceLoader resourceLoader) {
        this.propertyFactory = propertyFactory;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public IArchivedDataConfiguration createConfiguration() throws CMException {
        IArchivedDataConfiguration configuration = this.createArchivedDataConfiguration();
        String resourceName = this.createConfigurationFileName();
        Document connectionConfigurationDocument = this.getPluginConfigurationDocument(resourceName);
        if (connectionConfigurationDocument == null) {
            this.throwConfigurationParsingException(resourceName);
        }
        Element rootNode = connectionConfigurationDocument.getRootElement();
        this.loadArchivedObjectClasses(configuration, resourceName, rootNode);
        return configuration;
    }

    private void loadObjectTypeProperties(Element objectTypeElement, IArchivedObjectClass objectClass, String resourceName) throws CMException {
        List propertyElements = XMLUtils.selectNodes((Element)objectTypeElement, (String)"./properties/property");
        for (Element propertyElement : propertyElements) {
            IArchivedProperty targetProperty = this.createArchivedProperty(propertyElement, resourceName);
            objectClass.addProperty(targetProperty);
        }
    }

    private void loadArchivedObjectClasses(IArchivedDataConfiguration configuration, String resourceName, Element rootNode) throws CMException {
        List objectTypeElements = XMLUtils.selectNodes((Element)rootNode, (String)"./objectClass");
        for (Element objectTypeElement : objectTypeElements) {
            IArchivedObjectClass objectClass = this.loadArchivedObjectClass(objectTypeElement, resourceName);
            if (objectClass.getName() == null) {
                throw new IllegalStateException("Missing root object class name");
            }
            configuration.addRootObjectClass(objectClass);
            this.loadParentObjectClasses(objectTypeElement, objectClass, resourceName);
        }
    }

    private IArchivedObjectClass loadArchivedObjectClass(Element objectTypeElement, String resourceName) throws CMException {
        String objectTypeName = this.getOptionalAttribute(objectTypeElement, "name");
        IArchivedObjectClass objectType = this.propertyFactory.createArchivedObjectClass(objectTypeName);
        this.loadObjectTypeProperties(objectTypeElement, objectType, resourceName);
        return objectType;
    }

    private void loadParentObjectClasses(Element objectTypeElement, IArchivedObjectClass objectClass, String resourceName) throws CMException {
        Element objectTypesElement = this.getOptionalChildElement(objectTypeElement, ELEMENT_OBJECT_CLASSES);
        if (objectTypesElement != null) {
            List childElements = objectTypesElement.elements(ELEMENT_OBJECT_CLASS);
            for (Element parentObjectTypeElement : childElements) {
                IArchivedObjectClass parentObjectType = this.loadArchivedObjectClass(parentObjectTypeElement, resourceName);
                objectClass.addParentObjectClass(parentObjectType);
                this.loadParentObjectClasses(parentObjectTypeElement, parentObjectType, resourceName);
            }
        }
    }

    private IArchivedProperty createArchivedProperty(Element propertyElement, String resourceName) throws CMException {
        String archivedPropertyName = this.getRequiredAttribute(propertyElement, "name", resourceName);
        String metadataPropertyName = this.getOptionalAttribute(propertyElement, ATTR_METADATA_PROPERTY_NAME);
        String propertySetterName = this.getOptionalAttribute(propertyElement, ATTR_PROPERTY_VALUE_SETTER);
        boolean useTempFile = false;
        String useTempFileString = this.getOptionalAttribute(propertyElement, ATTR_USE_TEMP_FILE);
        if (useTempFileString != null) {
            useTempFile = Boolean.valueOf(useTempFileString);
        }
        IArchivedProperty targetProperty = this.propertyFactory.createArchivedProperty(archivedPropertyName, metadataPropertyName, propertySetterName, useTempFile);
        return targetProperty;
    }

    private String createConfigurationFileName() {
        return "CM";
    }

    public Document getPluginConfigurationDocument(String configurationResourceShortName) throws CMException {
        String pluginConfigurationResourceName = "/WEB-INF/repositories/config/" + configurationResourceShortName + RESOURCE_REPOSITORIES_CONFIG_XML_EXTENTION;
        InputStream pluginConfigurationFileInputStream = this.getPluginConfigurationFileInputStream(pluginConfigurationResourceName);
        if (pluginConfigurationFileInputStream == null) {
            return null;
        }
        Document document = null;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(pluginConfigurationFileInputStream);
        }
        catch (Exception ex) {
            this.throwConfigurationParsingException(ex, pluginConfigurationResourceName);
        }
        return document;
    }

    protected InputStream getPluginConfigurationFileInputStream(String pluginConfigurationResourceName) {
        InputStream pluginConfigurationFileInputStream = this.resourceLoader.getResourceInputStream(pluginConfigurationResourceName);
        return pluginConfigurationFileInputStream;
    }

    protected IArchivedDataConfiguration createArchivedDataConfiguration() {
        return new ArchivedDataConfiguration();
    }

    private String getRequiredAttribute(Element rootNode, String attributeName, String resourceName) throws CMException {
        String name = rootNode.attributeValue(attributeName);
        if (name == null) {
            this.throwConfigurationParsingException(resourceName);
        }
        return name;
    }

    private String getOptionalAttribute(Element rootNode, String attributeName) {
        return rootNode.attributeValue(attributeName);
    }

    private Element getOptionalChildElement(Element rootNode, String elementName) {
        return rootNode.element(elementName);
    }

    private void throwConfigurationParsingException(String resourceName) throws CMException {
        throw new CMException("cmBadConfigFile", new CMException.Parm("File", resourceName));
    }

    private void throwConfigurationParsingException(Exception ex, String resourceName) throws CMException {
        throw new CMException(ex, "cmBadConfigFile", new CMException.Parm("File", resourceName));
    }
}

