/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.archiving;

import com.cognos.cm.archiving.ArchivedObjectClass;
import com.cognos.cm.archiving.ArchivedProperty;
import com.cognos.cm.archiving.ArchivedPropertyStringValueSetter;
import com.cognos.cm.archiving.IArchivedObjectClass;
import com.cognos.cm.archiving.IArchivedPropertyFactory;
import com.cognos.cm.archiving.IArchivedPropertyValueSetter;
import com.cognos.cm.util.PluginLoader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ArchivedPropertyFactory
implements IArchivedPropertyFactory {
    private Map<String, Class<?>> cachedValueSetterClasses = new HashMap();

    @Override
    public IArchivedObjectClass createArchivedObjectClass(String objectClassName) {
        return new ArchivedObjectClass(objectClassName);
    }

    @Override
    public ArchivedProperty createArchivedProperty(String propertyName, String metadataPropertyName, String propertyValueSetter, boolean useTempFile) {
        if (propertyName == null) {
            throw new IllegalStateException("Missing property name for a property");
        }
        if (metadataPropertyName == null) {
            throw new IllegalStateException("Missing metadata property name for property " + propertyName);
        }
        IArchivedPropertyValueSetter valueSetter = this.createValueSetter(metadataPropertyName, propertyValueSetter);
        return new ArchivedProperty(propertyName, valueSetter, useTempFile);
    }

    protected IArchivedPropertyValueSetter createValueSetter(String metadataPropertyName, String propertyValueSetter) {
        IArchivedPropertyValueSetter setter = propertyValueSetter != null ? this.createSetterFromClassName(propertyValueSetter, metadataPropertyName) : new ArchivedPropertyStringValueSetter(metadataPropertyName);
        return setter;
    }

    private IArchivedPropertyValueSetter createSetterFromClassName(String propertyValueSetter, String metadataPropertyName) {
        try {
            Class<?> handlerClass = PluginLoader.get().getPluginWithCaching(this.cachedValueSetterClasses, propertyValueSetter);
            Constructor<?> propertyHandlerConstructor = handlerClass.getDeclaredConstructor(String.class);
            return (IArchivedPropertyValueSetter)propertyHandlerConstructor.newInstance(metadataPropertyName);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot create property value setter because: " + ex.getMessage());
        }
    }
}

