/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.archiving;

import com.cognos.cm.archiving.ArchivedPropertyValueSetter;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;

public class ArchivedPropertyPoliciesValueSetter
extends ArchivedPropertyValueSetter {
    public ArchivedPropertyPoliciesValueSetter(String metadataPropertyName) {
        super(metadataPropertyName);
    }

    @Override
    public void setValue(IDataDescriptor metadata, Object value, boolean wasAcquired, CMProperty property) {
        if (value != null) {
            if (!(value instanceof byte[])) {
                throw new IllegalStateException("ArchivedPropertyOwnerValueSetter only accepts instances of byte[]");
            }
            byte[] policyArray = (byte[])value;
            value = this.getXMLPolicy(policyArray, property);
        }
        this.setIsAcquiredInMetadata(metadata, wasAcquired);
        super.setValue(metadata, value, wasAcquired, property);
    }

    private String getXMLPolicy(byte[] policyArray, CMProperty property) {
        if (policyArray.length > 0) {
            AznUtil azn = this.createAznUtil();
            try {
                return azn.describePolicy(property.getName(), policyArray);
            }
            catch (CMException e) {
                CMIndications.logException(e);
                return null;
            }
        }
        return null;
    }

    protected AznUtil createAznUtil() {
        CMExecutionContext context = CMExecutionContext.get();
        return new AznUtil(CMServlet.AAA, context.getAccManPassportID(), context.getCAMAdditionalInfo());
    }
}

