/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.archiving;

import com.cognos.cm.archiving.IArchivedPropertyValueSetter;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;

public class ArchivedPropertyValueSetter
implements IArchivedPropertyValueSetter {
    static final String EMPTY_PROPERTY_VALUE = "";
    private static final String ACUIRED_METADATA_PROPERTY_PREFIX = "is";
    private static final String ACUIRED_METADATA_PROPERTY_POSTFIX = "Acquired";
    private String metadataPropertyName;

    public ArchivedPropertyValueSetter(String metadataPropertyName) {
        this.metadataPropertyName = metadataPropertyName;
    }

    @Override
    public void setValue(IDataDescriptor metadata, Object value, boolean wasAcquired, CMProperty cmProperty) {
        this.setValue(this.metadataPropertyName, metadata, value);
    }

    private void setValue(String metadataPropertyName, IDataDescriptor metadata, Object value) {
        IDataDescriptorProperty property = metadata.getProperty(metadataPropertyName);
        if (property != null) {
            throw new IllegalStateException("value of " + metadataPropertyName + " has already been set");
        }
        if (value == null) {
            value = EMPTY_PROPERTY_VALUE;
        }
        property = new DataDescriptorProperty(metadataPropertyName, value);
        metadata.addProperty(property);
    }

    protected void setIsAcquiredInMetadata(IDataDescriptor metadata, boolean wasAcquired) {
        this.setValue(this.getAcquiredMetadataPropertyName(), metadata, wasAcquired);
    }

    private String getAcquiredMetadataPropertyName() {
        String acquiredMetadataPropertyName = ACUIRED_METADATA_PROPERTY_PREFIX + this.metadataPropertyName.substring(0, 1).toUpperCase() + this.metadataPropertyName.substring(1) + ACUIRED_METADATA_PROPERTY_POSTFIX;
        return acquiredMetadataPropertyName;
    }
}

