/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.archiving;

import com.cognos.cm.archiving.IArchivedDataConfiguration;
import com.cognos.cm.archiving.IArchivedObjectClass;
import com.cognos.cm.archiving.IExternalRepositoryWriter;
import com.cognos.cm.contentTasks.actions.IArchivalTaskActionBuilder;
import com.cognos.cm.contentTasks.cleanupTask.ArchivalTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.StoreWithLockManager;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;

public class ExternalRepositoryWriter
implements IExternalRepositoryWriter {
    private ArchivalTaskContext archivalTaskContext;
    private IArchivalTaskActionBuilder actionBuilder;
    private static CMProperty objectClassProperty = CMProperty.OBJECTCLASS;
    private static CMProperty parentProperty = CMProperty.PARENT;
    private IContentObjectAction objectArchivalAction;
    private IContentObjectAction cleanupAction;
    private IArchivedDataConfiguration archivedDataConfiguration;
    private RepositoryConnection repositoryConnection;

    public ExternalRepositoryWriter(ArchivalTaskContext archivalTaskContext, IArchivalTaskActionBuilder actionBuilder) {
        this.archivalTaskContext = archivalTaskContext;
        this.actionBuilder = actionBuilder;
    }

    private CMStore getStore() {
        return this.getStoreWithLockManager().getStore();
    }

    private StoreWithLockManager getStoreWithLockManager() {
        return this.getTaskContext().getStoreWithLockManager();
    }

    private ArchivalTaskContext getTaskContext() {
        return this.archivalTaskContext;
    }

    private ICMLockManager getLockManager() {
        return this.getStoreWithLockManager().getLockManager();
    }

    protected void setObjectClassProperty(CMProperty property) {
        objectClassProperty = property;
    }

    protected void setParentProperty(CMProperty property) {
        parentProperty = property;
    }

    @Override
    public void initialize(IArchivedDataConfiguration configuration, int tenantID) throws CMException {
        this.archivedDataConfiguration = configuration;
        this.setRepositoryConnection(tenantID);
        this.objectArchivalAction = this.getActionBuilder().createObjectArchivalAction(this.getRepositoryConnection());
        this.cleanupAction = this.getActionBuilder().createCleanupAction();
    }

    private void setRepositoryConnection(int tenantID) throws CMException {
        this.repositoryConnection = this.getActionBuilder().getArchiveConnection(tenantID);
    }

    @Override
    public void archiveArchivableClassObject(String objectSearchPath) throws CMException {
        this.getTaskContext().getDataDescriptor().clearProperties();
        IArchivedObjectClass archivedObjectClass = this.getArchivedObjectClass(objectSearchPath);
        ArrayList<ExecutionStep> executionStack = this.createArchiveObjectExecutionStack(objectSearchPath, archivedObjectClass);
        this.executeExecutionStack(executionStack);
    }

    private IArchivedObjectClass getArchivedObjectClass(String objectSearchPath) throws CMException {
        CMObjectClass objectClass = this.getObjectClass(objectSearchPath);
        IArchivedObjectClass archivedObjectClass = this.archivedDataConfiguration.getRootObjectClass(objectClass.getName());
        if (archivedObjectClass == null) {
            throw new IllegalStateException("No root archivable class configured for class '" + objectClass + "'");
        }
        return archivedObjectClass;
    }

    private void executeExecutionStack(ArrayList<ExecutionStep> executionStack) throws CMException {
        for (ExecutionStep step : executionStack) {
            step.execute();
        }
    }

    private ArrayList<ExecutionStep> createArchiveObjectExecutionStack(String objectSearchPath, IArchivedObjectClass archivedObjectClass) throws CMException {
        ArrayList<ExecutionStep> executionStack = new ArrayList<ExecutionStep>();
        executionStack.add(0, new ExecutionStep(this.cleanupAction, objectSearchPath));
        executionStack.add(0, new ExecutionStep(this.objectArchivalAction, objectSearchPath));
        boolean reachedTop = false;
        while (!reachedTop) {
            CMProperty[] prop = new CMProperty[]{this.getObjectClassProperty(), this.getParentProperty()};
            Object[] values = this.getPropertyValues(objectSearchPath, prop);
            CMObjectClass objectClass = (CMObjectClass)values[0];
            String parentSearchPath = this.getSearchPathFromParentPropertyValue((CMBaseClassArray)values[1]);
            IContentObjectAction collectMetadataAction = this.getActionBuilder().createCollectMetadataAction(objectClass, archivedObjectClass.getProperties().values());
            executionStack.add(0, new ExecutionStep(collectMetadataAction, objectSearchPath));
            archivedObjectClass = archivedObjectClass.getParentObjectClass();
            if (archivedObjectClass != null) {
                objectSearchPath = parentSearchPath;
                continue;
            }
            reachedTop = true;
        }
        return executionStack;
    }

    private CMObjectClass getObjectClass(String objectSearchPath) throws CMException {
        CMProperty[] prop = new CMProperty[]{this.getObjectClassProperty()};
        Object[] values = this.getPropertyValues(objectSearchPath, prop);
        return (CMObjectClass)values[0];
    }

    private String getSearchPathFromParentPropertyValue(CMBaseClassArray parentValueObject) {
        CMObjectReference parentReference = parentValueObject.getReference(0);
        String reportStoreID = parentReference.getStoreID();
        String reportSearchPath = CMStoreXPath.encodeStoreIdToPathString(reportStoreID);
        return reportSearchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getPropertyValues(String objectSearchPath, CMProperty[] prop) throws CMStoreParseException, CMException {
        CMStoreQueryResults queryResults = null;
        Object[] values = new Object[prop.length];
        try {
            CMStoreXPath storeSearchPath = new CMStoreXPath(objectSearchPath);
            this.getLockManager().requestLocks(storeSearchPath);
            queryResults = this.getStore().executeQuery(storeSearchPath, prop, null, 0, this.getTaskContext().getTaskSecurityContext().getPermissions(), null, 0, 0);
            if (queryResults.next()) {
                for (int i = 0; i < prop.length; ++i) {
                    values[i] = queryResults.getValue(i);
                }
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            this.getLockManager().releaseLocks();
        }
        return values;
    }

    protected IArchivalTaskActionBuilder getActionBuilder() {
        return this.actionBuilder;
    }

    protected CMProperty getObjectClassProperty() {
        return objectClassProperty;
    }

    protected CMProperty getParentProperty() {
        return parentProperty;
    }

    protected CMObjectClasses getObjectClasses() {
        return this.getStore().getObjectClasses();
    }

    @Override
    public void close() {
        this.getRepositoryConnection().close();
    }

    private RepositoryConnection getRepositoryConnection() {
        return this.repositoryConnection;
    }

    @Override
    public void resetRepositoryConnection(int tenantID) throws CMException {
        this.setRepositoryConnection(tenantID);
        this.objectArchivalAction = this.getActionBuilder().createObjectArchivalAction(this.getRepositoryConnection());
    }

    private class ExecutionStep {
        private IContentObjectAction action;
        private String searchPath;

        private ExecutionStep(IContentObjectAction action, String searchPath) {
            this.action = action;
            this.searchPath = searchPath;
        }

        private void execute() throws CMException {
            this.action.execute(this.searchPath);
        }
    }
}

