/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.BackgroundTaskRunType;
import com.cognos.cm.backgroundTask.BackgroundTaskWorkerSynchronizer;
import com.cognos.cm.backgroundTask.IBackgroundTask;
import com.cognos.cm.backgroundTask.IBackgroundTaskWorker;
import com.cognos.cm.server.CMException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class BackgroundTask
implements IBackgroundTask {
    private String name;
    private BackgroundTaskRunType runType;
    private long restartInMillis;
    private List<IBackgroundTaskWorker> workers;
    private BackgroundTaskWorkerSynchronizer workerSynchronizer;
    private boolean hasExecutionPeriods;
    private int defaultNumberofWorkers;
    private boolean explicitStartOnly = false;

    public BackgroundTask(String name, BackgroundTaskRunType runType, long restartInMillis, List<IBackgroundTaskWorker> workers, int defaultNumberofWorkers, boolean explicitStartOnly) {
        this.name = name;
        this.runType = runType;
        this.restartInMillis = restartInMillis;
        this.workers = workers;
        this.workerSynchronizer = this.createBackgroundTaskWorkerSynchronizer();
        this.setHasExecutionPeriods(false);
        this.defaultNumberofWorkers = defaultNumberofWorkers;
        this.explicitStartOnly = explicitStartOnly;
    }

    protected BackgroundTaskWorkerSynchronizer createBackgroundTaskWorkerSynchronizer() {
        return new BackgroundTaskWorkerSynchronizer(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void initialize(Document configurationDocument) throws CMException {
        Element runOptionsElement = configurationDocument.getRootElement().element("runOptions");
        try {
            for (IBackgroundTaskWorker worker : this.workers) {
                worker.initialize(this.workerSynchronizer, runOptionsElement);
            }
        }
        catch (Throwable t) {
            throw new CMException(t, "cmErrorInitializeTask");
        }
    }

    @Override
    public long getRestartInMillis() {
        return this.restartInMillis;
    }

    @Override
    public BackgroundTaskRunType getRunType() {
        return this.runType;
    }

    public void waitForCompletion() {
        this.workerSynchronizer.awaitCompletion();
    }

    @Override
    public Element getRunOptions() {
        return this.workers.get(0).getTaskHandler().getRunOptions();
    }

    @Override
    public String getStatus() {
        return null;
    }

    @Override
    public List<IBackgroundTaskWorker> getWorkers() {
        return this.workers;
    }

    public void setHasExecutionPeriods(boolean hasExecutionPeriods) {
        this.hasExecutionPeriods = hasExecutionPeriods;
    }

    @Override
    public boolean hasExecutionPeriods() {
        return this.hasExecutionPeriods;
    }

    @Override
    public int getDefaultNumberofWorkers() {
        return this.defaultNumberofWorkers;
    }

    @Override
    public boolean explicitStartOnly() {
        return this.explicitStartOnly;
    }
}

