/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTaskPluginAPI.BackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.cleanupTask.ITaskErrorReporter;
import com.cognos.cm.server.CMException;

public class BackgroundTaskErrorReporter
implements ITaskErrorReporter {
    private IBackgroundTaskReporterHandler reporterHandler;

    public BackgroundTaskErrorReporter(IBackgroundTaskReporterHandler reporterHandler) {
        this.reporterHandler = reporterHandler;
    }

    @Override
    public void reportFailure(String searchPath, Throwable throwable, String message) throws CMException {
        this.reportFailureThrowable(searchPath, throwable, message);
    }

    @Override
    public void reportFailureThrowable(String searchPath, Throwable t, String message) throws CMException {
    }

    @Override
    public void reportSuccess(String successMessage, CMException.Parm[] parms) throws CMException {
        String concatenatedMessage = this.concatenateMessageAndParams(successMessage, parms);
        this.reporterHandler.reportActionSuccess(new BackgroundTaskMessage(concatenatedMessage, parms, 6));
    }

    @Override
    public void reportSuccess(String message, String objectSearchPath) throws CMException {
        this.reportSuccess(message, this.createObjectParameters(objectSearchPath));
    }

    @Override
    public void reportTaskError(CMException ex, String severity) throws CMException {
        int backgroundTaskSeverity = this.mapSeverities(severity, 2);
        this.reporterHandler.reportTaskError(ex, new BackgroundTaskMessage(ex.getMessage(), ex.getListExceptionParms_(), backgroundTaskSeverity));
    }

    @Override
    public void reportTaskError(String errCode, String severity, CMException.Parm[] parms) throws CMException {
        CMException ex = new CMException(errCode, parms);
        this.reportTaskErrorThrowable(errCode, severity, parms, ex);
    }

    @Override
    public void reportTaskErrorThrowable(String errCode, String severity, CMException.Parm[] parms, Throwable t) throws CMException {
        int backgroundTaskSeverity = this.mapSeverities(severity, 2);
        String concatenatedMessage = this.concatenateMessageAndParams(errCode, parms);
        this.reporterHandler.reportTaskError(t, new BackgroundTaskMessage(concatenatedMessage, parms, backgroundTaskSeverity));
    }

    private int mapSeverities(String severity, int defaultBackgroundTaskSeverity) {
        int backgroundTaskSeverity = defaultBackgroundTaskSeverity;
        if (severity == "error") {
            backgroundTaskSeverity = 2;
        } else if (severity == "fatal") {
            backgroundTaskSeverity = 1;
        } else if (severity == "info") {
            backgroundTaskSeverity = 4;
        } else if (severity == "warn") {
            backgroundTaskSeverity = 3;
        } else if (severity == "debug") {
            backgroundTaskSeverity = 5;
        }
        return backgroundTaskSeverity;
    }

    private String concatenateMessageAndParams(String message, CMException.Parm[] parms) {
        return CMError.getMessage(message, parms, null);
    }

    public CMException.Parm[] createObjectParameters(String objectSearchPath) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath)};
        return parms;
    }

    @Override
    public void addActionReporter(IActionReporter actionReporter) {
    }
}

