/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.DefaultBackgroundTaskReporterHandler;
import com.cognos.cm.backgroundTask.IBackgroundTaskReporter;
import com.cognos.cm.backgroundTask.TaskCurrentStatus;
import com.cognos.cm.backgroundTask.TaskLoggingSystemWrapper;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMetricsHandler;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cmutils.config.ConfigurationException;

public class BackgroundTaskReporter
implements IBackgroundTaskReporter {
    private IBackgroundTaskReporterHandler handler;
    private IBackgroundTaskMetricsHandler currentStatus;

    public BackgroundTaskReporter(IBackgroundTaskReporterHandler handler, String taskName) {
        this.initialize(handler, null, taskName, null);
    }

    public BackgroundTaskReporter(String taskName) {
        this.initialize(null, null, taskName, null);
    }

    public BackgroundTaskReporter(IBackgroundTaskMetricsHandler metricsHandler, String taskName) {
        this.initialize(null, metricsHandler, taskName, null);
    }

    public BackgroundTaskReporter(IBackgroundTaskReporterHandler handler, IBackgroundTaskMetricsHandler metricsHandler, String taskName) {
        this.initialize(handler, metricsHandler, taskName, null);
    }

    public BackgroundTaskReporter(String taskName, TaskLoggingSystemWrapper logSys) {
        this.initialize(null, null, taskName, logSys);
    }

    private void initialize(IBackgroundTaskReporterHandler reporterHandler, IBackgroundTaskMetricsHandler metricsHandler, String taskName, TaskLoggingSystemWrapper logSys) {
        if (reporterHandler != null) {
            this.handler = reporterHandler;
        } else {
            try {
                this.handler = this.createDefaultHandler(taskName, logSys);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this.currentStatus = metricsHandler != null ? metricsHandler : new TaskCurrentStatus();
    }

    private IBackgroundTaskReporterHandler createDefaultHandler(String taskName, TaskLoggingSystemWrapper logSys) throws ConfigurationException {
        return new DefaultBackgroundTaskReporterHandler(taskName, null, logSys);
    }

    public int getNumberErrors() {
        return this.currentStatus.getErrorActionCount();
    }

    @Override
    public boolean reportActionSuccess(IBackgroundTaskMessage backgroundTaskMessage) {
        boolean state = this.handler.reportActionSuccess(backgroundTaskMessage);
        this.currentStatus.reportActionSuccess();
        return state;
    }

    @Override
    public boolean reportActionException(Throwable throwable, IBackgroundTaskMessage backgroundTaskMessage, String objectType, String objectPath) {
        boolean state = this.handler.reportActionException(throwable, backgroundTaskMessage, objectType, objectPath);
        this.currentStatus.reportActionError();
        return state;
    }

    @Override
    public boolean traceTaskMessage(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.handler.traceTaskMessage(backgroundTaskMessage);
    }

    public void setTaskCurrentStatus(IBackgroundTaskMetricsHandler currentStatus) {
        this.currentStatus = currentStatus;
    }

    @Override
    public String getTaskStatus() {
        return this.currentStatus.getStateOfLastTransaction();
    }

    @Override
    public boolean reportTaskError(Throwable t, IBackgroundTaskMessage backgroundTaskMessage) {
        boolean state = this.handler.reportTaskError(t, backgroundTaskMessage);
        this.currentStatus.reportTaskError();
        return state;
    }

    @Override
    public boolean reportInformation(IBackgroundTaskMessage message) {
        return this.handler.reportInformation(message);
    }

    @Override
    public boolean reportStatus() {
        return this.handler.reportStatus();
    }
}

