/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.BackgroundTaskExecutionContext;
import com.cognos.cm.backgroundTask.BackgroundTaskReporter;
import com.cognos.cm.backgroundTask.BackgroundTaskWorkerSynchronizer;
import com.cognos.cm.backgroundTask.IBackgroundTaskReporter;
import com.cognos.cm.backgroundTask.IBackgroundTaskWorker;
import com.cognos.cm.backgroundTaskPluginAPI.BackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskHandler;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.store.CMStoreNotAvailable;
import org.dom4j.Element;

public class BackgroundTaskWorker
implements IBackgroundTaskWorker {
    private String id;
    private String taskName;
    private IBackgroundTaskHandler taskHandler;
    private IBackgroundTaskExectutionContext context;
    private IBackgroundTaskReporter reporter;
    private BackgroundTaskWorkerSynchronizer synchronizer;
    private boolean isRunning;
    public static Counter inBackgroundTasks = new AllInOneCounter().makeThreadLocal();
    private static Timer timer = new Timer(inBackgroundTasks);

    public BackgroundTaskWorker(String id, String taskName, IBackgroundTaskHandler taskHandler) {
        this(id, taskName, taskHandler, new BackgroundTaskReporter(id));
    }

    public BackgroundTaskWorker(String id, String taskName, IBackgroundTaskHandler taskHandler, IBackgroundTaskReporter reporter) {
        this.id = id;
        this.taskName = taskName;
        this.taskHandler = taskHandler;
        this.reporter = reporter;
    }

    @Override
    public void initialize(BackgroundTaskWorkerSynchronizer workerSynchronizer, Element runOptionsElement) throws Exception {
        this.synchronizer = workerSynchronizer;
        this.setupTaskExecutionContext();
        this.getTaskHandler().initialize(this.context, runOptionsElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.onStarted();
        boolean notComplete = true;
        try {
            while (notComplete) {
                try {
                    this.getTaskHandler().execute(this.context);
                    notComplete = false;
                }
                catch (CMStoreNotAvailable e) {
                    this.reporter.reportTaskError(e, new BackgroundTaskMessage(e.getMessage(), null, 2));
                    this.tearDownExecutionContext();
                    String message = CMError.getMessage("cmBackgroundTaskUnableConnect", null);
                    this.reporter.reportInformation(new BackgroundTaskMessage(message, null, 4));
                    Thread.sleep(this.getDelay());
                    this.setupTaskExecutionContext();
                }
            }
        }
        catch (Exception e) {
            this.reporter.reportTaskError(e, new BackgroundTaskMessage(e.getMessage(), null, 2));
            this.rollbackTransaction();
        }
        finally {
            this.onCompleted();
        }
    }

    private void rollbackTransaction() {
        try {
            this.context.getStore().rollbackOpenTransaction();
        }
        catch (CMException ex) {
            this.reporter.reportTaskError(ex, new BackgroundTaskMessage(ex.getMessage(), null, 2));
        }
    }

    long getDelay() {
        return 60000L;
    }

    protected void onStarted() {
        this.setupTaskExecutionContext();
        this.startTimer();
        this.logInformation("cmBackgroundTaskStarted");
        this.synchronizer.startExecution();
        this.setRunning(true);
    }

    protected void onCompleted() {
        this.context.getReporterHandler().reportStatus();
        this.logInformation("cmBackgroundTaskCompleted");
        this.stopTimer();
        this.tearDownExecutionContext();
        this.synchronizer.finishExecution();
        this.setRunning(false);
    }

    private void setupTaskExecutionContext() {
        this.setupExecutionContext();
        this.context = this.createBackgroundTaskContext();
    }

    protected void setupExecutionContext() {
        CMExecutionContext.setUp();
    }

    protected IBackgroundTaskExectutionContext createBackgroundTaskContext() {
        return new BackgroundTaskExecutionContext(CMExecutionContext.get(), CMQueueManager.getManager(), this.taskName, this.reporter, this.synchronizer);
    }

    protected void tearDownExecutionContext() {
        CMExecutionContext.tearDown();
    }

    private void startTimer() {
        ContentManager.diagnosticsManager.reset();
        timer.start();
    }

    private void stopTimer() {
        timer.stop(this.getId());
        ContentManager.diagnosticsManager.update();
    }

    private void logInformation(String cmMessageCode) {
        CMException cmException = new CMException(cmMessageCode);
        BackgroundTaskMessage taskMessage = new BackgroundTaskMessage(cmException.getLocalizedMessage(), cmException.getListExceptionParms_(), 4);
        this.reporter.reportInformation(taskMessage);
    }

    private synchronized void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public IBackgroundTaskHandler getTaskHandler() {
        return this.taskHandler;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

