/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.IBackgroundTaskWorkerExecutionSynchronizer;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskWorkerReconcileSynchronizer;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BackgroundTaskWorkerSynchronizer
implements IBackgroundTaskWorkerExecutionSynchronizer,
IBackgroundTaskWorkerReconcileSynchronizer {
    private ReentrantReadWriteLock lock;
    private boolean reconciled;
    private String taskName;

    public BackgroundTaskWorkerSynchronizer(String taskName) {
        this.taskName = taskName;
        this.lock = this.createReentrantReadWriteLock();
        this.reconciled = false;
    }

    protected ReentrantReadWriteLock createReentrantReadWriteLock() {
        return new ReentrantReadWriteLock();
    }

    @Override
    public void awaitCompletion() {
        this.lock.writeLock().lock();
        this.lock.writeLock().unlock();
    }

    @Override
    public void startExecution() {
        if (this.lock.writeLock().tryLock()) {
            this.newExecutionStarting();
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().lock();
        }
    }

    @Override
    public void finishExecution() {
        this.lock.readLock().unlock();
    }

    private void newExecutionStarting() {
        this.reconciled = false;
    }

    @Override
    public synchronized void reconcile() throws CMException {
        if (!this.reconciled) {
            this.getQueueManager().reconcileForConsumer(this.getStore(), this.taskName);
            this.reconciled = true;
        }
    }

    protected CMStore getStore() throws CMException {
        return CMExecutionContext.get().getStore();
    }

    protected ICMQueueManager getQueueManager() {
        return CMQueueManager.getManager();
    }

    protected boolean isReconciled() {
        return this.reconciled;
    }

    protected void setReconciled(boolean reconciled) {
        this.reconciled = reconciled;
    }
}

