/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.BackgroundTask;
import com.cognos.cm.backgroundTask.BackgroundTaskReporter;
import com.cognos.cm.backgroundTask.BackgroundTaskRunType;
import com.cognos.cm.backgroundTask.BackgroundTaskWorker;
import com.cognos.cm.backgroundTask.IBackgroundTask;
import com.cognos.cm.backgroundTask.IBackgroundTaskReporter;
import com.cognos.cm.backgroundTask.IBackgroundTasksBuilder;
import com.cognos.cm.backgroundTask.periods.BackgroundPeriodsBuilder;
import com.cognos.cm.backgroundTask.periods.ExecutionPeriod;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodTimer;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodsBuilder;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskHandler;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMetricsHandler;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.IPluginLoader;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class BackgroundTasksBuilder
implements IBackgroundTasksBuilder {
    private static final HashMap<String, Class<?>> pluginClasses = new HashMap();
    private IPluginLoader pluginLoader;
    private IBackgroundPeriodsBuilder backgroundPeriodsBuilder;

    public BackgroundTasksBuilder(IPluginLoader pluginLoader, IBackgroundPeriodsBuilder blackoutPeriodsBuilder) {
        this.pluginLoader = pluginLoader;
        this.backgroundPeriodsBuilder = blackoutPeriodsBuilder;
    }

    public BackgroundTasksBuilder(IPluginLoader pluginLoader) {
        this(pluginLoader, new BackgroundPeriodsBuilder(pluginLoader));
    }

    @Override
    public Map<String, IBackgroundTask> buildTasks(CMResourceLoader resourceLoader, IBackgroundPeriodTimer backgroundPeriodTimer) throws CMException {
        HashMap<String, IBackgroundTask> tasks = new HashMap<String, IBackgroundTask>();
        String[] configFiles = resourceLoader.listResourceNames("/WEB-INF/cm/tasks/config/");
        if (configFiles == null) {
            return tasks;
        }
        for (int i = 0; i < configFiles.length; ++i) {
            String taskConfigurationFileName = configFiles[i];
            if (!taskConfigurationFileName.endsWith(".xml")) continue;
            BackgroundTask task = null;
            try {
                task = this.createBackgroundTaskFromConfigurationFile(taskConfigurationFileName, backgroundPeriodTimer);
            }
            catch (Exception ex) {
                CMIndications.logException(new CMException("cmErrorParsingTaskConfig", new CMException.Parm("File", taskConfigurationFileName), new CMException.Parm("Message", ex.getMessage())));
                continue;
            }
            if (tasks.containsKey(task.getName())) {
                throw new CMException("cmErrorTaskNameNotUnique", new CMException.Parm("Name", task.getName()));
            }
            if (!taskConfigurationFileName.equalsIgnoreCase(task.getName() + ".xml")) {
                throw new CMException("cmErrorTaskNameDoesNotMatchFileName", new CMException.Parm("File", taskConfigurationFileName), new CMException.Parm("Name", task.getName()));
            }
            tasks.put(task.getName(), task);
        }
        return tasks;
    }

    @Override
    public IBackgroundTask buildTask(String taskName, CMResourceLoader resourceLoader, IBackgroundPeriodTimer backgroundPeriodTimer) throws CMException {
        String[] configFiles = resourceLoader.listResourceNames("/WEB-INF/cm/tasks/config/");
        if (configFiles != null) {
            for (int i = 0; i < configFiles.length; ++i) {
                String taskConfigurationFileName = configFiles[i];
                if (!taskConfigurationFileName.equalsIgnoreCase(taskName + ".xml")) continue;
                return this.createBackgroundTaskFromConfigurationFile(taskConfigurationFileName, backgroundPeriodTimer);
            }
        }
        throw new CMException("cmErrorTaskConfigFileNotFound", new CMException.Parm("File", taskName + ".xml"));
    }

    private BackgroundTask createBackgroundTaskFromConfigurationFile(String taskConfigurationFileName, IBackgroundPeriodTimer backgroundPeriodTimer) throws CMException {
        String taskConfigurationResourceName = "/WEB-INF/cm/tasks/config/" + taskConfigurationFileName;
        try {
            return this.createTaskFromResource(taskConfigurationResourceName, backgroundPeriodTimer);
        }
        catch (CMException cmex) {
            throw cmex;
        }
        catch (Throwable ex) {
            throw this.pluginLoader.createConfigurationParsingException(taskConfigurationResourceName, ex);
        }
    }

    protected BackgroundTask createTaskFromResource(String taskConfigurationResourceName, IBackgroundPeriodTimer backgroundPeriodTimer) throws CMException {
        Document taskConfigurationDocument = this.pluginLoader.getPluginConfigurationDocument(taskConfigurationResourceName);
        try {
            Element rootNode = taskConfigurationDocument.getRootElement();
            int defaultNumberOfWorkerThreads = this.getDefaultThreads(rootNode);
            List<ExecutionPeriod> executionPeriods = this.getExecutionPeriods(rootNode, taskConfigurationResourceName, defaultNumberOfWorkerThreads);
            int maximumNumberOfWorkerThreads = this.getMaximumNumberOfWorkerThreads(executionPeriods, defaultNumberOfWorkerThreads);
            if (maximumNumberOfWorkerThreads < defaultNumberOfWorkerThreads) {
                defaultNumberOfWorkerThreads = maximumNumberOfWorkerThreads;
            }
            BackgroundTask task = this.createTaskFromConfigurationElement(taskConfigurationResourceName, rootNode, maximumNumberOfWorkerThreads, defaultNumberOfWorkerThreads);
            task.initialize(taskConfigurationDocument);
            this.addExecutionPeriodsForTask(task, executionPeriods, backgroundPeriodTimer);
            return task;
        }
        catch (Throwable ex) {
            throw this.pluginLoader.createConfigurationParsingException(taskConfigurationResourceName, ex);
        }
    }

    private int getMaximumNumberOfWorkerThreads(List<ExecutionPeriod> executionPeriods, int defaultThreads) {
        if (executionPeriods == null || executionPeriods.size() <= 0) {
            return defaultThreads;
        }
        int maxNumberOfWorkerThreads = 0;
        for (ExecutionPeriod period : executionPeriods) {
            int numberOfWorkerThreads = period.getNumberOfWorkerThreads();
            if (numberOfWorkerThreads <= maxNumberOfWorkerThreads) continue;
            maxNumberOfWorkerThreads = numberOfWorkerThreads;
        }
        return maxNumberOfWorkerThreads;
    }

    private List<ExecutionPeriod> getExecutionPeriods(Element rootNode, String taskConfigurationResourceName, int defaultNumberOfWorkerThreads) throws CMException {
        Element executionPeriodsElement = rootNode.element("executionPeriods");
        if (executionPeriodsElement != null) {
            return this.backgroundPeriodsBuilder.buildExecutionPeriods(executionPeriodsElement, taskConfigurationResourceName, defaultNumberOfWorkerThreads);
        }
        return null;
    }

    private void addExecutionPeriodsForTask(BackgroundTask task, List<ExecutionPeriod> executionPeriods, IBackgroundPeriodTimer backgroundPeriodTimer) {
        if (executionPeriods != null && executionPeriods.size() > 0) {
            task.setHasExecutionPeriods(true);
            backgroundPeriodTimer.addTaskExecutionPeriods(task.getName(), executionPeriods);
        }
    }

    protected BackgroundTask createTaskFromConfigurationElement(String taskConfigurationResourceName, Element rootNode, int totalNumberOfWorkerThreads, int defaultNumberOfWorkerThreads) throws Exception, IllegalAccessException, InstantiationException, IllegalArgumentException {
        ArrayList parameterClasses = new ArrayList();
        ArrayList<Object> parameterObjects = new ArrayList<Object>();
        String taskName = this.addRequiredParameterName(rootNode, taskConfigurationResourceName, parameterClasses, parameterObjects);
        BackgroundTaskRunType runType = this.addRequiredParameterRunType(rootNode, taskConfigurationResourceName, parameterClasses, parameterObjects);
        this.addOptionalParameterRestartInMillis(rootNode, taskName, parameterClasses, parameterObjects, runType);
        this.addParameterTaskWorkers(rootNode, taskConfigurationResourceName, parameterClasses, parameterObjects, taskName, totalNumberOfWorkerThreads);
        this.addParameterDefaultNumberofWorkers(parameterClasses, parameterObjects, defaultNumberOfWorkerThreads);
        this.addOptionalParameterExplicitStartOnly(rootNode, parameterClasses, parameterObjects);
        BackgroundTask task = (BackgroundTask)BackgroundTask.class.getConstructor(parameterClasses.toArray(new Class[0])).newInstance(parameterObjects.toArray());
        return task;
    }

    private void addParameterDefaultNumberofWorkers(ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, int defaultNumberOfWorkerThreads) {
        parameterClasses.add(Integer.TYPE);
        parameterObjects.add(defaultNumberOfWorkerThreads);
    }

    private void addParameterTaskWorkers(Element rootNode, String taskConfigurationResourceName, ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, String taskName, int totalNumberOfWorkerThreads) throws CMException, Exception {
        List<BackgroundTaskWorker> workers = this.createBackgroundTaskWorkers(totalNumberOfWorkerThreads, taskConfigurationResourceName, rootNode, taskName);
        parameterClasses.add(List.class);
        parameterObjects.add(workers);
    }

    private int getDefaultThreads(Element rootNode) {
        int defaultThreads = 1;
        String defaultThreadsString = rootNode.attributeValue("defaultThreads");
        if (defaultThreadsString != null && defaultThreadsString.length() > 0) {
            defaultThreads = Integer.parseInt(defaultThreadsString);
        }
        return defaultThreads;
    }

    private List<BackgroundTaskWorker> createBackgroundTaskWorkers(int numberOfWorkers, String taskConfigurationResourceName, Element rootNode, String taskName) throws CMException, Exception {
        LinkedList<BackgroundTaskWorker> workers = new LinkedList<BackgroundTaskWorker>();
        for (int i = 1; i <= numberOfWorkers; ++i) {
            ArrayList parameterClasses = new ArrayList();
            ArrayList<Object> parameterObjects = new ArrayList<Object>();
            this.addParameterWorkerId(parameterClasses, parameterObjects, taskName, i);
            this.addParameterTaskName(parameterClasses, parameterObjects, taskName);
            this.addRequiredParameterTaskHandler(rootNode, taskConfigurationResourceName, parameterClasses, parameterObjects);
            this.addParameterReportHandlerWrapper(rootNode, parameterClasses, parameterObjects, taskName);
            BackgroundTaskWorker worker = (BackgroundTaskWorker)BackgroundTaskWorker.class.getConstructor(parameterClasses.toArray(new Class[0])).newInstance(parameterObjects.toArray());
            workers.add(worker);
        }
        return workers;
    }

    private void addParameterWorkerId(ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, String taskName, int workerNumber) {
        parameterClasses.add(String.class);
        parameterObjects.add(taskName + "_" + workerNumber);
    }

    private void addParameterTaskName(ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, String taskName) {
        parameterClasses.add(String.class);
        parameterObjects.add(taskName);
    }

    private void addParameterReportHandlerWrapper(Element rootNode, ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, String taskName) throws CMException, Exception {
        IBackgroundTaskReporterHandler reportHandler = this.createBackgroundTaskReporterHandler(rootNode, taskName);
        IBackgroundTaskMetricsHandler metricsHandler = this.createBackgroundTaskMetricsHandler(rootNode);
        parameterClasses.add(IBackgroundTaskReporter.class);
        parameterObjects.add(new BackgroundTaskReporter(reportHandler, metricsHandler, taskName));
    }

    private void addOptionalParameterRestartInMillis(Element rootNode, String taskName, ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects, BackgroundTaskRunType runType) throws CMException {
        long restartInMillis = this.getRestartInMillis(rootNode);
        this.validateRestartInMillis(taskName, restartInMillis, runType);
        parameterClasses.add(Long.TYPE);
        parameterObjects.add(restartInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackgroundTaskMetricsHandler createBackgroundTaskMetricsHandler(Element rootNode) throws Exception {
        IBackgroundTaskMetricsHandler metricsHandler = null;
        String metricsHandlerClassName = rootNode.attributeValue("metricsHandler");
        if (metricsHandlerClassName != null && metricsHandlerClassName.length() > 0) {
            Class<?> metricsHandlerClass;
            HashMap<String, Class<?>> hashMap = pluginClasses;
            synchronized (hashMap) {
                metricsHandlerClass = this.pluginLoader.getPluginWithCaching(pluginClasses, metricsHandlerClassName);
            }
            metricsHandler = (IBackgroundTaskMetricsHandler)metricsHandlerClass.newInstance();
        }
        return metricsHandler;
    }

    private void addOptionalParameterExplicitStartOnly(Element rootNode, ArrayList<Class<?>> classes, ArrayList<Object> objects) {
        String explicitStartOnlyValue = rootNode.attributeValue("explicitStartOnly");
        boolean explicitStartOnly = false;
        if (explicitStartOnlyValue != null && explicitStartOnlyValue.length() > 0) {
            explicitStartOnly = Boolean.parseBoolean(explicitStartOnlyValue);
        }
        classes.add(Boolean.TYPE);
        objects.add(explicitStartOnly);
    }

    private BackgroundTaskRunType addRequiredParameterRunType(Element rootNode, String taskConfigurationResourceName, ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects) throws CMException {
        BackgroundTaskRunType runType = this.createBackgroundTaskRunType(taskConfigurationResourceName, rootNode);
        parameterClasses.add(BackgroundTaskRunType.class);
        parameterObjects.add((Object)runType);
        return runType;
    }

    private void addRequiredParameterTaskHandler(Element rootNode, String taskConfigurationResourceName, ArrayList<Class<?>> parameterClasses, ArrayList<Object> parameterObjects) throws CMException, Exception {
        IBackgroundTaskHandler taskHandler = this.createBackgroundTaskHandler(taskConfigurationResourceName, rootNode);
        parameterClasses.add(IBackgroundTaskHandler.class);
        parameterObjects.add(taskHandler);
    }

    private String addRequiredParameterName(Element rootNode, String taskConfigurationResourceName, ArrayList<Class<?>> classes, ArrayList<Object> objects) throws CMException {
        String name = this.pluginLoader.getRequiredAttribute(rootNode, "name", taskConfigurationResourceName);
        classes.add(String.class);
        objects.add(name);
        return name;
    }

    private BackgroundTaskRunType createBackgroundTaskRunType(String taskConfigurationResourceName, Element rootNode) throws CMException {
        String runTypeString = this.pluginLoader.getRequiredAttribute(rootNode, "runType", taskConfigurationResourceName);
        return BackgroundTaskRunType.valueOf(runTypeString.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackgroundTaskHandler createBackgroundTaskHandler(String taskConfigurationResourceName, Element rootNode) throws CMException, Exception {
        Class<?> taskHandlerClass;
        String taskHandlerClassName = this.pluginLoader.getRequiredAttribute(rootNode, "taskHandler", taskConfigurationResourceName);
        HashMap<String, Class<?>> hashMap = pluginClasses;
        synchronized (hashMap) {
            taskHandlerClass = this.pluginLoader.getPluginWithCaching(pluginClasses, taskHandlerClassName);
        }
        IBackgroundTaskAction action = this.createBackgroundTaskAction(rootNode);
        IBackgroundTaskHandler handler = action != null ? (IBackgroundTaskHandler)taskHandlerClass.getConstructor(IBackgroundTaskAction.class).newInstance(action) : (IBackgroundTaskHandler)taskHandlerClass.newInstance();
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackgroundTaskAction createBackgroundTaskAction(Element rootNode) throws CMException, Exception {
        IBackgroundTaskAction action = null;
        String actionClassName = rootNode.attributeValue("taskAction");
        if (actionClassName != null && actionClassName.length() > 0) {
            Class<?> actionClass;
            HashMap<String, Class<?>> hashMap = pluginClasses;
            synchronized (hashMap) {
                actionClass = this.pluginLoader.getPluginWithCaching(pluginClasses, actionClassName);
            }
            action = (IBackgroundTaskAction)actionClass.newInstance();
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackgroundTaskReporterHandler createBackgroundTaskReporterHandler(Element rootNode, String taskName) throws CMException, Exception {
        IBackgroundTaskReporterHandler reportHandler = null;
        String reportHandlerClassName = rootNode.attributeValue("reportHandler");
        if (reportHandlerClassName != null && reportHandlerClassName.length() > 0) {
            Class<?> reportHandlerClass;
            Element reporterHandlerOptions = rootNode.element("reportHandlerOptions");
            HashMap<String, Class<?>> hashMap = pluginClasses;
            synchronized (hashMap) {
                reportHandlerClass = this.pluginLoader.getPluginWithCaching(pluginClasses, reportHandlerClassName);
            }
            reportHandler = (IBackgroundTaskReporterHandler)reportHandlerClass.getConstructor(String.class, Element.class).newInstance(taskName, reporterHandlerOptions);
        }
        return reportHandler;
    }

    private long getRestartInMillis(Element node) {
        double restartInMinutes = 0.0;
        String restartInMinutesString = node.attributeValue("restartInMinutes");
        if (restartInMinutesString != null && restartInMinutesString.length() > 0) {
            restartInMinutes = new Double(restartInMinutesString);
        }
        return this.convertMinutesToMillis(restartInMinutes);
    }

    private void validateRestartInMillis(String taskName, long restartInMillis, BackgroundTaskRunType runType) throws CMException {
        if (runType.equals((Object)BackgroundTaskRunType.RUN_ONCE) && restartInMillis > 0L || (runType.equals((Object)BackgroundTaskRunType.FIXED_DELAY) || runType.equals((Object)BackgroundTaskRunType.FIXED_RATE)) && restartInMillis <= 0L) {
            throw new CMException("cmErrorIllegalTaskRestartTime", new CMException.Parm("Name", taskName), new CMException.Parm("Restart", String.valueOf(restartInMillis)));
        }
    }

    private long convertMinutesToMillis(double restartInMinutes) {
        return (long)(restartInMinutes * 60.0 * 1000.0);
    }
}

