/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.BackgroundTask;
import com.cognos.cm.backgroundTask.BackgroundTasksBuilder;
import com.cognos.cm.backgroundTask.BackgroundTasksManagerConfigurator;
import com.cognos.cm.backgroundTask.IBackgroundTask;
import com.cognos.cm.backgroundTask.IBackgroundTaskWorker;
import com.cognos.cm.backgroundTask.IBackgroundTasksBuilder;
import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManagerConfigurator;
import com.cognos.cm.backgroundTask.periods.BackgroundPeriodTimer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.PluginLoader;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;

public class BackgroundTasksManager
implements IBackgroundTasksManager {
    private static final long ZERO_DELAY = 0L;
    private static IBackgroundTasksManager manager = new BackgroundTasksManager();
    private static boolean isStarted = false;
    int corePoolSize = 7;
    private ScheduledExecutorService tasksExecutor;
    private Map<String, IBackgroundTask> tasks;
    private Map<String, ScheduledFuture<?>> taskWorkerScheduledFutures;
    private IBackgroundTasksBuilder tasksBuilder;
    private IBackgroundTasksManagerConfigurator configurator;
    private BackgroundPeriodTimer backgroundPeriodTimer;
    private Map<String, BlackedOutTaskInformation> blackedOutTasksInformation;
    private boolean inBlackoutPeriod;

    protected BackgroundTasksManager() {
    }

    public static IBackgroundTasksManager getManager() {
        return manager;
    }

    @Override
    public synchronized void start(boolean startTasks) throws CMException {
        this.ensureManagerNotStarted();
        isStarted = true;
        try {
            this.initialize(CMResourceUtils.getResourceLoader());
        }
        catch (CMException e) {
            isStarted = false;
            throw e;
        }
        if (startTasks) {
            this.innerStartAllTasks(false);
        }
    }

    @Override
    public synchronized void stop() throws CMException {
        this.ensureManagerStarted();
        isStarted = false;
        this.reset();
    }

    private void initialize(CMResourceLoader resourceLoader) throws CMException {
        this.taskWorkerScheduledFutures = new HashMap();
        this.backgroundPeriodTimer = new BackgroundPeriodTimer();
        this.blackedOutTasksInformation = new HashMap<String, BlackedOutTaskInformation>();
        this.inBlackoutPeriod = false;
        if (this.tasksBuilder == null) {
            this.tasksBuilder = new BackgroundTasksBuilder(PluginLoader.get());
        }
        this.tasks = this.tasksBuilder.buildTasks(resourceLoader, this.backgroundPeriodTimer);
        this.initializeManagerConfiguration();
        this.createThreadPoolExecutor();
    }

    private void createThreadPoolExecutor() {
        this.tasksExecutor = new ScheduledThreadPoolExecutor(this.corePoolSize);
    }

    private void reset() {
        this.tasksExecutor.shutdownNow();
        this.backgroundPeriodTimer.removeAllTasksBackgroundPeriods();
        for (String taskName : this.tasks.keySet()) {
            this.backgroundPeriodTimer.removeTaskBackgroundPeriods(taskName);
        }
        this.backgroundPeriodTimer.stopTimer();
        this.clearVariables();
    }

    private void clearVariables() {
        this.tasks.clear();
        this.taskWorkerScheduledFutures.clear();
        this.blackedOutTasksInformation.clear();
        this.tasksBuilder = null;
        this.backgroundPeriodTimer = null;
        this.configurator = null;
    }

    private void initializeManagerConfiguration() throws CMException {
        if (this.configurator == null) {
            this.configurator = new BackgroundTasksManagerConfigurator(PluginLoader.get());
        }
        this.configurator.configure(this.backgroundPeriodTimer, this);
    }

    private void reload() throws CMException {
        this.reset();
        this.initialize(CMResourceUtils.getResourceLoader());
    }

    @Override
    public synchronized void startAllTasks(boolean reloadConfiguration) throws CMException {
        this.ensureManagerStarted();
        if (reloadConfiguration) {
            this.reload();
        }
        this.innerStartAllTasks(true);
    }

    private void innerStartAllTasks(boolean startTaskIfInBlackoutPeriod) {
        Iterator<IBackgroundTask> tasksIterator = this.tasks.values().iterator();
        Date currentDate = new Date();
        while (tasksIterator.hasNext()) {
            IBackgroundTask task = tasksIterator.next();
            if (startTaskIfInBlackoutPeriod || !this.isInBlackoutPeriod()) {
                if (task.hasExecutionPeriods() || task.explicitStartOnly()) continue;
                this.startTask(task, 0L);
                continue;
            }
            this.blackedOutTasksInformation.put(task.getName(), new BlackedOutTaskInformation(currentDate, 0L, task.getDefaultNumberofWorkers()));
        }
    }

    private void startTask(IBackgroundTask task, long initialDelay) {
        for (IBackgroundTaskWorker worker : task.getWorkers()) {
            this.startTaskWorker(worker, task, initialDelay);
        }
    }

    private void startTaskWorker(IBackgroundTaskWorker worker, IBackgroundTask task, long initialDelay) {
        if (this.isTaskWorkerScheduled(worker) || this.isTaskWorkerRunning(worker)) {
            return;
        }
        switch (task.getRunType()) {
            case FIXED_DELAY: {
                this.taskWorkerScheduledFutures.put(worker.getId(), this.tasksExecutor.scheduleWithFixedDelay(worker, initialDelay, task.getRestartInMillis(), TimeUnit.MILLISECONDS));
                break;
            }
            case FIXED_RATE: {
                this.taskWorkerScheduledFutures.put(worker.getId(), this.tasksExecutor.scheduleAtFixedRate(worker, initialDelay, task.getRestartInMillis(), TimeUnit.MILLISECONDS));
                break;
            }
            case RUN_ONCE: {
                this.taskWorkerScheduledFutures.put(worker.getId(), this.tasksExecutor.schedule(worker, initialDelay, TimeUnit.MILLISECONDS));
                break;
            }
        }
    }

    @Override
    public synchronized void startTask(String taskName, boolean reloadTaskConfiguration) throws CMException {
        this.ensureManagerStarted();
        if (reloadTaskConfiguration) {
            if (this.isTaskPresent(taskName)) {
                this.stopTask(taskName);
            }
            this.reloadTask(taskName);
        }
        this.ensureTaskExists(taskName);
        this.startTask(this.tasks.get(taskName), 0L);
    }

    @Override
    public synchronized void stopAllTasks() throws CMException {
        this.ensureManagerStarted();
        Iterator<String> scheduledTaskNamesIterator = this.taskWorkerScheduledFutures.keySet().iterator();
        while (scheduledTaskNamesIterator.hasNext()) {
            this.taskWorkerScheduledFutures.get(scheduledTaskNamesIterator.next()).cancel(true);
            scheduledTaskNamesIterator.remove();
        }
    }

    @Override
    public synchronized void stopTask(String taskName) throws CMException {
        this.ensureManagerStarted();
        this.ensureTaskExists(taskName);
        for (IBackgroundTaskWorker worker : this.tasks.get(taskName).getWorkers()) {
            this.stopTaskWorker(worker);
        }
    }

    private void stopTaskWorker(IBackgroundTaskWorker worker) {
        if (!this.isTaskWorkerScheduled(worker)) {
            return;
        }
        String taskWorkerId = worker.getId();
        this.taskWorkerScheduledFutures.get(taskWorkerId).cancel(true);
        this.taskWorkerScheduledFutures.remove(taskWorkerId);
    }

    private boolean isTaskPresent(String taskName) {
        return this.tasks.containsKey(taskName);
    }

    @Override
    public synchronized boolean isTaskScheduled(String taskName) throws CMException {
        this.ensureManagerStarted();
        if (this.isTaskPresent(taskName)) {
            for (IBackgroundTaskWorker worker : this.tasks.get(taskName).getWorkers()) {
                if (!this.isTaskWorkerScheduled(worker)) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumberOfTaskWorkersScheduled(String taskName) {
        int count = 0;
        for (IBackgroundTaskWorker worker : this.tasks.get(taskName).getWorkers()) {
            if (!this.isTaskWorkerScheduled(worker)) continue;
            ++count;
        }
        return count;
    }

    private boolean isTaskWorkerScheduled(IBackgroundTaskWorker taskWorker) {
        String taskWorkerId = taskWorker.getId();
        if (this.taskWorkerScheduledFutures.containsKey(taskWorkerId) && this.taskWorkerScheduledFutures.get(taskWorkerId).isDone() && !this.isTaskWorkerRunning(taskWorker)) {
            this.taskWorkerScheduledFutures.remove(taskWorkerId);
        }
        return this.taskWorkerScheduledFutures.containsKey(taskWorkerId);
    }

    @Override
    public void ensureTaskIsRunning(String taskName) throws CMException {
        if (!this.isTaskRunning(taskName)) {
            this.startTask(taskName, false);
        }
    }

    @Override
    public synchronized boolean isTaskRunning(String taskName) throws CMException {
        this.ensureManagerStarted();
        return this.isTaskPresent(taskName) && this.getRunningWorkersCount(this.tasks.get(taskName)) > 0;
    }

    private int getRunningWorkersCount(IBackgroundTask task) {
        int count = 0;
        for (IBackgroundTaskWorker worker : task.getWorkers()) {
            if (!this.isTaskWorkerRunning(worker)) continue;
            ++count;
        }
        return count;
    }

    private boolean isTaskWorkerRunning(IBackgroundTaskWorker taskWorker) {
        return taskWorker.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTaskCompletion(String taskName) throws CMException {
        BackgroundTask task;
        BackgroundTasksManager backgroundTasksManager = this;
        synchronized (backgroundTasksManager) {
            this.ensureManagerStarted();
            this.ensureTaskExists(taskName);
            task = (BackgroundTask)this.tasks.get(taskName);
        }
        task.waitForCompletion();
    }

    @Override
    public synchronized Set<String> getConfiguredTaskNames() throws CMException {
        this.ensureManagerStarted();
        return this.tasks.keySet();
    }

    private void reloadTask(String taskName) throws CMException {
        this.backgroundPeriodTimer.removeTaskBackgroundPeriods(taskName);
        this.blackedOutTasksInformation.remove(taskName);
        this.tasks.put(taskName, this.tasksBuilder.buildTask(taskName, CMResourceUtils.getResourceLoader(), this.backgroundPeriodTimer));
    }

    @Override
    public synchronized String getTaskStatus(String taskName) throws CMException {
        this.ensureManagerStarted();
        this.ensureTaskExists(taskName);
        return this.tasks.get(taskName).getStatus();
    }

    @Override
    public synchronized Element getTaskRunOptions(String taskName) throws CMException {
        this.ensureManagerStarted();
        this.ensureTaskExists(taskName);
        return this.tasks.get(taskName).getRunOptions();
    }

    private void ensureTaskExists(String taskName) throws CMException {
        if (!this.isTaskPresent(taskName)) {
            throw new CMException("cmErrorTaskDoesNotExist", new CMException.Parm("Name", taskName));
        }
    }

    private void ensureManagerStarted() throws CMException {
        if (!this.isStarted()) {
            this.throwManagerNotStartedException();
        }
    }

    @Override
    public boolean isStarted() {
        return isStarted;
    }

    private void ensureManagerNotStarted() throws CMException {
        if (this.isStarted()) {
            this.throwManagerAlreadyStartedException();
        }
    }

    private void throwManagerNotStartedException() throws CMException {
        throw new CMException("cmErrorTasksManagerNotStarted");
    }

    private void throwManagerAlreadyStartedException() throws CMException {
        throw new CMException("cmErrorTasksManagerAlreadyStarted");
    }

    protected Date getDate() {
        return new Date();
    }

    @Override
    public synchronized void startBlackoutPeriod() throws CMException {
        this.ensureManagerStarted();
        this.inBlackoutPeriod = true;
        Date date = this.getDate();
        for (String taskName : this.tasks.keySet()) {
            this.startBlackoutPeriodForTask(taskName, date);
        }
    }

    @Override
    public synchronized void stopBlackoutPeriod() throws CMException {
        this.ensureManagerStarted();
        this.inBlackoutPeriod = false;
        Date date = this.getDate();
        for (String taskName : this.tasks.keySet()) {
            this.stopBlackoutPeriodForTask(taskName, date);
        }
    }

    @Override
    public synchronized void startExecutionPeriodForTask(String taskName, int numberOfWorkers) throws CMException {
        this.ensureManagerStarted();
        this.ensureTaskExists(taskName);
        this.ensureWorkersRunning(taskName, numberOfWorkers, 0L);
    }

    private void ensureWorkersRunning(String taskName, int numberOfWorkers, long delay) {
        block7: {
            ArrayList<IBackgroundTaskWorker> stoppedWorkers;
            ArrayList<IBackgroundTaskWorker> runningWorkers;
            block6: {
                if (this.isInBlackoutPeriod()) {
                    this.blackedOutTasksInformation.put(taskName, new BlackedOutTaskInformation(Calendar.getInstance().getTime(), delay, numberOfWorkers));
                    return;
                }
                runningWorkers = new ArrayList<IBackgroundTaskWorker>();
                stoppedWorkers = new ArrayList<IBackgroundTaskWorker>();
                for (IBackgroundTaskWorker worker : this.tasks.get(taskName).getWorkers()) {
                    if (this.isTaskWorkerRunning(worker)) {
                        runningWorkers.add(worker);
                        continue;
                    }
                    if (this.isTaskWorkerScheduled(worker)) {
                        this.stopTaskWorker(worker);
                    }
                    stoppedWorkers.add(worker);
                }
                if (runningWorkers.size() <= numberOfWorkers) break block6;
                for (int i = 0; i < runningWorkers.size() - numberOfWorkers; ++i) {
                    this.stopTaskWorker((IBackgroundTaskWorker)runningWorkers.get(i));
                }
                break block7;
            }
            if (numberOfWorkers <= runningWorkers.size()) break block7;
            for (int i = 0; i < numberOfWorkers - runningWorkers.size(); ++i) {
                this.startTaskWorker((IBackgroundTaskWorker)stoppedWorkers.get(i), this.tasks.get(taskName), delay);
            }
        }
    }

    private void startBlackoutPeriodForTask(String taskName, Date currentDate) throws CMException {
        if (this.isTaskRunning(taskName) || this.isTaskScheduled(taskName)) {
            long delay = this.isTaskRunning(taskName) ? 0L : this.taskWorkerScheduledFutures.get(this.tasks.get(taskName).getWorkers().get(0).getId()).getDelay(TimeUnit.MILLISECONDS);
            this.blackedOutTasksInformation.put(taskName, new BlackedOutTaskInformation(currentDate, delay, this.getNumberOfTaskWorkersScheduled(taskName)));
            this.stopTask(taskName);
        }
    }

    private void stopBlackoutPeriodForTask(String taskName, Date currentDate) {
        if (this.wasTaskBlackedOut(taskName)) {
            long elapsedTime = currentDate.getTime() - this.blackedOutTasksInformation.get(taskName).getBlackoutPeriodStartTime().getTime();
            long remainingDelay = this.blackedOutTasksInformation.get(taskName).getRemainingDelayAtStartTime() - elapsedTime;
            int numberOfWorkers = this.blackedOutTasksInformation.get(taskName).getNumberOfBlackedOutWorkers();
            this.blackedOutTasksInformation.remove(taskName);
            this.ensureWorkersRunning(taskName, numberOfWorkers, remainingDelay);
        }
    }

    private boolean wasTaskBlackedOut(String taskName) {
        return this.blackedOutTasksInformation.containsKey(taskName);
    }

    protected void setThreadPoolExecutor(ScheduledExecutorService tasksExecutor) {
        this.tasksExecutor = tasksExecutor;
    }

    protected Collection<ScheduledFuture<?>> getSchedules() {
        return this.taskWorkerScheduledFutures.values();
    }

    protected void setTasksBuilder(IBackgroundTasksBuilder tasksBuilder) {
        this.tasksBuilder = tasksBuilder;
    }

    protected void setTasks(Map<String, IBackgroundTask> tasks) {
        this.tasks = tasks;
    }

    protected void setConfigurator(IBackgroundTasksManagerConfigurator tasksManagerConfigurator) {
        this.configurator = tasksManagerConfigurator;
    }

    @Override
    public void setCorePoolSize(int aCorePoolSize) {
        if (aCorePoolSize >= 1) {
            this.corePoolSize = aCorePoolSize;
        }
    }

    protected boolean isInBlackoutPeriod() {
        return this.inBlackoutPeriod;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.tasksExecutor;
    }

    private class BlackedOutTaskInformation {
        private Date blackoutPeriodStartTime;
        private long remainingDelayAtStartTime;
        private int numberOfBlackedOutWorkers;

        public BlackedOutTaskInformation(Date blackoutPeriodStartTime, long remainingDelayAtStartTime, int numberOfBlackedOutWorkers) {
            this.blackoutPeriodStartTime = blackoutPeriodStartTime;
            this.remainingDelayAtStartTime = remainingDelayAtStartTime;
            this.numberOfBlackedOutWorkers = numberOfBlackedOutWorkers;
        }

        public Date getBlackoutPeriodStartTime() {
            return this.blackoutPeriodStartTime;
        }

        public long getRemainingDelayAtStartTime() {
            return this.remainingDelayAtStartTime;
        }

        public int getNumberOfBlackedOutWorkers() {
            return this.numberOfBlackedOutWorkers;
        }
    }
}

