/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManagerConfigurator;
import com.cognos.cm.backgroundTask.periods.BackgroundPeriod;
import com.cognos.cm.backgroundTask.periods.BackgroundPeriodsBuilder;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodTimer;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodsBuilder;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.IPluginLoader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class BackgroundTasksManagerConfigurator
implements IBackgroundTasksManagerConfigurator {
    private IPluginLoader pluginLoader;
    private IBackgroundPeriodsBuilder blackoutPeriodsBuilder;

    public BackgroundTasksManagerConfigurator(IPluginLoader pluginLoader, IBackgroundPeriodsBuilder blackoutPeriodsBuilder) {
        this.pluginLoader = pluginLoader;
        this.blackoutPeriodsBuilder = blackoutPeriodsBuilder;
    }

    public BackgroundTasksManagerConfigurator(IPluginLoader pluginLoader) {
        this(pluginLoader, new BackgroundPeriodsBuilder(pluginLoader));
    }

    @Override
    public void configure(IBackgroundPeriodTimer backgroundPeriodTimer, IBackgroundTasksManager manager) throws CMException {
        Document tasksManagerConfigurationDocument = this.pluginLoader.getPluginConfigurationDocument("/WEB-INF/cm/tasks/manager/tasksManager.xml");
        try {
            Element rootNode = tasksManagerConfigurationDocument.getRootElement();
            this.createBlackoutPeriods(backgroundPeriodTimer, rootNode, "/WEB-INF/cm/tasks/manager/tasksManager.xml");
            this.setThreadPoolSize(rootNode, manager);
        }
        catch (Throwable ex) {
            throw this.pluginLoader.createConfigurationParsingException("/WEB-INF/cm/tasks/manager/tasksManager.xml", ex);
        }
    }

    private void createBlackoutPeriods(IBackgroundPeriodTimer backgroundPeriodTimer, Element rootNode, String managerConfigurationResourceName) throws CMException {
        Element blackoutPeriodsElement = rootNode.element("blackoutPeriods");
        List<BackgroundPeriod> blackoutPeriods = this.blackoutPeriodsBuilder.buildBlackoutPeriods(blackoutPeriodsElement, managerConfigurationResourceName);
        backgroundPeriodTimer.addAllTasksBlackoutPeriods(blackoutPeriods);
    }

    private void setThreadPoolSize(Element rootNode, IBackgroundTasksManager manager) throws CMException {
        int threadPoolSize;
        Element threadPoolSizeNode = rootNode.element("threadPoolSize");
        if (threadPoolSizeNode == null) {
            return;
        }
        String aThreadPoolSize = threadPoolSizeNode.getTextTrim();
        try {
            threadPoolSize = Integer.parseInt(aThreadPoolSize);
        }
        catch (NumberFormatException ex) {
            throw new CMException(ex, "cmErrorInvalidThreadPoolSize");
        }
        manager.setCorePoolSize(threadPoolSize);
    }
}

