/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.TaskLoggingSystemWrapper;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cmutils.config.ConfigurationException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.dom4j.Element;

public class DefaultBackgroundTaskReporterHandler
implements IBackgroundTaskReporterHandler {
    protected TaskLoggingSystemWrapper logSys_;
    private String taskName;

    public DefaultBackgroundTaskReporterHandler(String taskName, Element options) throws ConfigurationException {
        this.initialize(taskName, options, null);
    }

    public DefaultBackgroundTaskReporterHandler(String taskName, Element options, TaskLoggingSystemWrapper logSys) throws ConfigurationException {
        this.initialize(taskName, options, logSys);
    }

    private void initialize(String taskName, Element options, TaskLoggingSystemWrapper logSys) throws ConfigurationException {
        this.taskName = taskName;
        this.logSys_ = logSys == null ? new TaskLoggingSystemWrapper(taskName) : logSys;
        this.logSys_.initialize();
    }

    @Override
    public boolean reportActionException(Throwable throwable, IBackgroundTaskMessage backgroundTaskMessage, String objectType, String objectPath) {
        return this.reportTaskError(throwable, backgroundTaskMessage);
    }

    @Override
    public boolean reportActionSuccess(IBackgroundTaskMessage backgroundTaskMessage) {
        if (this.logSuccessToAudit()) {
            this.printSuccessToAudit(backgroundTaskMessage);
        }
        if (this.logSuccessToTrace(backgroundTaskMessage)) {
            this.printSuccessToTrace(backgroundTaskMessage);
        }
        return true;
    }

    protected boolean logSuccessToAudit() {
        return false;
    }

    protected void printSuccessToAudit(IBackgroundTaskMessage backgroundTaskMessage) {
    }

    protected boolean logSuccessToTrace(IBackgroundTaskMessage backgroundTaskMessage) {
        return false;
    }

    protected void printSuccessToTrace(IBackgroundTaskMessage backgroundTaskMessage) {
        this.printMessageToTrace(backgroundTaskMessage);
    }

    public void setLoggingSystem(TaskLoggingSystemWrapper logSys) {
        this.logSys_ = logSys;
    }

    @Override
    public boolean reportTaskError(Throwable throwable, IBackgroundTaskMessage backgroundTaskMessage) {
        if (this.logThrowableToAudit(throwable)) {
            this.printThrowableToAudit(throwable);
        }
        if (this.logThrowableToTrace(throwable)) {
            this.printThrowableToTrace(throwable, backgroundTaskMessage);
        }
        return true;
    }

    protected boolean logThrowableToAudit(Throwable throwable) {
        return true;
    }

    protected void printThrowableToAudit(Throwable throwable) {
        this.logSys_.log(throwable);
    }

    protected boolean logThrowableToTrace(Throwable throwable) {
        String category = this.logSys_.getTraceCategory();
        return this.logSys_.logEnabled(category, 20000) || this.logSys_.logEnabled(category, 10000);
    }

    protected void printThrowableToTrace(Throwable ex, IBackgroundTaskMessage backgroundTaskMessage) {
        String category = this.logSys_.getTraceCategory();
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        CMIndications.printCDATABegin(out);
        CMIndications.printErrorMessage(backgroundTaskMessage.getMessage(), out);
        CMIndications.printThrowableMessage(ex, out);
        CMIndications.printStackTrace(ex, out);
        CMIndications.printCDATAEnd(out);
        String msg = writer.toString();
        int traceLevel = this.getTraceMessageLevel(backgroundTaskMessage);
        this.logSys_.traceText(category, traceLevel, msg);
    }

    @Override
    public boolean reportInformation(IBackgroundTaskMessage backgroundTaskMessage) {
        this.traceTaskMessage(backgroundTaskMessage);
        return true;
    }

    @Override
    public boolean traceTaskMessage(IBackgroundTaskMessage backgroundTaskMessage) {
        this.printMessageToTrace(backgroundTaskMessage);
        return true;
    }

    private void printMessageToTrace(IBackgroundTaskMessage backgroundTaskMessage) {
        int severity = backgroundTaskMessage.getSeverity();
        int traceLevel = this.convertSeverityToLogLevel(severity);
        String category = this.logSys_.getTraceCategory();
        this.logSys_.traceText(category, traceLevel, backgroundTaskMessage.getMessage());
    }

    private int convertSeverityToLogLevel(int severity) {
        int level;
        switch (severity) {
            case 1: {
                level = 50000;
                break;
            }
            case 2: {
                level = 40000;
                break;
            }
            case 3: {
                level = 30000;
                break;
            }
            case 6: {
                level = 30000;
                break;
            }
            case 4: {
                level = 20000;
                break;
            }
            case 5: {
                level = 10000;
                break;
            }
            default: {
                level = Integer.MAX_VALUE;
            }
        }
        return level;
    }

    protected int getTraceMessageLevel(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.convertSeverityToLogLevel(backgroundTaskMessage.getSeverity());
    }

    protected int getAuditMessageLevel(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.convertSeverityToLogLevel(backgroundTaskMessage.getSeverity());
    }

    @Override
    public boolean reportStatus() {
        return false;
    }
}

