/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.BackgroundTaskErrorReporter;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.contentTasks.cleanupTask.ITaskErrorReporter;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.request.delete2;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.List;
import org.dom4j.Element;

public class DeleteTaskAction
implements IBackgroundTaskAction {
    private CMStore store;
    private ICMLockManager lockManager;
    private ITaskErrorReporter errorReporter;

    @Override
    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        this.errorReporter = this.createTaskErrorReporter(context);
    }

    @Override
    public void setupExecute(IBackgroundTaskExectutionContext context) throws Exception {
        this.store = context.getStore();
        this.lockManager = this.store.getLockManager();
    }

    @Override
    public void execute(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        throw new UnsupportedOperationException("Batch execution is not supported");
    }

    @Override
    public void execute(String objectSearchPath, IBackgroundTaskExectutionContext context, Object item) throws Exception {
        ICMStorePath storeIDPath = this.createStorePath(objectSearchPath);
        storeIDPath.setLockManagerUsageFlag(15);
        try {
            this.lockManager.requestLocks(storeIDPath);
            if (this.deleteObject(objectSearchPath) > 0) {
                this.errorReporter.reportSuccess("cmDeleteSuccessMessage", objectSearchPath);
            }
        }
        catch (CMException e) {
            throw new CMException((Exception)e, "cmDeleteFailureMessage", this.createObjectParameter(objectSearchPath));
        }
        finally {
            this.lockManager.releaseLocks();
        }
    }

    private CMException.Parm createObjectParameter(String objectSearchPath) {
        return new CMException.Parm("OBJECT", objectSearchPath);
    }

    protected ICMStorePath createStorePath(String objectSearchPath) throws CMStoreParseException {
        return new CMStoreXPath(objectSearchPath);
    }

    protected int deleteObject(String objectSearchPath) throws CMException {
        return delete2.deleteDescendants(this.store, objectSearchPath, 512, false);
    }

    protected ITaskErrorReporter createTaskErrorReporter(IBackgroundTaskExectutionContext context) {
        return new BackgroundTaskErrorReporter(context.getReporterHandler());
    }

    @Override
    public void tearDown() {
    }
}

