/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.LogOnceReporterHandler;
import com.cognos.cm.backgroundTask.TaskLoggingSystemWrapper;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMessage;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.pogo.util.NameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import org.dom4j.Element;

public class DeleteTaskReporterHandler
extends LogOnceReporterHandler {
    private static final String FAILURE_THRESHOLD = "failureThreshold";
    private static final String SUCCESS_THRESHOLD = "successThreshold";
    private static final ArrayList<String> WRAPPER_EXCEPTION_CODES = new ArrayList<String>(Arrays.asList("cmDeleteFailureMessage"));
    private int successThreshold;
    private int failureThreshold;
    private int successCount;
    private int failureCount;

    public DeleteTaskReporterHandler(String taskName, Element options) throws ConfigurationException {
        this(taskName, options, null);
    }

    public DeleteTaskReporterHandler(String taskName, Element options, TaskLoggingSystemWrapper logSys) throws ConfigurationException {
        super(taskName, options, logSys, WRAPPER_EXCEPTION_CODES, null);
        this.successThreshold = this.getSuccessThreshold(options);
        this.failureThreshold = this.getFailureThreshold(options);
        this.successCount = 0;
        this.failureCount = 0;
    }

    private int getSuccessThreshold(Element options) {
        int successThreshold = 100;
        if (options != null) {
            Element successThresholdElement = options.element(SUCCESS_THRESHOLD);
            try {
                successThreshold = Integer.valueOf(successThresholdElement.getTextTrim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return successThreshold;
    }

    private int getFailureThreshold(Element options) {
        int failureThreshold = 10;
        if (options != null) {
            Element failureThresholdElement = options.element(FAILURE_THRESHOLD);
            try {
                failureThreshold = Integer.valueOf(failureThresholdElement.getTextTrim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return failureThreshold;
    }

    @Override
    protected boolean logThrowableToAudit(Throwable throwable) {
        ++this.failureCount;
        return this.failureCount >= this.failureThreshold;
    }

    @Override
    protected boolean logSuccessToAudit() {
        ++this.successCount;
        return this.successCount >= this.successThreshold;
    }

    @Override
    protected void printThrowableToAudit(Throwable throwable) {
        this.printTotalsMessage();
    }

    @Override
    protected void printSuccessToAudit(IBackgroundTaskMessage backgroundTaskMessage) {
        this.printTotalsMessage();
    }

    private void printTotalsMessage() {
        this.logSys_.Audit_Warning("cmDeletionStatusMessage", new NameValuePair[]{new NameValuePair("NUMBERSUCCESS", String.valueOf(this.successCount)), new NameValuePair("NUMBERERROR", String.valueOf(this.failureCount))}, null);
        this.successCount = 0;
        this.failureCount = 0;
    }

    @Override
    public boolean reportStatus() {
        this.printTotalsMessage();
        return true;
    }
}

