/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.RunOptionsReader;
import com.cognos.cm.backgroundTaskPluginAPI.BackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskHandler;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.util.PluginLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class GenericTaskHandler
implements IBackgroundTaskHandler {
    public static final String RUN_OPTION_EXECUTE_ACTION_IN_TRANSACTION = "executeActionInTransaction";
    public static final String RUN_OPTION_MAX_ITEMS_TO_HANDLE_PER_TRANSACTION = "maxItemsToHandlePerTransaction";
    private static final int DEFAULT_MAX_ITEMS_PER_TRANSACTION = 1;
    private static final List<ICMQueueItem> NO_ITEMS = Collections.emptyList();
    private String queueName;
    private Element runOptions;
    private final IBackgroundTaskAction taskAction;
    private int maxItemsPerTransaction;
    private boolean isInitialized;
    private String taskName;
    private CMStore store;
    private ICMQueueManager queueManager;
    private IBackgroundTaskExectutionContext context;
    protected boolean executeActionInTransaction;
    public static Counter inGenericTask = new AllInOneCounter().makeThreadLocal();
    private static Timer timer = new Timer(inGenericTask);

    public GenericTaskHandler(IBackgroundTaskAction taskAction) {
        this.taskAction = taskAction;
        this.isInitialized = false;
        this.executeActionInTransaction = true;
        this.maxItemsPerTransaction = 1;
    }

    @Override
    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        this.saveContext(context);
        this.validateElementIsNotNull(runOptionsElement);
        this.initializeQueueName(runOptionsElement);
        this.initializeExecuteActionInTransaction(runOptionsElement);
        this.initializeMaxItemsPerTransaction(runOptionsElement);
        this.runOptions = runOptionsElement;
        this.getTaskAction().initialize(context, runOptionsElement);
        this.isInitialized = true;
    }

    private void saveContext(IBackgroundTaskExectutionContext context) {
        this.context = context;
        this.taskName = context.getTaskName();
        this.queueManager = context.getQueueManager();
    }

    private void validateElementIsNotNull(Element runOptionsElement) throws CMException {
        if (runOptionsElement == null) {
            PluginLoader.get().throwConfigurationParsingException(this.taskName, "queueName");
        }
    }

    private void initializeQueueName(Element runOptionsElement) throws CMException {
        Element element = runOptionsElement.element("queueName");
        this.validateElementIsNotNull(element);
        this.queueName = element.getTextTrim();
        if (this.queueName == null || this.queueName.isEmpty()) {
            PluginLoader.get().throwConfigurationParsingException(this.taskName, "queueName");
        }
    }

    private void initializeExecuteActionInTransaction(Element runOptionsElement) {
        String value;
        Element element = runOptionsElement.element(RUN_OPTION_EXECUTE_ACTION_IN_TRANSACTION);
        if (element != null && (value = element.getTextTrim()) != null && !value.isEmpty()) {
            this.executeActionInTransaction = Boolean.parseBoolean(value);
        }
    }

    private void initializeMaxItemsPerTransaction(Element runOptionsElement) {
        RunOptionsReader reader = new RunOptionsReader(runOptionsElement);
        this.maxItemsPerTransaction = reader.getIntValue(RUN_OPTION_MAX_ITEMS_TO_HANDLE_PER_TRANSACTION, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IBackgroundTaskExectutionContext context) throws Exception {
        this.initializeExecution(context);
        try {
            List<ICMQueueItem> items = this.getNextItems();
            while (!items.isEmpty()) {
                try {
                    try {
                        this.executeActionOnItems(items);
                        this.markAsCompleted(items);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                catch (CMStoreNotAvailable e) {
                    throw e;
                }
                catch (Exception e) {
                    this.markAsFailed(items);
                    this.reportExceptionOnItems(items, e);
                }
                finally {
                    this.stopCounters();
                }
                if (this.stopTaskRequested()) {
                    break;
                }
                this.startCounters();
                items = this.getNextItems();
            }
        }
        finally {
            this.tearDownExecution();
        }
    }

    protected void initializeExecution(IBackgroundTaskExectutionContext context) throws Exception {
        this.saveContext(context);
        this.failIfNotInitialized();
        try {
            this.initializeExecution();
        }
        catch (Exception e) {
            this.tearDownExecution();
            throw e;
        }
    }

    protected void initializeExecution() throws Exception {
        this.setStore(this.getContext().getCMExecutionContext().getStore());
        this.getTaskAction().setupExecute(this.getContext());
        this.getContext().getReconcileSynchronizer().reconcile();
        this.startCounters();
    }

    protected void tearDownExecution() {
        this.getTaskAction().tearDown();
        this.stopCounters();
    }

    private void failIfNotInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("The task has not been initialized");
        }
    }

    private List<ICMQueueItem> getNextItems() throws CMException {
        return this.maxItemsPerTransaction > 1 ? this.getMultipleItems() : this.getSingleItem();
    }

    private List<ICMQueueItem> getMultipleItems() throws CMException {
        int numOfItemsAvailable = this.getQueueSize();
        if (numOfItemsAvailable == 0) {
            return this.blockWaitingForNextItem();
        }
        return this.getItemsFromQueue(Math.min(numOfItemsAvailable, this.maxItemsPerTransaction));
    }

    private int getQueueSize() throws CMException {
        return this.getQueueManager().getQueueSize(this.getStore(), this.getQueueName(), CMQueueItemState.AVAILABLE);
    }

    private List<ICMQueueItem> blockWaitingForNextItem() throws CMException {
        ICMQueueItem item = this.getNextItem();
        return this.wasThreadInterrupted(item) ? NO_ITEMS : Arrays.asList(item);
    }

    private ICMQueueItem getNextItem() throws CMException {
        return this.getQueueManager().get(this.getStore(), this.getQueueName(), this.taskName);
    }

    private boolean wasThreadInterrupted(ICMQueueItem item) {
        return item == null;
    }

    private List<ICMQueueItem> getItemsFromQueue(int maxItems) throws CMException {
        return this.getQueueManager().get(this.getStore(), this.getQueueName(), this.taskName, maxItems);
    }

    private List<ICMQueueItem> getSingleItem() throws CMException {
        return this.blockWaitingForNextItem();
    }

    private void reportExceptionOnItems(List<ICMQueueItem> items, Exception e) {
        for (ICMQueueItem item : items) {
            this.reportExceptionOnItem(item, e);
        }
    }

    private void executeActionOnItems(List<ICMQueueItem> items) throws CMException, Exception {
        try {
            if (this.executeActionInTransaction) {
                this.getStore().beginTransaction();
            }
            if (items.size() == 1) {
                this.executeActionOnSingleItem(items.get(0));
            } else {
                this.executeActionOnMultipleItems(items);
            }
            if (this.executeActionInTransaction) {
                this.getStore().commitTransaction();
            }
        }
        catch (Exception e) {
            if (this.executeActionInTransaction && this.getStore().inTransaction()) {
                this.getStore().rollbackTransaction();
            }
            throw e;
        }
    }

    private void executeActionOnSingleItem(ICMQueueItem item) throws Exception {
        this.getTaskAction().execute(item.getObjectID(), this.getContext(), item);
    }

    private void executeActionOnMultipleItems(List<ICMQueueItem> items) throws Exception {
        this.getTaskAction().execute(this.getContext(), items);
    }

    private void reportExceptionOnItem(ICMQueueItem item, Exception e) {
        BackgroundTaskMessage taskMessage = new BackgroundTaskMessage(e.getLocalizedMessage(), null, 2);
        this.getContext().getReporterHandler().reportActionException(e, taskMessage, item.getWorkFlow(), item.getObjectID());
    }

    private void markAsCompleted(List<ICMQueueItem> items) throws CMException {
        this.getQueueManager().markAsCompleted(this.getStore(), items);
    }

    private void markAsFailed(List<ICMQueueItem> items) throws CMException {
        this.getQueueManager().markAsFailed(this.getStore(), items);
    }

    @Override
    public Element getRunOptions() {
        return this.runOptions;
    }

    private boolean stopTaskRequested() {
        return Thread.interrupted();
    }

    protected String getQueueName() {
        return this.queueName;
    }

    private void startCounters() {
        ContentManager.diagnosticsManager.reset();
        timer.start();
    }

    private void stopCounters() {
        timer.stop(this.taskName);
        ContentManager.diagnosticsManager.update();
    }

    protected ICMQueueManager getQueueManager() {
        return this.queueManager;
    }

    protected CMStore getStore() {
        return this.store;
    }

    protected void setStore(CMStore store) {
        this.store = store;
    }

    protected IBackgroundTaskAction getTaskAction() {
        return this.taskAction;
    }

    protected IBackgroundTaskExectutionContext getContext() {
        return this.context;
    }
}

