/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.backgroundTask.DefaultBackgroundTaskReporterHandler;
import com.cognos.cm.backgroundTask.TaskLoggingSystemWrapper;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMessage;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cmutils.config.ConfigurationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class LogOnceReporterHandler
extends DefaultBackgroundTaskReporterHandler {
    protected static final String REPOSITORY_PARM = "REPOSITORY";
    private Set<String> auditFailures;
    private Set<String> traceFailures;
    private List<String> knownWrapperExceptionCodes;
    protected String auditCategory;

    public LogOnceReporterHandler(String taskName, Element options, List<String> knownWrapperExceptionCodes, String auditCategory) throws ConfigurationException {
        this(taskName, options, null, knownWrapperExceptionCodes, auditCategory);
    }

    public LogOnceReporterHandler(String taskName, Element options, TaskLoggingSystemWrapper logSys, List<String> knownWrapperExceptionCodes, String auditCategory) throws ConfigurationException {
        super(taskName, options, logSys);
        this.knownWrapperExceptionCodes = knownWrapperExceptionCodes;
        this.auditCategory = auditCategory;
    }

    @Override
    protected boolean logThrowableToAudit(Throwable throwable) {
        return this.logThrowable(this.getAuditLevel(), throwable, this.getAuditFailures());
    }

    private String getFailuresCauseMessage(Throwable throwable) {
        Throwable cause;
        CMException cmex;
        String failureMessage = throwable.getMessage();
        if (throwable instanceof CMException && this.isKnownWrapperException(cmex = (CMException)throwable) && (cause = this.getCause(cmex)) != null) {
            failureMessage = cause.getMessage();
        }
        return failureMessage;
    }

    private boolean isKnownWrapperException(CMException cmex) {
        String code = cmex.getCode();
        for (String knownWrapperExceptionCode : this.knownWrapperExceptionCodes) {
            if (!code.equalsIgnoreCase(knownWrapperExceptionCode)) continue;
            return true;
        }
        return false;
    }

    private Throwable getCause(CMException cmex) {
        Throwable cause = cmex.getCause();
        if (cause == null) {
            cause = cmex.getException();
        }
        return cause;
    }

    private boolean logThrowable(int logLevel, Throwable throwable, Set<String> failures) {
        if (logLevel == Integer.MAX_VALUE) {
            return false;
        }
        if (logLevel == 20000 || logLevel == 10000) {
            return true;
        }
        String failureMessage = this.getFailuresCauseMessage(throwable);
        if (!failures.contains(failureMessage)) {
            failures.add(failureMessage);
            return true;
        }
        return false;
    }

    @Override
    protected void printThrowableToAudit(Throwable throwable) {
        CMExecutionContext.get().setIPFCategory(this.auditCategory);
        this.logSys_.log(throwable, this.auditCategory, 50000, null, null, null, "Warning", false);
    }

    @Override
    protected boolean logSuccessToAudit() {
        return this.logSuccess(this.getAuditLevel(), this.auditFailures);
    }

    private boolean logSuccess(int logLevel, Set<String> failures) {
        if (logLevel == Integer.MAX_VALUE) {
            return false;
        }
        if (logLevel == 20000 || logLevel == 10000 || this.isFirstSuccess(failures)) {
            return true;
        }
        return failures.size() != 0;
    }

    private Set<String> getAuditFailures() {
        if (this.auditFailures == null) {
            this.auditFailures = new HashSet<String>();
        }
        return this.auditFailures;
    }

    private Set<String> getTraceFailures() {
        if (this.traceFailures == null) {
            this.traceFailures = new HashSet<String>();
        }
        return this.traceFailures;
    }

    protected int getAuditLevel() {
        return this.logSys_.getLogLevel(this.auditCategory);
    }

    protected boolean isFirstSuccess(Set<String> failures) {
        return failures == null;
    }

    @Override
    protected void printSuccessToAudit(IBackgroundTaskMessage backgroundTaskMessage) {
        CMExecutionContext.get().setIPFCategory(this.auditCategory);
        this.logSys_.audit(true, this.auditCategory, this.getAuditMessageLevel(backgroundTaskMessage), null, null, null, null, "Success", new String[]{backgroundTaskMessage.getMessage()});
    }

    @Override
    protected boolean logThrowableToTrace(Throwable throwable) {
        return this.logThrowable(this.getTraceLevel(), throwable, this.getTraceFailures());
    }

    @Override
    protected boolean logSuccessToTrace(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.logSuccess(this.getTraceLevel(), this.traceFailures);
    }

    private int getTraceLevel() {
        return this.logSys_.getTaskTraceLogLevels();
    }

    public void reset() {
        this.auditFailures = null;
        this.traceFailures = null;
    }

    protected void clearAuditFailures() {
        this.getAuditFailures().clear();
    }

    protected void clearTraceFailures() {
        this.getTraceFailures().clear();
    }
}

