/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.indications.IPFLoggingSystem;
import com.cognos.cm.indications.LoggingSystem;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.indications.LogIPFControl;
import com.cognos.pogo.util.NameValuePair;
import java.util.Observable;
import java.util.Observer;

public class TaskLoggingSystemWrapper
implements LoggingSystem {
    protected IPFLoggingSystem cmLogSys;
    private int taskTraceLogLevels;
    private boolean isInitialized = false;
    private String taskName;

    public TaskLoggingSystemWrapper(String name) {
        LoggingSystem loggingSystem = this.createLoggingSystem();
        this.setup(name, loggingSystem);
    }

    private void setup(String name, LoggingSystem loggingSystem) {
        this.setLoggingSystem((IPFLoggingSystem)loggingSystem);
        this.taskName = name;
        this.taskTraceLogLevels = this.getTaskTraceLoggingLevel();
    }

    protected LoggingSystem createLoggingSystem() {
        LoggingSystem loggingSystem = CMIndications.getLoggingSystem();
        if (!(loggingSystem instanceof IPFLoggingSystem)) {
            throw new IllegalStateException("CMIndications.getLoggingSystem() is not an IPFLoggingSystem");
        }
        return loggingSystem;
    }

    public TaskLoggingSystemWrapper(String name, IPFLoggingSystem loggingSystem) {
        this.setup(name, loggingSystem);
    }

    public void setLoggingSystem(IPFLoggingSystem logSys) {
        this.cmLogSys = logSys;
    }

    private Integer getTaskTraceLoggingLevel() {
        String category = this.getTraceCategory();
        return this.getLogLevel(category);
    }

    public String getTraceCategory() {
        String category = "Trace.CM.TASK." + this.taskName;
        return category;
    }

    @Override
    public void reconfigure() {
        this.taskLogLevelsUpdate();
    }

    private void taskLogLevelsUpdate() {
        Integer level = this.getTaskTraceLoggingLevel();
        if (level != this.taskTraceLogLevels) {
            this.taskTraceLogLevels = level;
        }
    }

    public int getTaskTraceLogLevels() {
        return this.taskTraceLogLevels;
    }

    @Override
    public void initialize() throws ConfigurationException {
        this.registerObserver();
        this.taskLogLevelsUpdate();
        this.isInitialized = true;
    }

    protected void registerObserver() {
        LogIPFControl.addConfigObserver((Observer)new ConfigObserver());
    }

    public void logThrowable(Throwable ex) {
        this.cmLogSys.logThrowable(ex);
    }

    public void logException(Throwable ex, String request) {
        this.cmLogSys.logException(ex, request);
    }

    @Override
    public void logException(Throwable ex, String request, String sOperation, String sObjectType, String sObjectPath) {
        this.cmLogSys.logException(ex, request, sOperation, sObjectType, sObjectPath);
    }

    @Override
    public void logData(String xmlData) {
        this.cmLogSys.logData(xmlData);
    }

    public boolean logEnabled(String sCategory) {
        return this.cmLogSys.logEnabled(sCategory);
    }

    public void CMTraceText(String sCategory, int nLevel, String sMsgText) {
        this.cmLogSys.CMTraceText(sCategory, nLevel, sMsgText);
    }

    public void CMDebugTrace(String sMsgText) {
        this.cmLogSys.CMDebugTrace(sMsgText);
    }

    public void CMTempDebugTrace(String sMsgText) {
        this.cmLogSys.CMTempDebugTrace(sMsgText);
    }

    public void CMTrace(String sMsgCode) {
        this.cmLogSys.CMTrace(sMsgCode);
    }

    public void CMTrace(String sMsgCode, NameValuePair p1) {
        this.cmLogSys.CMTrace(sMsgCode, new NameValuePair[]{p1});
    }

    public void CMTrace(String sMsgCode, NameValuePair p1, NameValuePair p2) {
        this.cmLogSys.CMTrace(sMsgCode, new NameValuePair[]{p1, p2});
    }

    public void CMTrace(String sMsgCode, NameValuePair[] listExceptionParms) {
        this.cmLogSys.CMTrace(sMsgCode, listExceptionParms);
    }

    public void Audit_Info(String sMsgCode, NameValuePair[] listParms, String sCategory) {
        this.cmLogSys.Audit_Info(sMsgCode, listParms, sCategory);
    }

    public void Audit_Warning(String sMsgCode, NameValuePair[] listParms, String sCategory) {
        this.cmLogSys.Audit_Warning(sMsgCode, listParms, sCategory);
    }

    public void Audit_Message(String sMsgText) {
        this.cmLogSys.Audit_Message(sMsgText);
    }

    public void Audit_Request(String sReq) {
        this.cmLogSys.Audit_Request(sReq);
    }

    public void Audit_Response(String sResp) {
        this.cmLogSys.Audit_Response(sResp);
    }

    @Override
    public void audit(boolean auditAccess, String category, int level, String operation, String logDataXML, String objectType, String objectPath, String status, String[] errorMessages) {
        this.cmLogSys.audit(auditAccess, category, level, operation, logDataXML, objectType, objectPath, status, errorMessages);
    }

    @Override
    public void audit_Fmt1(boolean auditAccess, String category, int level, String operation, String objectType, String objectPath, String status, String[] errorMessages, String msgCode, String msgText, String request, String requester, NameValuePair[] listExceptionParms) {
        this.cmLogSys.audit_Fmt1(auditAccess, category, level, operation, objectType, objectPath, status, errorMessages, msgCode, msgText, request, requester, listExceptionParms);
    }

    @Override
    public void audit_Fmt4(String category, String operation, String messageBody, String objectType, String objectPath, String status, String[] errorMessages) {
        this.cmLogSys.audit_Fmt4(category, operation, messageBody, objectType, objectPath, status, errorMessages);
    }

    @Override
    public void audit_Message_FreeFormText(String msgCode, NameValuePair[] listParms, int level, String category, String objType, String objPath, String status, String[] errors) {
        this.cmLogSys.audit_Message_FreeFormText(msgCode, listParms, level, category, objType, objPath, status, errors);
    }

    @Override
    public boolean CMMessageEnabled(String msgCode) {
        return this.cmLogSys.CMMessageEnabled(msgCode);
    }

    @Override
    public int getLogLevel(String category) {
        return this.cmLogSys.getLogLevel(category);
    }

    @Override
    public boolean isInitialized() {
        return this.cmLogSys.isInitialized() && this.isInitialized;
    }

    @Override
    public void log(Throwable t) {
        this.cmLogSys.log(t);
    }

    @Override
    public void log(Throwable ex, String sCategory, int nLevel, String sOperation, String sObjectType, String sObjectPath, String sStatus, boolean putErrorDetails) {
        this.cmLogSys.log(ex, sCategory, nLevel, sOperation, sObjectType, sObjectPath, sStatus, putErrorDetails);
    }

    @Override
    public boolean logEnabled(String category, int level) {
        return this.cmLogSys.logEnabled(category, level);
    }

    @Override
    public void shutdown() {
        this.cmLogSys.shutdown();
    }

    @Override
    public void trace(int level, String msgCode, NameValuePair[] listExceptionParms) {
        this.cmLogSys.trace(level, msgCode, listExceptionParms);
    }

    @Override
    public void traceText(String category, int level, String msgText) {
        this.cmLogSys.traceText(category, level, msgText);
    }

    protected class ConfigObserver
    implements Observer {
        protected ConfigObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            TaskLoggingSystemWrapper.this.reconfigure();
        }
    }
}

