/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask.periods;

import com.cognos.cm.backgroundTask.periods.AllTasksBackgroundPeriodWeeklySignal;
import com.cognos.cm.backgroundTask.periods.AllTasksBlackoutPeriodStartSignal;
import com.cognos.cm.backgroundTask.periods.AllTasksBlackoutPeriodStopSignal;
import com.cognos.cm.backgroundTask.periods.BackgroundPeriod;
import com.cognos.cm.backgroundTask.periods.BackgroundTaskExecutionPeriodSignal;
import com.cognos.cm.backgroundTask.periods.ExecutionPeriod;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodCancellableSignal;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodTimer;
import com.cognos.cm.backgroundTask.periods.IBackgroundTaskPeriodSignal;
import com.cognos.cm.backgroundTask.periods.TaskBackgroundPeriodWeeklySignal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BackgroundPeriodTimer
implements IBackgroundPeriodTimer {
    private static final int CORE_POOL_SIZE = 1;
    protected ScheduledExecutorService timer = new ScheduledThreadPoolExecutor(1);
    private AllTasksBlackoutPeriodStartSignal allTasksBlackoutPeriodStartSignal = new AllTasksBlackoutPeriodStartSignal();
    private AllTasksBlackoutPeriodStopSignal allTasksBlackoutPeriodStopSignal = new AllTasksBlackoutPeriodStopSignal();
    private Map<String, IBackgroundTaskPeriodSignal> taskExecutionPeriodStopSignals = new HashMap<String, IBackgroundTaskPeriodSignal>();
    private List<IBackgroundPeriodCancellableSignal> allTasksCancellableSignals = new LinkedList<IBackgroundPeriodCancellableSignal>();
    private Map<String, List<IBackgroundPeriodCancellableSignal>> tasksCancellableSignals = new HashMap<String, List<IBackgroundPeriodCancellableSignal>>();

    @Override
    public void addAllTasksBlackoutPeriods(List<BackgroundPeriod> blackoutPeriods) {
        Collections.sort(blackoutPeriods);
        for (BackgroundPeriod blackoutPeriod : blackoutPeriods) {
            this.addAllTasksBackgroundPeriod(blackoutPeriod.getStartCalendar(), blackoutPeriod.getStopCalendar());
        }
    }

    private void addAllTasksBackgroundPeriod(Calendar startBlackoutPeriodCalendar, Calendar stopBlackoutPeriodCalendar) {
        AllTasksBackgroundPeriodWeeklySignal allTasksBlackoutPeriodWeeklyStartSignal = new AllTasksBackgroundPeriodWeeklySignal(this, this.getAllTasksBlackoutPeriodStartSignal(), startBlackoutPeriodCalendar.getTime());
        AllTasksBackgroundPeriodWeeklySignal allTasksBlackoutPeriodWeeklyStopSignal = new AllTasksBackgroundPeriodWeeklySignal(this, this.getAllTasksBlackoutPeriodStopSignal(), stopBlackoutPeriodCalendar.getTime());
        this.addBlackoutPeriod(this.getAllTasksBlackoutPeriodStartSignal(), allTasksBlackoutPeriodWeeklyStartSignal, allTasksBlackoutPeriodWeeklyStopSignal, startBlackoutPeriodCalendar, stopBlackoutPeriodCalendar);
    }

    private void addBlackoutPeriod(Runnable blackoutPeriodStartSignal, AllTasksBackgroundPeriodWeeklySignal blackoutPeriodWeeklyStartSignal, AllTasksBackgroundPeriodWeeklySignal blackoutPeriodWeeklyStopSignal, Calendar startBlackoutPeriodCalendar, Calendar stopBlackoutPeriodCalendar) {
        Calendar currentDateCalendar = this.getCalendar();
        if (this.inBackgroundPeriod(currentDateCalendar, startBlackoutPeriodCalendar, stopBlackoutPeriodCalendar)) {
            this.addAWeek(startBlackoutPeriodCalendar);
            blackoutPeriodStartSignal.run();
        } else if (this.backgroundPeriodPassed(currentDateCalendar, startBlackoutPeriodCalendar, stopBlackoutPeriodCalendar)) {
            this.addAWeek(startBlackoutPeriodCalendar);
            this.addAWeek(stopBlackoutPeriodCalendar);
        }
        this.scheduleBackgroundPeriodSignalForFirstTime(blackoutPeriodWeeklyStartSignal, startBlackoutPeriodCalendar.getTime(), currentDateCalendar.getTime(), this.allTasksCancellableSignals);
        this.scheduleBackgroundPeriodSignalForFirstTime(blackoutPeriodWeeklyStopSignal, stopBlackoutPeriodCalendar.getTime(), currentDateCalendar.getTime(), this.allTasksCancellableSignals);
    }

    @Override
    public void addTaskExecutionPeriods(String taskName, List<ExecutionPeriod> executionPeriods) {
        Calendar periodStopCalendar;
        Calendar periodStartCalendar;
        ExecutionPeriod period;
        int i;
        if (executionPeriods.size() <= 0) {
            return;
        }
        this.tasksCancellableSignals.put(taskName, new LinkedList());
        Collections.sort(executionPeriods);
        Calendar currentCalendar = this.getCalendar();
        for (i = 0; i < executionPeriods.size() - 1; ++i) {
            period = executionPeriods.get(i);
            ExecutionPeriod nextPeriod = executionPeriods.get(i + 1);
            periodStartCalendar = period.getStartCalendar();
            if (this.inBackgroundPeriod(currentCalendar, periodStartCalendar, periodStopCalendar = period.getStopCalendar())) {
                this.addAWeek(periodStartCalendar);
                this.timer.schedule(this.getTaskExecutionPeriodStartSignal(taskName, period), 0L, TimeUnit.MILLISECONDS);
            } else if (this.backgroundPeriodPassed(currentCalendar, periodStartCalendar, periodStopCalendar)) {
                this.addAWeek(periodStartCalendar);
                this.addAWeek(periodStopCalendar);
            }
            this.scheduleStartExecutionPeriodSignal(taskName, period, periodStartCalendar, currentCalendar);
            Calendar nextPeriodStartCalendar = (Calendar)nextPeriod.getStartCalendar().clone();
            if (currentCalendar.after(nextPeriodStartCalendar)) {
                this.addAWeek(nextPeriodStartCalendar);
            }
            if (periodStopCalendar.equals(nextPeriodStartCalendar)) continue;
            this.scheduleStopExecutionPeriodSignal(taskName, periodStopCalendar, currentCalendar);
        }
        period = executionPeriods.get(i);
        periodStartCalendar = period.getStartCalendar();
        if (this.inBackgroundPeriod(currentCalendar, periodStartCalendar, periodStopCalendar = period.getStopCalendar())) {
            this.addAWeek(periodStartCalendar);
            this.timer.schedule(this.getTaskExecutionPeriodStartSignal(taskName, period), 0L, TimeUnit.MILLISECONDS);
        } else if (this.backgroundPeriodPassed(currentCalendar, periodStartCalendar, periodStopCalendar)) {
            this.addAWeek(periodStartCalendar);
            this.addAWeek(periodStopCalendar);
        }
        this.scheduleStartExecutionPeriodSignal(taskName, period, periodStartCalendar, currentCalendar);
        this.scheduleStopExecutionPeriodSignal(taskName, periodStopCalendar, currentCalendar);
    }

    private void scheduleStartExecutionPeriodSignal(String taskName, ExecutionPeriod period, Calendar periodStartCalendar, Calendar currentCalendar) {
        TaskBackgroundPeriodWeeklySignal startSignal = this.getTaskWeeklySignal(this.getTaskExecutionPeriodStartSignal(taskName, period), periodStartCalendar.getTime());
        this.scheduleBackgroundPeriodSignalForFirstTime(startSignal, periodStartCalendar.getTime(), currentCalendar.getTime(), this.tasksCancellableSignals.get(taskName));
    }

    private void scheduleStopExecutionPeriodSignal(String taskName, Calendar periodStopCalendar, Calendar currentCalendar) {
        TaskBackgroundPeriodWeeklySignal stopSignal = this.getTaskWeeklySignal(this.getTaskExsecutionPeriodStopSignal(taskName), periodStopCalendar.getTime());
        this.scheduleBackgroundPeriodSignalForFirstTime(stopSignal, periodStopCalendar.getTime(), currentCalendar.getTime(), this.tasksCancellableSignals.get(taskName));
    }

    private void scheduleBackgroundPeriodSignalForFirstTime(IBackgroundPeriodCancellableSignal signal, Date executionDate, Date currentDate, List<IBackgroundPeriodCancellableSignal> signals) {
        this.scheduleBackgroundPeriodSignal(signal, executionDate, currentDate);
        signals.add(signal);
    }

    protected IBackgroundTaskPeriodSignal getTaskExecutionPeriodStartSignal(String taskName, ExecutionPeriod period) {
        return new BackgroundTaskExecutionPeriodSignal(taskName, period.getNumberOfWorkerThreads());
    }

    protected IBackgroundTaskPeriodSignal getTaskExsecutionPeriodStopSignal(String taskName) {
        IBackgroundTaskPeriodSignal stopSignal = this.taskExecutionPeriodStopSignals.get(taskName);
        if (stopSignal == null) {
            stopSignal = new BackgroundTaskExecutionPeriodSignal(taskName, 0);
            this.taskExecutionPeriodStopSignals.put(taskName, stopSignal);
        }
        return stopSignal;
    }

    private TaskBackgroundPeriodWeeklySignal getTaskWeeklySignal(IBackgroundTaskPeriodSignal signal, Date firstExecutionTime) {
        return new TaskBackgroundPeriodWeeklySignal(this, signal, firstExecutionTime);
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance();
    }

    private boolean inBackgroundPeriod(Calendar currentDateCalendar, Calendar startBackgroundPeriodCalendar, Calendar stopBackgroundPeriodCalendar) {
        return currentDateCalendar.after(startBackgroundPeriodCalendar) && currentDateCalendar.before(stopBackgroundPeriodCalendar);
    }

    private boolean backgroundPeriodPassed(Calendar currentDateCalendar, Calendar startBackgroundPeriodCalendar, Calendar stopBackgroundPeriodCalendar) {
        return currentDateCalendar.after(startBackgroundPeriodCalendar) && currentDateCalendar.after(stopBackgroundPeriodCalendar);
    }

    @Override
    public void scheduleAllTasksBackgroundPeriodSignal(IBackgroundPeriodCancellableSignal allTasksBlackoutPeriodSignal, Date executionTime) {
        this.scheduleBackgroundPeriodSignal(allTasksBlackoutPeriodSignal, executionTime, this.getCalendar().getTime());
    }

    @Override
    public void scheduleTaskBackgroundPeriodSignal(String taskName, IBackgroundPeriodCancellableSignal taskBackgroundPeriodSignal, Date executionTime) {
        this.scheduleBackgroundPeriodSignal(taskBackgroundPeriodSignal, executionTime, this.getCalendar().getTime());
    }

    private void scheduleBackgroundPeriodSignal(IBackgroundPeriodCancellableSignal cancellableSignal, Date executionDate, Date currentDate) {
        long delay = this.getDelay(executionDate.getTime(), currentDate.getTime());
        if (delay < 0L) {
            throw new IllegalStateException("Execution time is in past");
        }
        ScheduledFuture<?> scheduledFuture = this.timer.schedule(cancellableSignal, delay, TimeUnit.MILLISECONDS);
        cancellableSignal.setFuture(scheduledFuture);
    }

    private long getDelay(long firstExecutionTime, long currentTime) {
        return firstExecutionTime - currentTime;
    }

    @Override
    public void removeAllTasksBackgroundPeriods() {
        this.removeBackgroundPeriods(this.allTasksCancellableSignals, this.getAllTasksBlackoutPeriodStopSignal());
    }

    @Override
    public void removeTaskBackgroundPeriods(String taskName) {
        this.removeBackgroundPeriods(this.tasksCancellableSignals.get(taskName), this.getTaskExsecutionPeriodStopSignal(taskName));
        this.tasksCancellableSignals.remove(taskName);
    }

    private void removeBackgroundPeriods(List<IBackgroundPeriodCancellableSignal> cancellableSignals, Runnable stopBackgroundPeriodSignal) {
        if (cancellableSignals != null) {
            for (IBackgroundPeriodCancellableSignal scheduledFuture : cancellableSignals) {
                scheduledFuture.cancel(false);
            }
            cancellableSignals.clear();
        }
        stopBackgroundPeriodSignal.run();
    }

    protected Runnable getAllTasksBlackoutPeriodStartSignal() {
        return this.allTasksBlackoutPeriodStartSignal;
    }

    protected Runnable getAllTasksBlackoutPeriodStopSignal() {
        return this.allTasksBlackoutPeriodStopSignal;
    }

    @Override
    public void stopTimer() {
        this.timer.shutdownNow();
    }

    private void addAWeek(Calendar calendar) {
        calendar.add(3, 1);
    }
}

