/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.backgroundTask.periods;

import com.cognos.cm.backgroundTask.periods.BackgroundPeriod;
import com.cognos.cm.backgroundTask.periods.ExecutionPeriod;
import com.cognos.cm.backgroundTask.periods.IBackgroundPeriodsBuilder;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.IPluginLoader;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;

public class BackgroundPeriodsBuilder
implements IBackgroundPeriodsBuilder {
    private IPluginLoader pluginLoader;

    public BackgroundPeriodsBuilder(IPluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    @Override
    public List<BackgroundPeriod> buildBlackoutPeriods(Element blackoutPeriodsElement, String configurationResourceName) throws CMException {
        LinkedList<BackgroundPeriod> blackoutPeriods = new LinkedList<BackgroundPeriod>();
        if (blackoutPeriodsElement != null) {
            List<?> blackoutPeriodElements = this.pluginLoader.getRequiredChildElements(blackoutPeriodsElement, "blackoutPeriod", configurationResourceName);
            for (Element blackoutPeriodElement : blackoutPeriodElements) {
                Element startTimeElement = this.getStartTimeElement(configurationResourceName, blackoutPeriodElement);
                int beginHour = this.getHour(configurationResourceName, startTimeElement);
                int minuteWithinBeginHour = this.getMinuteWithinHour(configurationResourceName, startTimeElement);
                Element stopTimeElement = this.getStopTimeElement(configurationResourceName, blackoutPeriodElement);
                int endHour = this.getHour(configurationResourceName, stopTimeElement);
                int minuteWithinEndHour = this.getMinuteWithinHour(configurationResourceName, stopTimeElement);
                List<Element> dayElements = this.getDayElements(configurationResourceName, blackoutPeriodElement);
                for (Element dayElement : dayElements) {
                    DayOfWeek dayOfWeek = this.getDayOfWeek(dayElement, configurationResourceName);
                    this.validateBackgroundPeriodParameters(beginHour, minuteWithinBeginHour, endHour, minuteWithinEndHour, configurationResourceName);
                    Calendar startCalendar = this.getCalendar(beginHour, minuteWithinBeginHour, 0, 0, dayOfWeek);
                    Calendar stopCalendar = this.getCalendar(endHour, minuteWithinEndHour, 0, 0, dayOfWeek);
                    blackoutPeriods.add(new BackgroundPeriod(startCalendar, stopCalendar));
                }
            }
        }
        this.validateBackgroundPeriods(blackoutPeriods, configurationResourceName);
        return blackoutPeriods;
    }

    @Override
    public List<ExecutionPeriod> buildExecutionPeriods(Element executionPeriodsElement, String configurationResourceName, int defaultNumberOfWorkerThreads) throws CMException {
        LinkedList<ExecutionPeriod> executionPeriods = new LinkedList<ExecutionPeriod>();
        if (executionPeriodsElement != null) {
            List<?> executionPeriodElements = this.pluginLoader.getRequiredChildElements(executionPeriodsElement, "executionPeriod", configurationResourceName);
            for (Element executionPeriodElement : executionPeriodElements) {
                Element startTimeElement = this.getStartTimeElement(configurationResourceName, executionPeriodElement);
                int beginHour = this.getHour(configurationResourceName, startTimeElement);
                int minuteWithinBeginHour = this.getMinuteWithinHour(configurationResourceName, startTimeElement);
                Element stopTimeElement = this.getStopTimeElement(configurationResourceName, executionPeriodElement);
                int endHour = this.getHour(configurationResourceName, stopTimeElement);
                int minuteWithinEndHour = this.getMinuteWithinHour(configurationResourceName, stopTimeElement);
                List<Element> dayElements = this.getDayElements(configurationResourceName, executionPeriodElement);
                Element numberOfWorkerThreadsElement = this.getNumberOfWorkerThreadsElement(executionPeriodElement);
                int numberOfWorkerThreads = defaultNumberOfWorkerThreads;
                if (numberOfWorkerThreadsElement != null) {
                    numberOfWorkerThreads = this.getNumberOfWorkerThreads(numberOfWorkerThreadsElement);
                }
                for (Element dayElement : dayElements) {
                    DayOfWeek dayOfWeek = this.getDayOfWeek(dayElement, configurationResourceName);
                    this.validateBackgroundPeriodParameters(beginHour, minuteWithinBeginHour, endHour, minuteWithinEndHour, configurationResourceName);
                    Calendar startCalendar = this.getCalendar(beginHour, minuteWithinBeginHour, 0, 0, dayOfWeek);
                    Calendar stopCalendar = this.getCalendar(endHour, minuteWithinEndHour, 0, 0, dayOfWeek);
                    executionPeriods.add(new ExecutionPeriod(startCalendar, stopCalendar, numberOfWorkerThreads));
                }
            }
        }
        this.validateBackgroundPeriods(executionPeriods, configurationResourceName);
        return executionPeriods;
    }

    private DayOfWeek getDayOfWeek(Element dayElement, String configurationResourceName) throws CMException {
        String day = dayElement.getTextTrim();
        DayOfWeek dayOfWeek = null;
        try {
            dayOfWeek = DayOfWeek.valueOf(day.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.throwCMException("day", configurationResourceName);
        }
        return dayOfWeek;
    }

    private List<Element> getDayElements(String configurationResourceName, Element backgroundPeriodElement) throws CMException {
        Element daysElements = this.pluginLoader.getRequiredChildElement(backgroundPeriodElement, "days", configurationResourceName);
        List<Element> dayElements = this.pluginLoader.getRequiredChildElements(daysElements, "day", configurationResourceName);
        return dayElements;
    }

    private Element getStopTimeElement(String configurationResourceName, Element backgroundPeriodElement) throws CMException {
        Element stopTimeElement = this.pluginLoader.getRequiredChildElement(backgroundPeriodElement, "stopTime", configurationResourceName);
        return stopTimeElement;
    }

    private int getMinuteWithinHour(String configurationResourceName, Element startTimeElement) throws CMException {
        int minuteWithinBeginHour = Integer.parseInt(this.pluginLoader.getRequiredChildElement(startTimeElement, "minute", configurationResourceName).getTextTrim());
        return minuteWithinBeginHour;
    }

    private int getHour(String configurationResourceName, Element startTimeElement) throws CMException {
        int beginHour = Integer.parseInt(this.pluginLoader.getRequiredChildElement(startTimeElement, "hour", configurationResourceName).getTextTrim());
        return beginHour;
    }

    private Element getStartTimeElement(String configurationResourceName, Element backgroundPeriodElement) throws CMException {
        Element startTimeElement = this.pluginLoader.getRequiredChildElement(backgroundPeriodElement, "startTime", configurationResourceName);
        return startTimeElement;
    }

    private Element getNumberOfWorkerThreadsElement(Element executionPeriodElement) {
        return executionPeriodElement.element("threads");
    }

    private int getNumberOfWorkerThreads(Element numberOfWorkerThreadsElement) {
        return Integer.parseInt(numberOfWorkerThreadsElement.getTextTrim());
    }

    private void validateBackgroundPeriods(List<? extends BackgroundPeriod> backgroundPeriods, String configurationResourceName) throws CMException {
        for (BackgroundPeriod backgroundPeriod : backgroundPeriods) {
            for (BackgroundPeriod backgroundPeriod2 : backgroundPeriods) {
                if (!backgroundPeriod.startsWithinBackgroundPeriod(backgroundPeriod2)) continue;
                throw new CMException("cmOverlappingBackgroundPeriod", new CMException.Parm("File", configurationResourceName));
            }
        }
    }

    private Calendar getCalendar(int hourOfDay, int minute, int second, int millisecond, DayOfWeek dayOfWeek) {
        Calendar calendar = Calendar.getInstance();
        this.setCalendar(calendar, hourOfDay, minute, second, millisecond, dayOfWeek);
        return calendar;
    }

    private void setCalendar(Calendar calendar, int hourOfDay, int minute, int second, int millisecond, DayOfWeek dayOfWeek) {
        Calendar compareCalendar = Calendar.getInstance();
        compareCalendar.setTimeInMillis(calendar.getTimeInMillis());
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        calendar.set(7, this.getCalendarDayOfWeekValue(dayOfWeek));
        if (compareCalendar.get(7) != this.getCalendarDayOfWeekValue(dayOfWeek) && calendar.before(compareCalendar)) {
            this.addAWeek(calendar);
        }
    }

    private void validateBackgroundPeriodParameters(int beginHour, int minuteWithinBeginHour, int endHour, int minuteWithinEndHour, String configurationResourceName) throws CMException {
        this.validateHourOfDay(beginHour, minuteWithinBeginHour, configurationResourceName);
        this.validateHourOfDay(endHour, minuteWithinEndHour, configurationResourceName);
        this.validateMinuteWithinHour(minuteWithinBeginHour, configurationResourceName);
        this.validateMinuteWithinHour(minuteWithinEndHour, configurationResourceName);
        this.validateEndBlackoutPeriodParameters(beginHour, minuteWithinBeginHour, endHour, minuteWithinEndHour, configurationResourceName);
    }

    private void validateHourOfDay(int hour, int minuteWithinHour, String configurationResourceName) throws CMException {
        if (hour == 24) {
            if (minuteWithinHour != 0) {
                this.throwCMException("minute", configurationResourceName);
            }
        } else if (hour < 0 || hour > 23) {
            this.throwCMException("hour", configurationResourceName);
        }
    }

    private void validateMinuteWithinHour(int minute, String configurationResourceName) throws CMException {
        if (minute < 0 || minute > 59) {
            this.throwCMException("minute", configurationResourceName);
        }
    }

    private void throwCMException(String invalidElementName, String configurationResourceName) throws CMException {
        throw new CMException("cmInvalidBackgroundPeriod", new CMException.Parm("File", configurationResourceName), new CMException.Parm("InvalidElement", invalidElementName));
    }

    private void validateEndBlackoutPeriodParameters(int beginHour, int minuteWithinBeginHour, int endHour, int minuteWithinEndHour, String configurationResourceName) throws CMException {
        Calendar currentCalendar = Calendar.getInstance();
        Calendar beginCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        beginCalendar.setTimeInMillis(currentCalendar.getTimeInMillis());
        endCalendar.setTimeInMillis(currentCalendar.getTimeInMillis());
        beginCalendar.set(11, beginHour);
        beginCalendar.set(12, minuteWithinBeginHour);
        endCalendar.set(11, endHour);
        endCalendar.set(12, minuteWithinEndHour);
        if (!endCalendar.after(beginCalendar)) {
            this.throwCMException("stopTime", configurationResourceName);
        }
    }

    private void addAWeek(Calendar calendar) {
        calendar.add(3, 1);
    }

    private int getCalendarDayOfWeekValue(DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
            case SUNDAY: {
                return 1;
            }
        }
        return 2;
    }

    public static enum DayOfWeek {
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;

    }
}

