/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;

class CCacheLog {
    private static CCacheLog gblLog = new CCacheLog();
    private boolean logEnabled = false;

    CCacheLog() {
    }

    public static void reset() {
        gblLog = new CCacheLog();
    }

    public static CCacheLog getGlobalCCacheLog() {
        return gblLog;
    }

    protected static void setGlobalCCacheLog(CCacheLog log) {
        gblLog = log;
    }

    public void setLogging(boolean enabled) {
        this.logEnabled = enabled;
    }

    public boolean isLoggingEnabled() {
        return this.logEnabled;
    }

    public void debugTrace(String message) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        this.trace(message);
    }

    public void trace(String message) {
        CMIndications.CMDebugTrace(message);
    }

    public void log(String code, ArrayList<String> paramNames, ArrayList<Object> paramValues) {
        CMException.Parm[] parms = null;
        if (paramNames != null && paramValues != null) {
            int numParms = paramNames.size();
            parms = new CMException.Parm[numParms];
            for (int ip = 0; ip < numParms; ++ip) {
                String paramValue = null;
                if (paramValues.get(ip) != null) {
                    paramValue = paramValues.get(ip).toString();
                }
                parms[ip] = new CMException.Parm(paramNames.get(ip), paramValue);
            }
        }
        CMIndications.CMTrace(code, parms);
    }

    public boolean initJavaLogging() {
        return true;
    }

    public void logJavaMsg(String msgCode) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        this.log(msgCode, null, null);
    }

    public void logJavaMsg2Ints(String msgCode, String param1Name, int param1Value, String param2Name, int param2Value) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        names.add(param1Name);
        names.add(param2Name);
        values.add(new Integer(param1Value));
        values.add(new Integer(param2Value));
        this.log(msgCode, names, values);
    }

    public void logJavaMsg2IntsAndString(String msgCode, String param1Name, int param1Value, String param2Name, int param2Value, String param3Name, String param3Value) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        names.add(param1Name);
        names.add(param2Name);
        names.add(param3Name);
        values.add(new Integer(param1Value));
        values.add(new Integer(param2Value));
        values.add(param3Value);
        this.log(msgCode, names, values);
    }

    public void logJavaMsg2Strings(String msgCode, String param1Name, String param1Value, String param2Name, String param2Value) {
        this.logJavaMsg2Strings(msgCode, param1Name, param1Value, param2Name, param2Value, false);
    }

    public void logJavaMsg2Strings(String msgCode, String param1Name, String param1Value, String param2Name, String param2Value, boolean lockManagerOverride) {
        if (lockManagerOverride || this.isLoggingEnabled()) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            names.add(param1Name);
            names.add(param2Name);
            values.add(param1Value);
            values.add(param2Value);
            this.log(msgCode, names, values);
        }
    }

    public void logJavaMsgInt(String msgCode, String param1Name, int param1Value) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        names.add(param1Name);
        values.add(new Integer(param1Value));
        this.log(msgCode, names, values);
    }

    public void logJavaMsgString(String msgCode, String param1Name, String param1Value) {
        this.logJavaMsgString(msgCode, param1Name, param1Value, false);
    }

    public void logJavaMsgString(String msgCode, String param1Name, String param1Value, boolean lockManagerOverride) {
        if (lockManagerOverride || this.isLoggingEnabled()) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            names.add(param1Name);
            values.add(param1Value);
            this.log(msgCode, names, values);
        }
    }

    public void logJavaMsgStringAndInt(String msgCode, String param1Name, String param1Value, String param2Name, int param2Value) {
        if (!this.isLoggingEnabled()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        names.add(param1Name);
        names.add(param2Name);
        values.add(param1Value);
        values.add(new Integer(param2Value));
        this.log(msgCode, names, values);
    }
}

