/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CCacheLog;
import com.cognos.cm.cache.Cache;
import com.cognos.cm.cache.CacheAccessDeniedException;
import com.cognos.cm.cache.CacheAccessMan;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.InvalidTenantContainmentException;
import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.entry.InvalidCacheEntry;
import com.cognos.cm.cache.entry.LinkedCacheEntry;
import com.cognos.cm.cache.query.ICacheQuery;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.AbstractCache;
import com.cognos.cm.store.BaseCmObject;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMCacheQueryInstanceJavaImpl;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.trustedServices.trustedService;
import com.cognos.cm.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class CMCacheJavaImpl
extends AbstractCache {
    public static final Counter inCacheQuery = new AccumulatingCounter().makeThreadLocal();
    private static final Timer queryTimer = new Timer(inCacheQuery);
    public static ICache gblCache;
    private static boolean cacheInitDone;
    private final Set<Integer> discardedCMIDs = Collections.synchronizedSet(new TreeSet());

    public static ICache reset() {
        gblCache = new Cache();
        return gblCache;
    }

    public static CMCache newCache(CMStore store) {
        return new CMCacheJavaImpl(store);
    }

    public CMCacheJavaImpl(CMStore store) {
        this(store, gblCache);
    }

    public CMCacheJavaImpl(CMStore store, ICache cache) {
        super(store);
        gblCache = cache;
    }

    @Override
    public void initAccMan(String initDoc) {
        CacheAccessMan accMan = new CacheAccessMan(gblCache, CMServlet.AAA);
        accMan.initialize(initDoc);
        gblCache.setUseAccessMan(true);
    }

    @Override
    public void CMCacheClear() throws CMCacheException {
        MLEntry.clearSymbolTable();
        gblCache.clearData();
        cacheInitDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int CMCacheCommitObject(int objectId, int parentId, String camId) throws CMCacheException {
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            gblCache.linkObject(objectId, parentId, false, camId);
        }
        return 1;
    }

    @Override
    public int CMCacheCreateObject(int tenantID, String name, int localeId, boolean hasRecipients, String shortcut, int type, boolean hasSecurity, int disabledFlag, String externalId, boolean hasCredentialNamespaces, int outputLocale, int outputFormat, boolean hasRecipientsEmail) throws CMCacheException {
        int objectId = -1;
        if (null == name) {
            throw new CacheException("JNI error. null string passed for object name.");
        }
        Boolean disabled = null;
        if (disabledFlag != 0) {
            disabled = 1 == disabledFlag;
        }
        objectId = gblCache.createObject(tenantID, name, localeId, hasRecipients, type, hasSecurity, disabled, externalId, hasCredentialNamespaces, outputLocale, outputFormat, hasRecipientsEmail, false);
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CMCacheDiscardObject(int objectId) {
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            gblCache.deleteObject(gblCache.getObjectWithId(objectId), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int CMCacheDeleteObject(int objectId) throws CMCacheException {
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            CacheEntry cacheObject = gblCache.getObjectWithId(objectId);
            if (cacheObject != null) {
                gblCache.deleteObject(cacheObject, true, true);
            }
        }
        return 1;
    }

    @Override
    public int CMCacheDuplicateObject(int objectId, String newName, int tenantId) throws CMCacheException {
        int duplicatedObjectId = gblCache.duplicateObject(objectId, newName, tenantId);
        return duplicatedObjectId;
    }

    @Override
    public void CMCacheEnableLogging(boolean enable) throws CMCacheException {
        CCacheLog.getGlobalCCacheLog().setLogging(enable);
        if (enable) {
            CCacheLog.getGlobalCCacheLog().initJavaLogging();
        }
    }

    @Override
    public void CMCacheGetAllNames(int objectId, List<String> names, List<Integer> locales) throws CMCacheException {
        gblCache.getAllNames(gblCache.getObjectWithId(objectId), names, locales);
    }

    @Override
    public void packageAccManName(int objectId, String accmanName, List<String> names, List<Integer> locales) {
        gblCache.buildNameFromCAMDefaultName(gblCache.getObjectWithId(objectId), accmanName, names, locales);
    }

    @Override
    public int[] CMCacheGetAncestorObjects(int objectId) throws CMCacheException {
        List<CacheEntry> parentPath = gblCache.getParents(objectId);
        int[] results = new int[parentPath.size()];
        if (0 < parentPath.size()) {
            for (int i = 0; i < parentPath.size(); ++i) {
                results[i] = parentPath.get(i).getObjectId();
            }
        }
        return results;
    }

    @Override
    public List<BaseCmObject> getAncestorInfo(int cmid) throws CMCacheException {
        List<CacheEntry> parents = gblCache.getParents(cmid);
        ArrayList<BaseCmObject> ancestors = new ArrayList<BaseCmObject>(parents.size());
        for (CacheEntry entry : parents) {
            BaseCmObject info = new BaseCmObject();
            info.cmid = entry.getObjectId();
            info.classID = entry.getType();
            info.tenantID = entry.getTenantId();
            info.storeID = entry.getStoreId2();
            ancestors.add(info);
        }
        return ancestors;
    }

    @Override
    public int CMCacheGetParent(int objectID) {
        CacheEntry e = gblCache.getObjectWithId(objectID);
        CacheEntry parent = e.getParent();
        if (parent == CacheTypes.UNSET) {
            return -1;
        }
        return parent.getObjectId();
    }

    @Override
    public void CMCacheGetAncestors(int objectId, int[] prefered_locales, List<String> names, List<String> searchPaths, List<String> classes, List<String> storeIDs) throws CMCacheException {
        int sizeSearch = 100;
        String searchPath = null;
        String name = null;
        String path = null;
        int[] locales = null;
        if (null != prefered_locales) {
            locales = prefered_locales;
        }
        List<CacheEntry> parentPath = gblCache.getParents(objectId);
        boolean notRoot = false;
        boolean ancestorsCached = false;
        CMExecutionContext ctx = CMExecutionContext.get();
        int userAccountId = this.getUserAccountId(ctx);
        if (objectId == userAccountId) {
            ancestorsCached = ctx.getAccountAncestorValues(names, classes, searchPaths, storeIDs);
        }
        if (!ancestorsCached) {
            int n = parentPath.size();
            for (int startIndex = 0; startIndex < n; ++startIndex) {
                int id = parentPath.get(startIndex).getObjectId();
                if (id != userAccountId || !ctx.getAccountDescendantAncestorValues(names, classes, searchPaths, storeIDs)) continue;
                String cachedPath = searchPaths.get(searchPaths.size() - 1);
                int iLen = cachedPath.length();
                if (iLen > sizeSearch) {
                    sizeSearch += iLen + 100;
                }
                searchPath = cachedPath;
                notRoot = true;
                break;
            }
            for (int i = startIndex - 1; i >= 0; --i) {
                CacheEntry entry = parentPath.get(i);
                int id = entry.getObjectId();
                if (entry.getObjectId() == 0) continue;
                name = gblCache.getName(entry, locales);
                String className = entry.getClassName();
                names.add(name);
                classes.add(className);
                String storeId = gblCache.getStoreId(entry, false);
                storeIDs.add(storeId);
                if (entry.isSecurityObject()) {
                    searchPath = path = gblCache.getSearchPath(id, locales);
                } else {
                    searchPath = searchPath == null ? "/" : searchPath + "/";
                    searchPath = searchPath + className;
                    if (notRoot) {
                        searchPath = searchPath + "[@name=";
                        StringBuffer buffer = new StringBuffer();
                        StringUtils.strAppendQuoted(buffer, name, '\u0000');
                        searchPath = searchPath + buffer.toString();
                        searchPath = searchPath + "]";
                    }
                    notRoot = true;
                }
                searchPaths.add(searchPath);
            }
        }
    }

    private int getUserAccountId(CMExecutionContext ctx) {
        int userAccountId = -1;
        try {
            userAccountId = ctx.getCurrentUserAccountObjectID();
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return userAccountId;
    }

    @Override
    public boolean CMCacheGetBooleanProperty(int objectId, int property) {
        return gblCache.getBooleanProperty(objectId, property);
    }

    @Override
    public int CMCacheGetClass(int objectId) throws CMCacheException {
        return gblCache.getIntegerProperty(objectId, 3);
    }

    @Override
    public int CMCacheGetConfigurationObject(int classId) throws CMCacheException {
        return gblCache.getConfigurationObject(classId);
    }

    @Override
    public int CMCacheGetDefaultNameLocale(int objectId, int[] prefered_locales) throws CMCacheException {
        return gblCache.getDefaultNameLocale(objectId, prefered_locales);
    }

    @Override
    public int[] getTenantRootsUnder(int objectId, Set<Integer> tenantIds) {
        QueryObjectID_List list = new QueryObjectID_List();
        this.getTenantRootsUnder(objectId, list, tenantIds);
        return list.toObjectIdArray();
    }

    public void getTenantRootsUnder(int objectId, QueryObjectID_List objects, Set<Integer> tenants) {
        CacheEntry root = gblCache.getObjectWithId(objectId);
        if (root == null || root.getTenantId() != 0) {
            return;
        }
        Stack<CacheEntry> stack = new Stack<CacheEntry>();
        CacheEntry walker = root.getFirstChild();
        while (walker != CacheTypes.UNSET) {
            if (walker.getTenantId() != 0) {
                if (tenants.contains(walker.getTenantId())) {
                    objects.add(walker);
                }
                walker = this.getTenantRootsUnderTraversalNext(stack, walker, false);
                continue;
            }
            walker = this.getTenantRootsUnderTraversalNext(stack, walker, true);
        }
    }

    private CacheEntry getTenantRootsUnderTraversalNext(Stack<CacheEntry> stack, CacheEntry current, boolean continueInSubtree) {
        CacheEntry next;
        if (continueInSubtree && (next = current.getFirstChild()) != CacheTypes.UNSET) {
            stack.push(current);
            return next;
        }
        next = current.getSibling();
        while (next == CacheTypes.UNSET && !stack.isEmpty()) {
            CacheEntry parent = stack.pop();
            next = parent.getSibling();
        }
        return next;
    }

    @Override
    public String CMCacheGetExactName(int objectId, int localeId) throws CMCacheException {
        if (localeId == gblCache.getSpecialId("CAMLocaleID")) {
            return this.CMCacheGetCachedProperty(objectId);
        }
        return gblCache.getExactName(objectId, localeId);
    }

    public String CMCacheGetCachedProperty(int objectId) {
        return gblCache.getCachedProperty(objectId);
    }

    @Override
    public boolean CMCacheGetHasChildren(int objectId) throws CMCacheException {
        return gblCache.getHasChildren(objectId);
    }

    @Override
    public int CMCacheGetIntegerProperty(int objectId, int property) {
        return gblCache.getIntegerProperty(objectId, property);
    }

    @Override
    public String CMCacheGetInternalCAMID(int objectId, long creationTime) throws CMException {
        return gblCache.createSecurityRef(objectId, creationTime);
    }

    @Override
    public String CMCacheGetName(int objectId, int[] prefered_locales) throws CMCacheException {
        if (prefered_locales[0] == gblCache.getSpecialId("CAMLocaleID")) {
            return gblCache.getCachedProperty(objectId);
        }
        return gblCache.getName(objectId, prefered_locales);
    }

    @Override
    public String CMCacheGetNameOnlyPath(int objectId, int[] prefered_locales) throws CMCacheException {
        return gblCache.getNameOnlyPath(objectId, prefered_locales);
    }

    @Override
    public String CMCacheGetSearchPath(int objectId, int[] prefered_locales) throws CMCacheException {
        return gblCache.getSearchPath(objectId, prefered_locales);
    }

    @Override
    public String CMCacheGetSecurityReference(int objectId) throws CMCacheException {
        return gblCache.getSecurityReference(objectId);
    }

    @Override
    public String CMCacheGetStoreId(int objectId, boolean internal) throws CMCacheException {
        CacheEntry entry = gblCache.getObjectWithId(objectId);
        return gblCache.getStoreId(entry, internal);
    }

    @Override
    public int CMCacheGetTypeOfChildren(int objectId) throws CMCacheException {
        return gblCache.getTypeOfChildren(objectId);
    }

    @Override
    public int initialize(ResultSet rs) throws CMCacheException {
        int numItems = 0;
        CCacheLog.getGlobalCCacheLog().logJavaMsg("cmCacheInitLoadedRS");
        try {
            numItems = gblCache.init(this, rs);
        }
        catch (InvalidTenantContainmentException e) {
            throw new CMCacheException((Throwable)e, "cmInvalidTenantContainmentOnStartup");
        }
        try {
            rs.close();
        }
        catch (SQLException ex) {
            throw new CMCacheException(ex.getMessage());
        }
        cacheInitDone = true;
        return numItems;
    }

    @Override
    public int initialize(CMDbConnection con) throws CMCacheException {
        int numItems = 0;
        try {
            numItems = gblCache.init(con, this);
        }
        catch (InvalidTenantContainmentException e) {
            throw new CMCacheException((Throwable)e, "cmInvalidTenantContainmentOnStartup");
        }
        cacheInitDone = true;
        return numItems;
    }

    @Override
    public int CMCacheInitReferenceTable(int table, ResultSet rs) throws CMCacheException {
        if (table != 0) {
            throw new CMCacheException("Invalid Table.");
        }
        int numItems = gblCache.initClassesTable(rs);
        try {
            rs.close();
        }
        catch (SQLException ex) {
            throw new CMCacheException(ex.getMessage());
        }
        return numItems;
    }

    @Override
    public int CMCacheInitSystemLocale(int systemLocale, int systemLocaleMapped, int camIdLocale) throws CMCacheException {
        gblCache.initSystemLocales(systemLocale, systemLocaleMapped, camIdLocale);
        return 0;
    }

    @Override
    public boolean CMCacheIsChild(int objectId, int destId) throws CMCacheException {
        return gblCache.isAncestor(objectId, destId);
    }

    @Override
    public boolean CMCacheIsChildOfClass(int objectId, int classId) throws CMCacheException {
        return gblCache.isChildOfClass(objectId, classId);
    }

    @Override
    public boolean CMCacheIsObjectDisabled(int objectId) throws CMCacheException {
        return gblCache.isObjectDisabled(objectId);
    }

    @Override
    public boolean CMCacheIsObjectExternal(int objectId) throws CMCacheException {
        return gblCache.isObjectExternal(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean CMCacheIsObjectValid(int objectId) throws CMCacheException {
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            return gblCache.isObjectValid(objectId);
        }
    }

    @Override
    public boolean CMCacheIsShortcut(int obj_id) throws CMCacheException {
        return false;
    }

    @Override
    public int CMCacheQuery(String queryPath, int forAction, String accmanPassportId, String biBusHeader, List<String> appActions, trustedService service, int lockType) throws CMCacheException, CMCacheAccessDenied, CMLockHandlerDenied {
        return this.CMCacheQuery(null, 0, queryPath, forAction, accmanPassportId, biBusHeader, appActions, service, lockType);
    }

    @Override
    public int CMCacheQuery(int[] startObjects, int numStartObjects, String queryPath, int forAction, String accmanPassportId, String biBusHeader, List<String> appActions, trustedService service, int lockType) throws CMCacheException, CMCacheAccessDenied, CMLockHandlerDenied {
        CacheAccessMan accMan = this.newAccessMan(accmanPassportId, biBusHeader, appActions, service);
        return this.CMCacheQuery(startObjects, numStartObjects, queryPath, forAction, lockType, accMan);
    }

    @Override
    public int CMCacheQuery(int[] startObjects, int numStartObjects, String queryPath, int forAction, int lockType, ICacheAccessMan accessMan) throws CMCacheException, CMCacheAccessDenied, CMLockHandlerDenied {
        int queryHandle = -1;
        ICacheQuery query2 = null;
        try {
            accessMan.setAction(forAction);
            queryHandle = gblCache.query(queryPath, forAction, -1, lockType, accessMan);
            query2 = gblCache.getQuery(queryHandle);
        }
        catch (CacheException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CacheException("Unknown Cache Exception in Query, before searching.", ex);
        }
        if (0 <= queryHandle && null != query2) {
            queryTimer.start();
            boolean success = false;
            try {
                query2.Parse(queryPath, startObjects, numStartObjects);
                success = true;
            }
            catch (CacheAccessDeniedException ex) {
                throw ex;
            }
            catch (CacheException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new CacheException("Unknown Cache Exception in Query, during parsing of '" + queryPath + "'", ex);
            }
            finally {
                if (!success) {
                    gblCache.releaseQueryHandle(queryHandle);
                }
                gblCache.endCacheRead();
                queryTimer.stop();
            }
        }
        return queryHandle;
    }

    @Override
    public void CMCacheSetAllNames(int objectId, List<String> names, List<Integer> locales) {
        gblCache.setAllNames(objectId, names, locales);
    }

    @Override
    public boolean CMCacheSetStoreId(int objectId, String storeId) {
        return gblCache.setStoreId(objectId, storeId);
    }

    @Override
    public boolean CMCacheReserveStoreId(int obj_id, String uuid) {
        return gblCache.reserveStoreId(obj_id, uuid);
    }

    @Override
    public void CMCacheUpdateStoreId(int obj_id, String uuid) {
        gblCache.updateStoreId(obj_id, uuid);
    }

    @Override
    public void CMCacheReleaseStoreId(int obj_id, String uuid) {
        gblCache.releaseStoreId(obj_id, uuid);
    }

    @Override
    public int[] resolveStoreIDs(Collection<InternalStoreId> ids) {
        return gblCache.resolveStoreIDs(ids);
    }

    @Override
    public InternalStoreId getInternalStoreId(int id) {
        return gblCache.getInternalStoreId(id);
    }

    @Override
    public void CMCacheUpdateBooleanProperty(int objectId, int property, boolean value) throws CMCacheException {
        gblCache.updateBooleanProperty(objectId, property, value);
    }

    @Override
    public void CMCacheUpdateIntProperty(int objectId, int property, int value) throws CMCacheException {
        gblCache.updateIntProperty(objectId, property, value);
    }

    @Override
    public void CMCacheUpdateStringProperty(int objectId, int property, String value, int localeId) throws CMCacheException {
        gblCache.updateStringProperty(objectId, property, value, localeId);
    }

    @Override
    public void CMCacheUpdateCachedProperty(int objectId, int property, String value) throws CMCacheException {
        CacheEntry entry = gblCache.getObjectWithId(objectId);
        entry.setCachedPropertyValue(value);
    }

    @Override
    public void CMCacheUpdateParentFormat(int objectId, int format) {
        gblCache.updateParentFormat(objectId, format);
    }

    @Override
    public boolean CMCacheValidateSecurityReference(int objectId, String ref) throws CMCacheException {
        String camId = gblCache.getSecurityReference(objectId);
        return null != camId && camId.equals(ref);
    }

    boolean isCacheInitialized() {
        return cacheInitDone;
    }

    @Override
    protected CMCacheQueryInstance getCacheQueryInstance(int queryHandle) {
        return CMCacheQueryInstanceJavaImpl.getInstance(queryHandle);
    }

    @Override
    public ICMLockManager getLockManager() {
        return gblCache.getLockManager();
    }

    @Override
    public void discardCMID(int cmid) {
        if (this.isValidNonRootCMID(cmid)) {
            try {
                this.CMCacheDiscardObject(cmid);
            }
            catch (Exception e) {
                CMIndications.logException(e);
            }
            if (AdvancedSettings.REMEMBERDISCARDEDCMIDS) {
                this.discardedCMIDs.add(new Integer(cmid));
            }
        }
    }

    private boolean isValidNonRootCMID(int cmid) {
        return cmid > 0;
    }

    @Override
    public Set<Integer> getDiscardedCMIDs() {
        return Collections.unmodifiableSet(this.discardedCMIDs);
    }

    @Override
    public String getImplementation() {
        return "Java CMCache";
    }

    @Override
    public CMStoreQueryResults executeQuery(int[] object_ids, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        return CMExecutionContext.get().getStore().executeQuery(object_ids, properties, orderBy, operation, permissions, extraPermission);
    }

    @Override
    public String CMCacheGenerateUniqueName(int objId) {
        return gblCache.generateUniqueName(objId);
    }

    @Override
    public void markObjectDeleted(int objectID) {
        CacheEntry e = gblCache.getObjectWithId(objectID);
        e.markDeleted();
    }

    @Override
    public int getVersionNumber(int objectID) {
        CacheEntry e = gblCache.getObjectWithId(objectID);
        return this.getVersionNumber(e);
    }

    private int getVersionNumber(CacheEntry e) {
        if (e != null) {
            return e.getVersionNumber();
        }
        return -1;
    }

    @Override
    public int getVersionNumber(String storeID) throws CMCacheException {
        return this.getVersionNumber(gblCache.getObjectWithStoreId(storeID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVersionNumbers(InternalStoreId[] ids) {
        int[] versions = new int[ids.length];
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            int i = 0;
            for (InternalStoreId id : ids) {
                CacheEntry entry = gblCache.getObjectWithStoreId(id);
                versions[i++] = CMCacheJavaImpl.isValidEntry(entry) ? entry.getVersionNumber() : -1;
            }
        }
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean assertContentObjects(InternalStoreId[] ids) {
        Object object = gblCache.getLockMutex();
        synchronized (object) {
            for (InternalStoreId id : ids) {
                CacheEntry entry = gblCache.getObjectWithStoreId(id);
                if (this.isContentObject(entry)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isContentObject(CacheEntry entry) {
        while (CMCacheJavaImpl.isValidEntry(entry)) {
            int type = entry.getType();
            if (type == CMObjectClass.CONTENT.getID() || type == CMObjectClass.FOLDER.getID() || type == CMObjectClass.PACKAGE.getID() || type == CMObjectClass.SESSION.getID() || type == CMObjectClass.CATALOG.getID()) {
                return true;
            }
            if (type == CMObjectClass.ROOT.getID()) break;
            entry = entry.getParent();
        }
        return false;
    }

    private static boolean isValidEntry(CacheEntry entry) {
        return entry != null && !(entry instanceof InvalidCacheEntry);
    }

    @Override
    public void incrementVersionNumber(int[] objectIDs) {
        for (int objectID : objectIDs) {
            CacheEntry e = gblCache.getObjectWithId(objectID);
            e.incrementVersionNumber();
        }
    }

    @Override
    public int CMCacheGetTenantID(int objId) {
        int objectTenantId = 0;
        CacheEntry entry = gblCache.getObjectWithId(objId);
        if (entry != null) {
            objectTenantId = entry.getTenantId();
        }
        return objectTenantId;
    }

    @Override
    public ICacheAccessMan newAccessMan(String passport) {
        CMExecutionContext ctx = CMExecutionContext.get();
        return this.newAccessMan(passport, ctx.getCAMAdditionalInfo(), null, ctx.getTrustedService());
    }

    @Override
    public ICacheAccessMan newAdminAccessMan() {
        return this.newAccessMan(null);
    }

    @Override
    public ICacheAccessMan newCacheAccessMan(String AccManPassportID, int queryOpts, List<String> permissions, List<String> otherPermissions, int permissionFlags) {
        ArrayList<String> passToCachePerms = null;
        if (permissions != null) {
            passToCachePerms = new ArrayList<String>(permissions);
        }
        if (otherPermissions != null) {
            if (passToCachePerms == null) {
                passToCachePerms = new ArrayList<String>(otherPermissions);
            } else {
                passToCachePerms.addAll(otherPermissions);
            }
        }
        if ((permissionFlags & 0x200) != 0 || (permissionFlags & 0x4000) != 0 || (queryOpts & 0x80) != 0) {
            AccManPassportID = null;
        } else if (CMExecutionContext.get().getCurrentUserIsAdministrator()) {
            AccManPassportID = null;
        }
        ICacheAccessMan accMan = this.newAccessMan(AccManPassportID);
        accMan.setPermissions(passToCachePerms);
        return accMan;
    }

    public CacheAccessMan newAccessMan(String accmanPassportId, String biBusHeader, List<String> appActions, trustedService service) {
        int numAppActions = appActions != null ? appActions.size() : 0;
        String[] actions = new String[numAppActions];
        if (appActions != null) {
            actions = appActions.toArray(actions);
        }
        CacheAccessMan accMan = new CacheAccessMan(gblCache, gblCache.getAAAProvider(), accmanPassportId, biBusHeader, actions);
        accMan.setTrustedService(service);
        return accMan;
    }

    @Override
    public int getPolicyObject(int objectId) {
        return gblCache.getPolicyObject(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEtag(String storeID) {
        CacheEntry entry = gblCache.getObjectWithStoreId(storeID);
        if (entry != null) {
            int versionHash = 0;
            int idHash = 0;
            Object object = gblCache.getLockMutex();
            synchronized (object) {
                while (!entry.isRoot()) {
                    versionHash += entry.getVersionNumber();
                    idHash ^= entry.getStoreId2().hashCode();
                    entry = entry.getParent();
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append(Integer.toHexString(idHash)).append('-').append(Integer.toHexString(versionHash));
            return buf.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentEtag(String storeID, int classId) {
        CacheEntry parent = gblCache.getObjectWithStoreId(storeID);
        if (parent instanceof LinkedCacheEntry) {
            int idHash = 0;
            int versionHash = 0;
            Object object = gblCache.getLockMutex();
            synchronized (object) {
                if (classId == -1) {
                    for (CacheEntry child : ((LinkedCacheEntry)parent).children()) {
                        versionHash += child.getVersionNumber();
                        idHash ^= child.getStoreId2().hashCode();
                    }
                } else {
                    for (CacheEntry child : ((LinkedCacheEntry)parent).children()) {
                        if (child.getType() != classId) continue;
                        versionHash += child.getVersionNumber();
                        idHash ^= child.getStoreId2().hashCode();
                    }
                }
                while (!parent.isRoot()) {
                    versionHash += parent.getVersionNumber();
                    idHash ^= parent.getStoreId2().hashCode();
                    parent = parent.getParent();
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append(Integer.toHexString(idHash)).append('-').append(Integer.toHexString(versionHash));
            return buf.toString();
        }
        return null;
    }

    public InternalStoreId getChild(int id, int clsId) {
        CacheEntry root = gblCache.getObjectWithId(id);
        for (CacheEntry child : ((LinkedCacheEntry)root).children()) {
            if (child.getType() != clsId) continue;
            return child.getStoreId2();
        }
        return null;
    }

    static {
        CMCacheJavaImpl.reset();
    }
}

