/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cache.CCacheLog;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheFreeList;
import com.cognos.cm.cache.CacheIndex;
import com.cognos.cm.cache.CacheLoader;
import com.cognos.cm.cache.CacheLockCounts;
import com.cognos.cm.cache.CacheLockHandlerJavaImpl;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.CacheUtils;
import com.cognos.cm.cache.CachedProperty;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.LastEntryCache;
import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.cache.MLProp;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.PolicyCacheEntry;
import com.cognos.cm.cache.PropertyCache;
import com.cognos.cm.cache.UniqueNameGenerator;
import com.cognos.cm.cache.entry.AbstractCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.entry.CacheEntryFactory;
import com.cognos.cm.cache.entry.StubCacheEntry;
import com.cognos.cm.cache.query.CacheEntryFilter;
import com.cognos.cm.cache.query.CacheQueryCache;
import com.cognos.cm.cache.query.ICacheQuery;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.cache.query.QueryPathStep;
import com.cognos.cm.cache.storeid.CacheStoreId;
import com.cognos.cm.cache.storeid.StoreIDMap;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.cam.AAAProvider_OpenIDProxy;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.locking.LockHandlerJavaImpl;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.store.CMCacheCallbacks;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMEnvironment;
import com.cognos.cm.util.StringUtils;
import com.cognos.cm.util.csv.CSVWriter;
import com.cognos.cmutils.collections.TraverseOrder;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cache
implements ICache {
    private static final int CLASSES_RESULTSET_COLUMN_ID = 1;
    private static final int CLASSES_RESULTSET_COLUMN_NAME = 2;
    public static final int INIT_RESULTSET_COLUMN_CMID = 1;
    public static final int INIT_RESULTSET_COLUMN_PCMID = 2;
    public static final int INIT_RESULTSET_COLUMN_NAME = 3;
    public static final int INIT_RESULTSET_COLUMN_LOCALEID = 4;
    public static final int INIT_RESULTSET_COLUMN_CLASSID = 5;
    public static final int INIT_RESULTSET_COLUMN_SHORTCUT = 6;
    public static final int INIT_RESULTSET_COLUMN_HASSECURITY = 7;
    public static final int INIT_RESULTSET_COLUMN_HASRECIPIENTS = 8;
    public static final int INIT_RESULTSET_COLUMN_DISABLED = 9;
    public static final int INIT_RESULTSET_COLUMN_CAMID = 10;
    public static final int INIT_RESULTSET_COLUMN_HASCREDNAMSPACES = 11;
    public static final int INIT_RESULTSET_COLUMN_LOCALE = 12;
    public static final int INIT_RESULTSET_COLUMN_FORMAT = 13;
    public static final int INIT_RESULTSET_COLUMN_HASMESSAGE = 14;
    public static final int INIT_RESULTSET_COLUMN_DEPLOYMENTUSAGE = 15;
    public static final int INIT_RESULTSET_COLUMN_HASRECIPIENTSEMAIL = 16;
    public static final int INIT_RESULTSET_COLUMN_STOREID = 17;
    public static final int INIT_RESULTSET_COLUMN_OWNER = 18;
    public static final int INIT_RESULTSET_COLUMN_VERSION = 19;
    public static final int INIT_RESULTSET_COLUMN_TENANTID = 20;
    private CMCacheCallbacks cmCallbacks;
    CacheIndex cacheIndex;
    private static String symCognosNSGuid = ":";
    private CacheQueryCache queryCache;
    private final StoreIDMap storeIdMap;
    private LastEntryCache lastEntryCache;
    private final Object readSync = new Object();
    private CacheFreeList freeList;
    private Map<Integer, String> classIdToName;
    private Map<String, Integer> classNameToId;
    public final int[] defaultLocale = new int[2];
    private final Map<String, Integer> specialIDs = new HashMap<String, Integer>();
    private AAAProvider aaa;
    private final ICMLockManager lockManager;
    private final Map<CachedProperty, PropertyCache> propertyCaches = new HashMap<CachedProperty, PropertyCache>();
    private CacheLockCounts lockCounts_ = new CacheLockCounts();
    CacheEntryFactory entryFactory;
    private boolean ignoreInvalidTenantContainment;
    private UniqueNameGenerator uniqueNameGenerator;
    private Map<Integer, CachedProperty> cachedPropertyMap = this.createCachedPropertyMap();

    public Cache() {
        this.classIdToName = new HashMap<Integer, String>();
        this.classNameToId = new HashMap<String, Integer>();
        this.cacheIndex = new CacheIndex();
        this.queryCache = new CacheQueryCache(AdvancedSettings.CMCACHE_QUERYCACHE_FREELIST_SIZE);
        this.freeList = new CacheFreeList(10000000L);
        this.storeIdMap = new StoreIDMap(1024);
        this.lastEntryCache = new LastEntryCache();
        this.aaa = CMServlet.AAA;
        this.lockManager = new CMLockManager(new LockHandlerJavaImpl());
        this.entryFactory = new CacheEntryFactory(this);
        this.uniqueNameGenerator = new UniqueNameGenerator();
    }

    private void addCacheEntry(CacheEntry entry) {
        this.cacheIndex.set(entry.getObjectId(), entry);
    }

    @Override
    public CMCacheCallbacks getCMCallbacks() {
        return this.cmCallbacks;
    }

    protected CacheEntry createObjectWithId(String name, int localeId, int objectId, int type) {
        return this.createObjectWithId(0, name, localeId, objectId, type);
    }

    public CacheEntry createObjectWithId(int tenantId, String name, int localeId, int objectId, int type) {
        CacheEntry e = this.entryFactory.createCacheEntry(tenantId, objectId, type, new CacheEntryFactory.CacheEntryName(name, localeId));
        this.addCacheEntry(e);
        return e;
    }

    CacheEntry createEntry(int tenantId, int objectId, int type) {
        this.freeList.allocateBlock(objectId);
        return this.createObjectWithId(tenantId, "", 0, objectId, type);
    }

    public CacheEntry createStubObjectWithId(int objectId) {
        CacheEntry e = this.entryFactory.createStubCacheEntry(this, objectId);
        this.addCacheEntry(e);
        return e;
    }

    @Override
    public void changeEntryId(int oldId, CacheEntry entry) {
        if (oldId != -1) {
            this.cacheIndex.set(oldId, null);
        }
        this.addCacheEntry(entry);
    }

    protected CacheEntry addObject(int tenantId, int objectId, int parentId, String name, int localeId, boolean hasRecipients, int type, boolean hasSecurity, Boolean disabled, String cachedPropertyValue, boolean hasCredNamespaces, int outputLocale, int outputFormat, boolean hasRecipientsEmail) {
        CCacheLog.getGlobalCCacheLog().logJavaMsg2IntsAndString("cmCacheAddObject", "ID", objectId, "ParentID", parentId, "Name", name);
        this.freeList.allocateBlock(objectId);
        CacheEntry entry = this.getObjectWithId(objectId);
        if (entry == null) {
            entry = this.createObjectWithId(tenantId, name, localeId, objectId, type);
        } else if (entry instanceof StubCacheEntry) {
            CacheEntry stubParent = entry;
            entry = this.createObjectWithId(tenantId, name, localeId, objectId, type);
            entry.adoptChildren(stubParent);
        } else {
            entry.addName(name, localeId);
        }
        if (null != cachedPropertyValue) {
            entry.setCachedPropertyValue(cachedPropertyValue);
            if (!this.entryTypeMatches(entry, CLSID.dispatcher, CLSID.schedule, CLSID.history, CLSID.genericDocument) && !CacheUtils.isTimeBasedCamId(cachedPropertyValue)) {
                entry.setHasExID(true);
            }
            if (entry.matchesQuickLookupProperty(symCognosNSGuid)) {
                entry.setInCognosNS(true);
                this.putSpecialId("CognosNamespaceID", objectId);
            }
        }
        entry.setHasRecipients(hasRecipients);
        entry.setHasRecipientsEmail(hasRecipientsEmail);
        entry.setDisabled(disabled);
        entry.setHasSecurity(hasSecurity);
        entry.setHasCredNamespace(hasCredNamespaces);
        entry.setOutputFormat(outputFormat);
        if (0 != outputLocale) {
            entry.setLocale(outputLocale);
        }
        if (0 != objectId) {
            this.linkObject(objectId, parentId, false, cachedPropertyValue);
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheEndAddObject", "ID", objectId);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocateQueryHandle() {
        int handle = -1;
        CCacheLog.getGlobalCCacheLog().logJavaMsg("cmCacheAllocateQuery");
        Object object = this.readSync;
        synchronized (object) {
            handle = this.queryCache.allocateQuery();
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheEndAllocateQuery", "Handle", handle);
        return handle;
    }

    @Override
    public int beginCacheRead() {
        return this.allocateQueryHandle();
    }

    @Override
    public String createSecurityRef(int objectId, long creationTime) {
        StringBuffer buffer = new StringBuffer();
        int hi32 = (int)(creationTime >> 32);
        int low32 = (int)(creationTime & 0xFFFFFFFFFFFFFFFFL);
        buffer.append("::");
        buffer.append(objectId);
        buffer.append(":");
        if (0 < hi32) {
            buffer.append(Integer.toHexString(hi32).toUpperCase());
        }
        buffer.append(Integer.toHexString(low32).toUpperCase());
        return buffer.toString();
    }

    @Override
    public void clearData() {
        this.cacheIndex.clear();
        this.freeList.clear();
    }

    protected void initData() {
        this.cacheIndex = new CacheIndex(1000);
        this.freeList = new CacheFreeList(Integer.MAX_VALUE);
        this.storeIdMap.clear();
        this.queryCache = new CacheQueryCache(AdvancedSettings.CMCACHE_QUERYCACHE_FREELIST_SIZE);
        this.entryFactory = new CacheEntryFactory(this);
        this.entryFactory.initialize();
    }

    private boolean entryTypeMatches(CacheEntry entry, int ... classIds) {
        int entryType = entry.getType();
        for (int i = 0; i < classIds.length; ++i) {
            if (entryType != classIds[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createObject(int tenantId, String name, int localeId, boolean hasRecipients, int type, boolean hasSecurity, Boolean disabled, String cachedPropertyValue, boolean hasCredNamespaces, int outputLocale, int outputFormat, boolean hasRecipientsEmail, boolean isInCognosNS) {
        CCacheLog.getGlobalCCacheLog().logJavaMsgString("cmCacheCreateObjectBegin", "ObjectName", name);
        Object object = this.getLockMutex();
        synchronized (object) {
            int objectId = this.freeList.allocateBlock();
            CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheAllocateID", "ObjectID", objectId);
            CCacheLog.getGlobalCCacheLog().logJavaMsg("cmCacheObtainedSymbol");
            CacheEntry entry = this.createObjectWithId(tenantId, name, localeId, objectId, type);
            CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheSetEntryType", "Type", type);
            if (null != cachedPropertyValue) {
                entry.setCachedPropertyValue(cachedPropertyValue);
                if (!this.entryTypeMatches(entry, CLSID.dispatcher, CLSID.schedule, CLSID.history, CLSID.genericDocument) && !CacheUtils.isTimeBasedCamId(cachedPropertyValue)) {
                    entry.setHasExID(true);
                }
                if (cachedPropertyValue.equalsIgnoreCase(symCognosNSGuid)) {
                    entry.setInCognosNS(true);
                    this.putSpecialId("CognosNamespaceID", objectId);
                }
            }
            entry.setHasRecipients(hasRecipients);
            entry.setHasRecipientsEmail(hasRecipientsEmail);
            entry.setDisabled(disabled);
            CCacheLog.getGlobalCCacheLog().logJavaMsgString("cmCacheSetHasSecurity", "HasSecurity", hasSecurity ? "TRUE" : "FALSE");
            entry.setHasSecurity(hasSecurity);
            entry.setHasCredNamespace(hasCredNamespaces);
            entry.setOutputFormat(outputFormat);
            if (0 != outputLocale) {
                entry.setLocale(outputLocale);
            }
            if (isInCognosNS) {
                entry.setInCognosNS(true);
            }
            entry.setOwner(-2);
            entry.setHasChildWithPolicy(false);
            entry.setHasBurstChildren(false);
            entry.setHasBurstChildrenOnly(false);
            CCacheLog.getGlobalCCacheLog().logJavaMsgStringAndInt("cmCacheCreateObjectEnd", "Name", name, "ID", objectId);
            return objectId;
        }
    }

    @Override
    public boolean currentUserIsObjectOwner(int objectId) {
        try {
            return this.cmCallbacks.CurrentUserIsObjectOwner(objectId);
        }
        catch (CMException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void deleteChildren(CacheEntry parent) {
        CCacheLog.getGlobalCCacheLog().logJavaMsgString("cmCacheDeleteChildren", "ParentName", parent.getName(this.defaultLocale));
        ArrayList<Integer> deletedIDs = new ArrayList<Integer>();
        for (CacheEntry sibling = parent.getFirstChild(); sibling != CacheTypes.UNSET; sibling = sibling.getSibling()) {
            CacheEntry entryToDelete = sibling;
            deletedIDs.add(new Integer(entryToDelete.getObjectId()));
            this.deleteObject(entryToDelete, false, false);
        }
        this.freeList.freeBlocks(deletedIDs);
        CCacheLog.getGlobalCCacheLog().logJavaMsgString("cmCacheEndDeleteChildren", "ParentName", parent.getName(this.defaultLocale));
    }

    @Override
    public int deleteObject(CacheEntry entry, boolean unlinkRequired, boolean freeObjectIdInFreeList) {
        if (entry.getObjectId() == 0) {
            throw new CacheException("Cache.DeleteObject", "Illegal attempt to delete the cache root object.");
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheDelete", "ID", entry.getObjectId());
        try {
            if (freeObjectIdInFreeList) {
                this.freeList.freeBlock(entry.getObjectId());
            }
            this.deleteChildren(entry);
            CacheLockHandlerJavaImpl.getGlobalLockHandler().removeHeldLocksBeforeDelete(entry.getObjectId());
            entry.setMLProp(null);
            if (null != entry.getStoreId2()) {
                this.storeIdMap.remove(entry.getStoreId2());
            }
            CacheEntry parentEntry = entry.getParent();
            if (entry.getIsLast()) {
                this.getLastEntryCache().clearLastEntryOfClass(parentEntry, entry.getType(), entry.getTenantId());
            }
            if (unlinkRequired && parentEntry != CacheTypes.UNSET) {
                parentEntry.unlinkChild(entry);
            }
            this.cacheIndex.set(entry.getObjectId(), null);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheEndDelete", "ID", entry.getObjectId());
        return entry.getObjectId();
    }

    @Override
    public int duplicateObject(int srcObjectId, String newName, int tenantId) {
        MLEntry firstEntry;
        int newObjectId = -1;
        CacheEntry srcEntry = this.getObjectWithId(srcObjectId);
        String tmpName = null;
        int localeId = this.defaultLocale[0];
        if (null == newName && null != srcEntry.getMLProp() && null != (firstEntry = srcEntry.getMLProp().getFirst())) {
            tmpName = firstEntry.getValue();
            localeId = firstEntry.getLocaleCode();
        }
        if (null != srcEntry) {
            newObjectId = this.createObject(tenantId, null != newName ? newName : tmpName, localeId, srcEntry.getHasRecipients(), srcEntry.getType(), srcEntry.getHasSecurity(), srcEntry.getDisabled(), null, srcEntry.getHasCredNamespace(), srcEntry.getLocale(), srcEntry.getOutputFormat(), srcEntry.getHasRecipientsEmail(), srcEntry.getInCognosNS());
            boolean bCopyCAMID = srcEntry.getInCognosNS() && !srcEntry.getHasExID();
            CacheEntry destEntry = this.getObjectWithId(newObjectId);
            if (bCopyCAMID) {
                destEntry.setCachedPropertyValue(srcEntry.getQuickLookupProperty());
            }
            destEntry.setVersionNumber(srcEntry.getVersionNumber());
            if (null == newName && -1 != newObjectId) {
                MLProp destStrings = destEntry.getMLProp();
                if (null != srcEntry.getMLProp()) {
                    ArrayList<String> values = new ArrayList<String>();
                    ArrayList<Integer> locales = new ArrayList<Integer>();
                    srcEntry.getMLProp().getAll(values, locales);
                    destStrings.setAll(values, locales);
                }
            }
        }
        return newObjectId;
    }

    @Override
    public void endCacheRead() {
    }

    @Override
    public int executeLastFunction(int parentId, int classId) {
        CacheEntry lastEntry;
        CacheEntry parentEntry = this.getObjectWithId(parentId);
        CacheEntry childEntry = parentEntry.getFirstChild();
        if (childEntry == CacheTypes.UNSET) {
            return -1;
        }
        if (childEntry.getSibling() == CacheTypes.UNSET) {
            if (childEntry.getType() == classId) {
                return childEntry.getObjectId();
            }
            return -1;
        }
        boolean bUseCache = this.getLastEntryCache().canBeCached(parentEntry);
        if (bUseCache && null != (lastEntry = this.getLastEntryCache().getLastEntry(parentEntry, classId))) {
            return lastEntry.getObjectId();
        }
        int lastObjectId = -1;
        try {
            lastObjectId = this.cmCallbacks.executeLastFunction(parentId, classId);
        }
        catch (CMException ex) {
            throw new RuntimeException("Cache.executeLastFunction", ex);
        }
        if (bUseCache && lastObjectId > 0) {
            CacheEntry entry = this.getObjectWithId(lastObjectId);
            this.getLastEntryCache().setLastEntry(parentEntry, entry);
        }
        return lastObjectId;
    }

    protected String getAccmanName(String camId) {
        String nameQuery1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + AAAProvider_OpenIDProxy.AAA_PASSTHROUGH_TAG + "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" " + "xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" " + "xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" " + "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" " + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + "<SOAP-ENV:Header><bus:biBusHeader xsi:type=\"bus:biBusHeader\">";
        String nameQuery2 = "</bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body><bus:query><search>CAMID(&quot;";
        String nameQuery3 = "&quot;)</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\"><item xsi:type=\"cm:propEnum\">defaultName</item></properties></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String[] passport = new String[1];
        String[] headerInfo = new String[1];
        this.getAccmanSecurityContext(passport, headerInfo);
        if (null == passport[0] || 0 == passport[0].length()) {
            return null;
        }
        String camIdEncoded = XMLUtils.escape((String)camId);
        StringBuffer query2 = new StringBuffer();
        query2.append(nameQuery1);
        query2.append(headerInfo[0]);
        query2.append("</bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body><bus:query><search>CAMID(&quot;");
        query2.append(camIdEncoded);
        query2.append("&quot;)</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\"><item xsi:type=\"cm:propEnum\">defaultName</item></properties></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        String result = null;
        try {
            result = this.aaa.Search(passport[0], query2.toString());
        }
        catch (AAAException ex) {
            throw new RuntimeException("Cache.getAccmanName", ex);
        }
        if (null == result || 0 == result.length()) {
            return null;
        }
        int result_size = this.GetQueryResultSize(result);
        if (result_size <= 0) {
            return null;
        }
        int startName = result.indexOf("<defaultName");
        if (-1 == startName) {
            String errorMsg = "Unexpected error parsing the document returned from accman Search API.Couldn't parse to property start tag<defaultName> Query to AAA was: " + query2 + " Return document was: " + result;
            throw new CacheException("Cache.getAccmanName", errorMsg);
        }
        int startValue = result.indexOf("<value", startName);
        if (-1 == startValue) {
            // empty if block
        }
        if (startValue == result.indexOf("<value/>") || startValue == result.indexOf("<value></value>")) {
            return new String();
        }
        int endValue = result.indexOf("</value>", startValue);
        if (-1 == endValue) {
            // empty if block
        }
        startValue = result.indexOf(">", startValue + "<value".length());
        return XMLUtils.unescape((String)result.substring(startValue + 1, endValue));
    }

    private int GetQueryResultSize(String result) {
        int size = -1;
        String arrayStartStr = "baseClass[";
        int resultOffsetStart = result.indexOf("<queryResult");
        if (resultOffsetStart == -1) {
            String errorMsg = "Unexpected error parsing the document returned from accman Search API.Couldn't parse to get CAM queryResult start tag<queryResult> CAM return document was: " + result;
            throw new CacheException("Cache.getAccmanName", errorMsg);
        }
        int arrayStart = result.indexOf("baseClass[");
        if (arrayStart == -1) {
            return size;
        }
        int arrayStop = result.indexOf("]", arrayStart);
        if (arrayStop == -1) {
            return size;
        }
        String sizeStr = result.substring(arrayStart + "baseClass[".length(), arrayStop);
        size = Integer.valueOf(sizeStr);
        return size;
    }

    protected void getAccmanSecurityContext(String[] passport, String[] headerInfo) {
        ArrayList<String> passportAndAdditionalInfo = new ArrayList<String>();
        this.cmCallbacks.getAccmanInfo(passportAndAdditionalInfo);
        passport[0] = passportAndAdditionalInfo.get(0);
        headerInfo[0] = passportAndAdditionalInfo.get(1);
    }

    @Override
    public void getAllNames(CacheEntry entry, List<String> names, List<Integer> locales) {
        String accmanName = null;
        if (entry.getHasExID() && !entry.getInCognosNS() && entry.getType() != CLSID.namespace && !this.isOpenIdNamespaceObject(entry)) {
            accmanName = this.getAccmanName(entry.getQuickLookupProperty());
        }
        ArrayList<String> tmpNames = new ArrayList<String>();
        entry.getMLProp().getAll(tmpNames, locales);
        if (accmanName == null) {
            names.addAll(tmpNames);
        } else {
            for (int i = 0; i < locales.size(); ++i) {
                names.add(accmanName);
            }
        }
    }

    private boolean isOpenIdNamespaceObject(CacheEntry entry) {
        String camid;
        return entry.getHasExID() && CMCAMIDHelper.isOpenIDNamespaceObject(camid = entry.getQuickLookupProperty());
    }

    public boolean getBooleanProperty(CacheEntry entry, int property) {
        switch (property) {
            case 1: {
                return entry.getHasRecipients() || entry.getHasRecipientsEmail();
            }
            case 15: {
                return entry.getHasRecipients();
            }
            case 16: {
                return entry.getHasRecipientsEmail();
            }
            case 4: {
                return entry.getHasSecurity();
            }
            case 9: {
                return entry.getHasCredNamespace();
            }
            case 13: {
                return entry.getHasMessage();
            }
            case 6: {
                return this.isObjectDisabled(entry.getObjectId());
            }
        }
        throw new CacheException("Cache.getBooleanProperty", "Invalid property specified: " + property);
    }

    @Override
    public boolean getBooleanProperty(int objectId, int property) {
        CacheEntry entry = this.getObjectWithId(objectId);
        return this.getBooleanProperty(entry, property);
    }

    @Override
    public int getDefaultNameLocale(int objectId, int[] locales) {
        CacheEntry entry = this.getObjectWithId(objectId);
        return entry.getDefaultNameLocale(locales);
    }

    @Override
    public String getExactName(int objectId, int localeId) {
        String accmanName;
        CacheEntry entry = this.getObjectWithId(objectId);
        if (entry.getHasExID() && !entry.getInCognosNS() && entry.getType() != CLSID.namespace && !this.isOpenIdNamespaceObject(entry) && null != (accmanName = this.getAccmanName(entry.getQuickLookupProperty()))) {
            return accmanName;
        }
        return entry.getExactName(localeId);
    }

    @Override
    public String getCachedProperty(int objectId) {
        return this.getObjectWithId(objectId).getQuickLookupProperty();
    }

    @Override
    public boolean getHasChildren(int objectId) {
        return this.getObjectWithId(objectId).getFirstChild() != CacheTypes.UNSET;
    }

    @Override
    public int getIntegerProperty(int objectId, int property) {
        CacheEntry entry = this.getObjectWithId(objectId);
        switch (property) {
            case 3: {
                return entry.getType();
            }
            case 5: {
                return entry.getParent().getObjectId();
            }
            case 1: {
                return entry.getHasRecipients() || entry.getHasRecipientsEmail() ? 1 : 0;
            }
            case 15: {
                return entry.getHasRecipients() ? 1 : 0;
            }
            case 16: {
                return entry.getHasRecipientsEmail() ? 1 : 0;
            }
            case 9: {
                return entry.getHasCredNamespace() ? 1 : 0;
            }
            case 4: {
                return entry.getHasSecurity() ? 1 : 0;
            }
            case 6: {
                Boolean disabled = entry.getDisabled();
                if (null == disabled) {
                    return 0;
                }
                return disabled != false ? 1 : 2;
            }
            case 12: {
                return entry.getOutputFormat();
            }
            case 11: {
                return entry.getLocale();
            }
            case 14: {
                return entry.getDeploymentObjectUsage();
            }
            case 17: {
                return entry.getOwner();
            }
        }
        throw new CacheException("Cache.getIntegerProperty", "Invalid property specified: " + property);
    }

    @Override
    public String getName(int objectId, int[] locales) {
        return this.getName(this.getObjectWithId(objectId), locales, false);
    }

    @Override
    public String getName(CacheEntry entry, int[] locales) {
        return this.getName(entry, locales, false);
    }

    String getName(CacheEntry entry, int[] locales, boolean inUseCAMIDContext) {
        String name = null;
        if (null == locales || 0 == locales.length) {
            locales = this.defaultLocale;
        }
        if (this.hasAccmanName(entry)) {
            if (inUseCAMIDContext) {
                name = entry.getQuickLookupProperty();
            } else if (!this.isOpenIdNamespaceObject(entry)) {
                name = this.getAccmanName(entry.getQuickLookupProperty());
            }
        }
        if (name == null) {
            name = entry.getName(locales);
        }
        return name;
    }

    private boolean useCAMIDForName() {
        return AdvancedSettings.IPF_AUDIT_SECURITY_OBJECTS.equals("camid");
    }

    private boolean hasAccmanName(CacheEntry entry) {
        return entry.getType() != CLSID.namespace && entry.isExternalSecurityObject();
    }

    @Override
    public List<CacheEntry> getParents(int id) {
        return this.getParents(this.getObjectWithId(id));
    }

    @Override
    public List<CacheEntry> getParents(CacheEntry entry) {
        ArrayList<CacheEntry> results = new ArrayList<CacheEntry>();
        if (!entry.isRoot()) {
            CacheEntry fastNode1 = entry.getParent();
            CacheEntry fastNode2 = entry.getParent();
            while (!entry.isRoot()) {
                entry = entry.getParent();
                if (fastNode2 != CacheTypes.UNSET) {
                    fastNode1 = fastNode2.getParent();
                }
                if (fastNode1 != CacheTypes.UNSET) {
                    fastNode2 = fastNode1.getParent();
                }
                if (this.isLoopCondition(entry, fastNode1, fastNode2)) {
                    throw new CMRuntimeException(new CMException("cmFoundCircularCMIDsInCache", new CMException.Parm("display", this.getLoopedIDsForDisplay(results))), "cmFoundCircularCMIDsInCache");
                }
                results.add(entry);
            }
        }
        return results;
    }

    private String getLoopedIDsForDisplay(List<CacheEntry> results) {
        StringBuffer loopedIDs = new StringBuffer();
        loopedIDs.append("{ ");
        CacheEntry e = results.get(0);
        loopedIDs.append(e.getObjectId());
        for (int i = 1; i < results.size(); ++i) {
            loopedIDs.append(", ");
            loopedIDs.append(results.get(i).getObjectId());
        }
        loopedIDs.append("}");
        return loopedIDs.toString();
    }

    private boolean isLoopCondition(CacheEntry entry, CacheEntry fastNode1, CacheEntry fastNode2) {
        return !entry.isRoot() && (entry == fastNode1 || entry == fastNode2);
    }

    @Override
    public void getParentsPath(int objectId, List<CacheEntry> parentPath) {
        List<CacheEntry> parentList = this.getParents(this.getObjectWithId(objectId));
        for (int i = parentList.size() - 1; i >= 0; --i) {
            parentPath.add(parentList.get(i));
        }
    }

    @Override
    public String getNameOnlyPath(int objectId, int[] locales) {
        ArrayList<String> symPath = new ArrayList<String>();
        CacheEntry entry = this.getObjectWithId(objectId);
        boolean doFullNameOnlyPath = this.doFullNameOnlyPath();
        while (!(entry.isRoot() || this.isCurrentUser(entry) && this.appendCurrentUserNameOnlyPath(symPath))) {
            symPath.add(this.getName(entry, locales, this.useCAMIDForName()));
            if (!doFullNameOnlyPath && entry.isExternalSecurityObject()) break;
            entry = entry.getParent();
        }
        StringBuffer buffer = new StringBuffer();
        int numPaths = symPath.size();
        if (numPaths <= 0) {
            buffer.append('/');
        } else {
            for (int i = numPaths - 1; i >= 0; --i) {
                buffer.append('/');
                buffer.append(symPath.get(i));
            }
        }
        return buffer.toString();
    }

    private boolean isCurrentUser(CacheEntry entry) {
        if (entry.getType() == CLSID.account) {
            try {
                return entry.getObjectId() == CMExecutionContext.get().getCurrentUserAccountObjectID();
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean appendCurrentUserNameOnlyPath(ArrayList<String> path) {
        CMExecutionContext ctx = CMExecutionContext.get();
        String name = ctx.getCurrentUserDisplayName();
        List<String> ancestors = ctx.getCurrentUserAncestorNames();
        if (name != null && ancestors != null) {
            path.add(name);
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                path.add(ancestors.get(i));
            }
            return true;
        }
        return false;
    }

    private boolean doFullNameOnlyPath() {
        return AdvancedSettings.IPF_AUDIT_SECURITY_OBJECTS.equals("namesOnlyPath");
    }

    @Override
    public int getPolicyObject(int objectId) {
        CacheEntry entry = this.getObjectWithId(objectId);
        do {
            if (!entry.getHasSecurity()) continue;
            return entry.getObjectId();
        } while (!(entry = entry.getParent()).isRoot());
        return entry.getObjectId();
    }

    @Override
    public ICacheQuery getQuery(int queryHandle) {
        return this.queryCache.QUERY_IDToPtr(queryHandle);
    }

    @Override
    public String getSearchPath(int objectId, int[] locales) {
        String path = null;
        CacheEntry entryPath = this.getObjectWithId(objectId);
        path = entryPath.getHasExID() ? this.getExternalPath(entryPath) : (this.isCognosGroupOrRole(entryPath) ? this.getCognosGroupsOrRolesPath(entryPath) : this.getStandardPath(locales, entryPath));
        return path;
    }

    private String getStandardPath(int[] locales, CacheEntry entryPath) {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
        entries.add(entryPath);
        entries.addAll(this.getParents(entryPath));
        String path = entries.size() <= 1 ? "/" : this.getStandardPath(locales, entries);
        return path;
    }

    private String getStandardPath(int[] locales, List<CacheEntry> entries) {
        StringBuffer buffer = new StringBuffer();
        for (int i = entries.size() - 1; i >= 0; --i) {
            CacheEntry entry = entries.get(i);
            if (entry.isRoot()) continue;
            if (entry.getHasExID()) {
                buffer = new StringBuffer();
                buffer.append(this.getExternalPath(entry));
                continue;
            }
            buffer.append("/");
            this.appendClassNameToSearchPath(buffer, entry);
            this.appendNameToSearchPath(locales, buffer, entry);
        }
        return buffer.toString();
    }

    private void appendNameToSearchPath(int[] locales, StringBuffer buffer, CacheEntry entry) {
        if (!entry.getParent().isRoot()) {
            String name = this.getName(entry.getObjectId(), locales);
            buffer.append("[@name=");
            StringUtils.strAppendQuoted(buffer, name, '\u0000');
            buffer.append(']');
        }
    }

    private void appendClassNameToSearchPath(StringBuffer buffer, CacheEntry entry) {
        String className = this.getClassName(entry.getType());
        if (null == className) {
            throw new CacheException("Cache.getSearchPath", "Installation error. Unknown class type.");
        }
        buffer.append(className);
    }

    private String getCognosGroupsOrRolesPath(CacheEntry entryPath) {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
        entries.add(entryPath);
        entries.addAll(this.getParents(entryPath));
        StringBuffer path = new StringBuffer();
        path.append("CAMID(\"");
        this.buildCAMIDInnerForSearchPath(entries, path);
        path.append("\")");
        return path.toString();
    }

    private void buildCAMIDInnerForSearchPath(List<CacheEntry> entries, StringBuffer path) {
        for (int iPath = entries.size() - 1; iPath >= 0; --iPath) {
            CacheEntry entry = entries.get(iPath);
            if (!entry.getInCognosNS()) continue;
            if (entry.getObjectId() == this.getSpecialId("CognosNamespaceID")) {
                path.append(':');
                continue;
            }
            String name = entry.getName(this.defaultLocale);
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == ':') {
                    path.append(':');
                } else if (name.charAt(i) == '\"') {
                    path.append('\"');
                }
                path.append(name.charAt(i));
            }
            if (iPath <= 0) continue;
            path.append(':');
        }
    }

    private String getExternalPath(CacheEntry entry) {
        String camId = entry.getQuickLookupProperty();
        String path = "CAMID(\"" + camId + "\")";
        return path;
    }

    @Override
    public String getSecurityReference(int objectId) {
        if (!this.isObjectValid(objectId)) {
            return null;
        }
        CacheEntry entry = this.getObjectWithId(objectId);
        if (entry.getHasExID() || entry.getInCognosNS()) {
            String camId = entry.getQuickLookupProperty();
            if (null == camId && this.isCognosGroupOrRole(entry)) {
                throw new CacheException("CacheEntry.getSecurityReference", "Illegal call to getSecurityReference. Object is missing CAMID.");
            }
            if (null != camId) {
                return "CAMID(\"" + camId + "\")";
            }
        }
        return null;
    }

    @Override
    public void getAllChildrenOf(int parentId, QueryObjectID_List objectList, PolicyCacheEntry parentPolicy) {
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheGetAllChildren", "ID", parentId);
        CacheEntry parentEntry = this.getObjectWithId(parentId);
        int numRetrieved = 0;
        for (CacheEntry childEntry = parentEntry.getFirstChild(); childEntry != CacheTypes.UNSET; childEntry = childEntry.getSibling()) {
            PolicyCacheEntry policyEntry = parentPolicy;
            objectList.add(childEntry, policyEntry);
            ++numRetrieved;
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsg2Ints("cmCacheRetrievedChildren", "Parent", parentId, "NUM", numRetrieved);
    }

    @Override
    public int getCamIdLocale() {
        return this.getSpecialId("CAMLocaleID");
    }

    @Override
    public boolean getChildrenOf(ICacheQuery query2, int parentId, QueryObjectID_List objectList, QueryPathStep step, PolicyCacheEntry inheritedPolicy) {
        if (step.m_bWildcard) {
            CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheGetAllChildren", "ID", parentId);
        } else {
            CCacheLog.getGlobalCCacheLog().logJavaMsgStringAndInt("cmCacheGetAllChildren1", "Name", step.stepnametest_, "ID", parentId);
        }
        int numRetrieved = 0;
        CacheEntry parentEntry = this.getObjectWithId(parentId);
        boolean inherits = false;
        for (CacheEntry childEntry = parentEntry.getFirstChild(); childEntry != CacheTypes.UNSET; childEntry = childEntry.getSibling()) {
            PolicyCacheEntry policyEntry = inheritedPolicy;
            if (!step.TestCacheEntry(childEntry.getObjectId(), query2, childEntry, new MutableReference(policyEntry), false)) continue;
            inherits |= !childEntry.getHasSecurity();
            objectList.add(childEntry, inheritedPolicy);
            ++numRetrieved;
            if (step.isSimple() && step.getCardinality() == QueryPathStep.Cardinality.ZERO_OR_ONE) break;
        }
        if (step.m_bWildcard) {
            CCacheLog.getGlobalCCacheLog().logJavaMsg2Ints("cmCacheRetrievedChildren", "Parent", parentId, "NUM", numRetrieved);
        } else {
            CCacheLog.getGlobalCCacheLog().logJavaMsg2IntsAndString("cmCacheRetrievedChildren1", "Parent", parentId, "NUM", numRetrieved, "Name", step.stepnametest_);
        }
        return inherits;
    }

    @Override
    public String getClassName(int classId) {
        return this.classIdToName.get(classId);
    }

    @Override
    public int getConfigurationObject(int classId) {
        int foundId = -1;
        for (CacheEntry childEntry = this.getObjectWithId(0).getFirstChild(); childEntry != CacheTypes.UNSET; childEntry = childEntry.getSibling()) {
            if (childEntry.getType() != classId) continue;
            foundId = childEntry.getObjectId();
            break;
        }
        return foundId;
    }

    private void getDataSourceObjects(CacheEntry parent, QueryObjectID_List objectList, ICacheAccessMan accessMan, PolicyCacheEntry parentPolicy) {
        MutableReference parentPolicyRef = new MutableReference(parentPolicy);
        if (!this.hasTraverseAccess(parent, accessMan, parentPolicyRef)) {
            return;
        }
        for (CacheEntry child = parent.getFirstChild(); child != CacheTypes.UNSET; child = child.getSibling()) {
            MutableReference childPolicyRef = new MutableReference(parentPolicyRef.getReference());
            if (!this.isDataSourceSignonRelatedObject(child) || !this.hasExecuteAccess(child, accessMan, childPolicyRef)) continue;
            PolicyCacheEntry childPolicy = (PolicyCacheEntry)childPolicyRef.getReference();
            objectList.add(child, childPolicy);
            if (!child.hasChildren()) continue;
            this.getDataSourceObjects(child, objectList, accessMan, childPolicy);
        }
    }

    private boolean isDataSourceSignonRelatedObject(CacheEntry entry) {
        return this.entryTypeMatches(entry, CLSID.dataSourceSignon, CLSID.dataSourceConnection, CLSID.credential);
    }

    @Override
    public void getDataSources(int[] parentList, QueryObjectID_List objectList, ICacheAccessMan accessMan, PolicyCacheEntry parentPolicy) {
        CacheEntry parentEntry;
        int parentId = 0;
        if (0 < parentList.length && (parentEntry = this.getObjectWithId(parentId = parentList[0])).getType() == CLSID.dataSource) {
            this.getDataSourceObjects(parentEntry, objectList, accessMan, parentPolicy);
        }
    }

    @Override
    public void getDataSources(String dataSrcName, int parentId, QueryObjectID_List objectList, ICacheAccessMan accessMan, PolicyCacheEntry parentPolicy) {
        CacheEntryFilter filter;
        MutableReference parentPolicyRef;
        CacheEntry parent;
        if (0 == parentId) {
            parentId = this.getSpecialId("CognosNamespaceID");
        }
        if (!this.hasTraverseAccess(parent = this.getObjectWithId(parentId), accessMan, parentPolicyRef = new MutableReference(parentPolicy))) {
            return;
        }
        parentPolicy = (PolicyCacheEntry)parentPolicyRef.getReference();
        CacheEntryFilter cacheEntryFilter = filter = accessMan != null ? accessMan.getFilter() : CacheEntryFilter.NO_FILTERING;
        for (CacheEntry child = parent.getFirstChild(); child != CacheTypes.UNSET; child = child.getSibling()) {
            if (child.getType() != CLSID.dataSource || !filter.accept(child) || !child.hasName(dataSrcName)) continue;
            this.getDataSourceObjects(child, objectList, accessMan, parentPolicy);
            return;
        }
    }

    private boolean hasTraverseAccess(CacheEntry entry, ICacheAccessMan accessMan, MutableReference policy) {
        return accessMan == null || !entry.getHasSecurity() || accessMan.checkTraverseAccessObject(entry.getObjectId(), policy) || this.currentUserIsObjectOwner(entry.getObjectId());
    }

    private boolean hasExecuteAccess(CacheEntry entry, ICacheAccessMan accessMan, MutableReference policy) {
        return accessMan == null || accessMan.checkPermissionAccess(entry.getObjectId(), "execute", policy);
    }

    @Override
    public void getPersonalDataSources(String dataSrcName, int dataSourceObjId, QueryObjectID_List objects, ICacheAccessMan cacheAccessMan, PolicyCacheEntry parentPolicy) {
        CacheEntry userAccountObj = null;
        CMExecutionContext execContext = CMExecutionContext.get();
        try {
            if (!execContext.hasCapability("canUsePersonalDataSourceCredentials")) {
                return;
            }
            int accountId = execContext.getCurrentUserAccountObjectID();
            userAccountObj = this.getObjectWithId(accountId);
        }
        catch (CMException e) {
            return;
        }
        if (this.containsSSOAwareDataSource(objects)) {
            return;
        }
        for (CacheEntry userAccountChildEntry = userAccountObj.getFirstChild(); userAccountChildEntry != CacheTypes.UNSET; userAccountChildEntry = userAccountChildEntry.getSibling()) {
            if (userAccountChildEntry.getType() != CLSID.dataSourceCredential) continue;
            objects.add(userAccountChildEntry, parentPolicy);
        }
    }

    private boolean containsSSOAwareDataSource(QueryObjectID_List objects) {
        for (int i = 0; i < objects.size(); ++i) {
            CacheEntry e = objects.entryAt(i);
            if (!this.getBooleanProperty(e, 9)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStringProperty(int objectId, int property, int[] locales) {
        if (property == 0) {
            return this.getName(objectId, locales);
        }
        if (property == 7) {
            return this.getSearchPath(objectId, locales);
        }
        throw new CacheException("Cache.GetObjectStringProperty", "Invalid property specified: " + property);
    }

    @Override
    public int getTypeOfChildren(int objectId) {
        CacheEntry entry = this.getObjectWithId(objectId);
        if (entry.getFirstChild() == CacheTypes.UNSET) {
            return 0;
        }
        if (entry.getHasBurstChildrenOnly()) {
            return 1;
        }
        if (entry.getHasBurstChildren()) {
            return 2;
        }
        return 4;
    }

    @Override
    public int init(CMDbConnection con, CMCacheCallbacks callbacks) {
        if (null != callbacks) {
            this.cmCallbacks = callbacks;
        }
        this.ignoreInvalidTenantContainment = MultiTenancyUtils.get().ignoreInvalidContainmentOnStartup();
        this.clearData();
        this.initData();
        CacheLoader loader = new CacheLoader(this, con);
        int numObjects = loader.load();
        this.initCognosNS();
        this.ignoreInvalidTenantContainment = false;
        if (Boolean.getBoolean("com.cognos.cm.cache.dumpCache")) {
            this.dump();
        }
        return numObjects;
    }

    @Override
    public int init(CMCacheCallbacks callbacks, ResultSet rs) {
        this.ignoreInvalidTenantContainment = MultiTenancyUtils.get().ignoreInvalidContainmentOnStartup();
        if (null != callbacks) {
            this.cmCallbacks = callbacks;
        }
        CCacheLog.getGlobalCCacheLog().logJavaMsg("cmCacheBeginInit");
        int numObjectsRead = 0;
        CacheEntry entry = null;
        try {
            this.clearData();
            this.initData();
            int lastObjectId = -1;
            int lastObjectClassId = 0;
            boolean hasExternalCamId = false;
            String camId = null;
            while (rs.next()) {
                int currentObjectId = rs.getInt(1);
                int tenantId = rs.getInt(20);
                String name = rs.getString(3);
                int localeId = rs.getInt(4);
                lastObjectClassId = rs.getInt(5);
                int parentObjectId = rs.getInt(2);
                String storeId = rs.getString(17);
                if (0 == localeId) {
                    localeId = this.defaultLocale[0];
                }
                if (null == name || 0 == name.length()) {
                    String assignedName = "Missing object name";
                    assignedName = assignedName + " (CMID = ";
                    assignedName = assignedName + currentObjectId;
                    assignedName = assignedName + ")";
                    CMException.Parm[] msgParams = new CMException.Parm[]{new CMException.Parm("OldObjectName", name), new CMException.Parm("AssignedObjectName", assignedName), new CMException.Parm("CMID", currentObjectId), new CMException.Parm("PCMID", parentObjectId), new CMException.Parm("ObjectClass", lastObjectClassId), new CMException.Parm("StoreID", storeId)};
                    CMException cmEx = new CMException("cmObjectInvalidName", msgParams);
                    CMIndications.logException(cmEx);
                    name = assignedName;
                }
                if (lastObjectId != currentObjectId) {
                    if (lastObjectId != -1 && !hasExternalCamId && !(entry = this.getObjectWithId(lastObjectId)).getInCognosNS() && this.isCognosGroupOrRole(entry) && null != camId) {
                        entry.addInternalSecurityReference(lastObjectId, camId);
                    }
                    hasExternalCamId = false;
                    rs.getString(6);
                    camId = rs.getString(10);
                    if (null != camId && !CacheUtils.isTimeBasedCamId(camId)) {
                        hasExternalCamId = true;
                    }
                    Boolean disabled = null;
                    boolean disabledValue = rs.getBoolean(9);
                    if (!rs.wasNull()) {
                        disabled = disabledValue;
                    }
                    int outputLocale = rs.getInt(12);
                    int outputFormat = rs.getInt(13);
                    entry = this.addObject(tenantId, currentObjectId, parentObjectId, name, localeId, rs.getBoolean(8), lastObjectClassId, rs.getInt(7) == 1, disabled, camId, rs.getBoolean(11), outputLocale, outputFormat, rs.getBoolean(16));
                    int owner = rs.getInt(18);
                    if (rs.wasNull()) {
                        entry.setOwner(-1);
                    } else {
                        entry.setOwner(owner);
                    }
                    int version = rs.getInt(19);
                    entry.setVersionNumber(version);
                    if (lastObjectClassId == CLSID.deploymentDetail) {
                        entry.setHasMessage(0 != rs.getInt(14));
                        entry.setDeploymentObjectUsage(rs.getInt(15));
                    }
                    if (null != storeId) {
                        if (!this.setStoreId(currentObjectId, storeId)) {
                            throw new CacheException("Cache.Init", "Duplicate storeID.");
                        }
                    } else {
                        throw new CacheException("Cache.Init", "Invalid storeID.");
                    }
                    lastObjectId = currentObjectId;
                    ++numObjectsRead;
                } else {
                    entry = this.getObjectWithId(currentObjectId);
                    entry.addName(name, localeId);
                }
                if (localeId != this.getCamIdLocale()) continue;
                hasExternalCamId = true;
            }
            if (lastObjectId != -1 && !hasExternalCamId && !(entry = this.getObjectWithId(lastObjectId)).getInCognosNS() && this.isCognosGroupOrRole(entry)) {
                entry.addInternalSecurityReference(lastObjectId, camId);
            }
            CCacheLog.getGlobalCCacheLog().logJavaMsg("cmCacheEndInit");
        }
        catch (SQLException th) {
            throw new RuntimeException(th);
        }
        this.initCognosNS();
        this.ignoreInvalidTenantContainment = false;
        if (Boolean.getBoolean("com.cognos.cm.cache.dumpCache")) {
            this.dump();
        }
        return numObjectsRead;
    }

    private CacheEntry findCognosNS() {
        CacheEntry directory = CacheTypes.UNSET;
        CacheEntry root = this.getObjectWithId(0);
        for (CacheEntry entry : root.children()) {
            if (entry.getType() != CMObjectClass.DIRECTORY.getID()) continue;
            directory = entry;
            break;
        }
        if (directory != CacheTypes.UNSET) {
            for (CacheEntry entry : directory.children()) {
                if (entry.getType() != CMObjectClass.NAMESPACE.getID() || !entry.matchesQuickLookupProperty(symCognosNSGuid)) continue;
                return entry;
            }
        }
        return CacheTypes.UNSET;
    }

    private void initCognosNS() {
        CacheEntry cognosNs = this.findCognosNS();
        if (cognosNs == CacheTypes.UNSET) {
            return;
        }
        this.putSpecialId("CognosNamespaceID", cognosNs.getObjectId());
        for (CacheEntry e : cognosNs.descendantsOrSelf(TraverseOrder.preorder)) {
            e.setInCognosNS(true);
        }
    }

    @Override
    public boolean ignoreInvalidTenantContainment() {
        return this.ignoreInvalidTenantContainment || CMExecutionContext.get().repairInvalidContainment();
    }

    @Override
    public int initClassesTable(ResultSet rs) {
        this.classIdToName.clear();
        this.classNameToId.clear();
        try {
            while (rs.next()) {
                int classId = rs.getInt(1);
                String className = rs.getString(2);
                this.addClassMapping(classId, className);
            }
            return this.classIdToName.size();
        }
        catch (SQLException th) {
            throw new RuntimeException("Cache::InitClassesTable", th);
        }
    }

    void addClassMapping(int id, String name) {
        this.classNameToId.put(name, id);
        this.classIdToName.put(id, name);
        try {
            Field field = CLSID.class.getField(name);
            field.setInt(null, id);
        }
        catch (NoSuchFieldException field) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initSystemLocales(int system, int mappedSystem, int camId) {
        this.defaultLocale[0] = system;
        this.defaultLocale[1] = mappedSystem;
        this.putSpecialId("CAMLocaleID", camId);
    }

    @Override
    public boolean isAncestor(int objectId, int destId) {
        if (objectId == destId) {
            return true;
        }
        for (CacheEntry entry = this.getObjectWithId(objectId); entry != CacheTypes.UNSET; entry = entry.getParent()) {
            if (entry.getParent().getObjectId() != destId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChildOfClass(int objectId, int classId) {
        CacheEntry entry = this.getObjectWithId(objectId);
        while (!entry.isRoot()) {
            if (entry.getType() == (byte)classId) {
                return true;
            }
            entry = entry.getParent();
        }
        return false;
    }

    @Override
    public boolean isCognosGroupOrRole(CacheEntry entry) {
        if (entry.getHasExID() || !entry.getInCognosNS()) {
            return false;
        }
        return this.entryTypeMatches(entry, CLSID.role, CLSID.group, CLSID.distributionList, CLSID.contact);
    }

    @Override
    public boolean isCognosGroupOrRole(int objectId) {
        return this.isCognosGroupOrRole(this.getObjectWithId(objectId));
    }

    @Override
    public boolean isObjectDisabled(int objectId) {
        CacheEntry entry = this.getObjectWithId(objectId);
        do {
            if (null == entry.getDisabled()) continue;
            return entry.getDisabled();
        } while (!(entry = entry.getParent()).isRoot());
        return false;
    }

    @Override
    public boolean isObjectExternal(int objectId) {
        return this.getObjectWithId(objectId).getHasExID();
    }

    @Override
    public boolean isObjectValid(int objectId) {
        CacheEntry entry = null;
        if (objectId < 0) {
            return false;
        }
        entry = this.cacheIndex.get(objectId);
        return this.isObjectValid(entry);
    }

    @Override
    public boolean isObjectValid(CacheEntry entry) {
        if (null == entry) {
            return false;
        }
        return null != entry.getMLProp();
    }

    @Override
    public void linkObject(int objectId, int parentId, boolean unlinkRequired, String camId) {
        CacheEntry parentEntry;
        CacheEntry oldParentEntry;
        CCacheLog.getGlobalCCacheLog().logJavaMsg2Ints("cmCacheBeginLinkObject", "ID", objectId, "ParentID", parentId);
        CacheEntry entry = this.getObjectWithId(objectId);
        if (unlinkRequired && null != (oldParentEntry = entry.getParent()) && oldParentEntry != CacheTypes.UNSET) {
            oldParentEntry.unlinkChild(entry);
        }
        if ((parentEntry = this.getObjectWithId(parentId)) == null) {
            parentEntry = this.createStubObjectWithId(parentId);
        }
        parentEntry.linkChild(entry);
        this.configureSecurityContext(camId, entry);
        CCacheLog.getGlobalCCacheLog().logJavaMsg2Ints("cmCacheEndLinkObject", "ID", objectId, "ParentID", parentId);
    }

    private void configureSecurityContext(String camId, CacheEntry entry) {
        if (entry.matchesQuickLookupProperty(symCognosNSGuid)) {
            entry.setInCognosNS(true);
        } else {
            entry.setInCognosNS(entry.getParent().getInCognosNS());
        }
        if (this.isCognosGroupOrRole(entry)) {
            int objectId = entry.getObjectId();
            if (null != camId) {
                entry.addInternalSecurityReference(objectId, camId);
            } else {
                String stringEntry = entry.getQuickLookupProperty();
                if (null != stringEntry) {
                    entry.addSecurityReference(objectId, stringEntry);
                } else {
                    throw new CacheException("CacheEntry.LinkObject", "Illegal call to LinkObject. Missing internal CAMID.");
                }
            }
        }
    }

    @Override
    public CacheEntry getObjectWithId(int objectId) {
        CacheEntry entry = null;
        if (objectId < 0) {
            throw new CacheException("Cache.OBJECT_IDToPtr", "Error accessing a non-existent object id.");
        }
        entry = this.cacheIndex.get(objectId);
        if (null != entry && null == entry.getMLProp()) {
            throw new CacheException("Cache.OBJECT_IDToPtr", "Error accessing a non-existent object id with a NULL name: " + Long.toHexString(objectId));
        }
        return entry;
    }

    @Override
    public CacheEntry getObjectWithStoreId(InternalStoreId storeId) {
        return this.storeIdMap.get(storeId);
    }

    @Override
    public CacheEntry getObjectWithStoreId(String storeId) {
        InternalStoreId sID = InternalStoreId.fromString(storeId);
        if (sID == null) {
            return null;
        }
        return this.getObjectWithStoreId(sID);
    }

    @Override
    public int query(String query2, int forAction, int lockHandle, int lockType, ICacheAccessMan accMan) {
        if (query2.charAt(0) != '/' && query2.charAt(0) != 'F') {
            throw new CacheException("Cache.Query", "Invalid path, relative paths not supported, path must start with '/'.");
        }
        int queryHandle = this.beginCacheRead();
        try {
            ICacheQuery cacheQuery = this.queryCache.QUERY_IDToPtr(queryHandle);
            cacheQuery.setAction(forAction);
            cacheQuery.setLockManagerInfo(lockHandle, lockType);
            cacheQuery.setAccMan(accMan);
        }
        catch (Exception e) {
            this.releaseQueryHandle(queryHandle);
            throw e;
        }
        return queryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseQueryHandle(int handle) {
        CCacheLog.getGlobalCCacheLog().logJavaMsgInt("cmCacheReleaseQuery", "Handle", handle);
        try {
            Object object = this.readSync;
            synchronized (object) {
                ICacheQuery cacheQuery = this.queryCache.QUERY_IDToPtr(handle);
                cacheQuery.freeMem();
                this.queryCache.deleteQuery(handle);
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    @Override
    public void setAllNames(int objectId, List<String> names, List<Integer> locales) {
        this.getObjectWithId(objectId).setAllNames(names, locales);
    }

    private CacheEntry resolveCMID(int id) {
        CacheEntry entry = this.getObjectWithId(id);
        if (entry == null) {
            throw new CacheException("Cache.resolveCMID - invalid CMID: " + id);
        }
        return entry;
    }

    private CacheStoreId createStoreId(String value) {
        try {
            return new CacheStoreId(value);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException("Cache.createStoreId - Invalid storeID format: " + value, e);
        }
    }

    @Override
    public boolean setStoreId(int objectId, String storeId) {
        CacheEntry entry = this.resolveCMID(objectId);
        CacheStoreId sID = this.createStoreId(storeId);
        if (this.storeIdMap.put(sID, entry)) {
            InternalStoreId oldStoreId = entry.getStoreId2();
            if (null != oldStoreId) {
                this.storeIdMap.remove(oldStoreId);
            }
            entry.setStoreId2(sID);
            return true;
        }
        return false;
    }

    @Override
    public boolean reserveStoreId(int objectId, String storeId) {
        CacheEntry entry = this.resolveCMID(objectId);
        CacheStoreId sID = this.createStoreId(storeId);
        return this.storeIdMap.put(sID, entry);
    }

    @Override
    public void updateStoreId(int objectId, String storeId) {
        CacheEntry entry = this.resolveCMID(objectId);
        CacheStoreId sID = this.createStoreId(storeId);
        if (this.storeIdMap.get(sID) != entry) {
            throw new CacheException("Cache.updateStoreId - invalid target");
        }
        InternalStoreId oldSID = entry.getStoreId2();
        entry.setStoreId2(sID);
        this.storeIdMap.remove(oldSID);
    }

    @Override
    public void releaseStoreId(int objectId, String storeId) {
        CacheEntry entry = this.resolveCMID(objectId);
        CacheStoreId sID = this.createStoreId(storeId);
        if (this.storeIdMap.get(sID) != entry) {
            throw new CacheException("Cache.releseStoreId - invalid target");
        }
        this.storeIdMap.remove(sID);
    }

    @Override
    public int[] resolveStoreIDs(Collection<InternalStoreId> ids) {
        int[] result = new int[ids.size()];
        int n = 0;
        for (InternalStoreId id : ids) {
            CacheEntry entry = this.storeIdMap.get(id);
            if (!this.isObjectValid(entry)) continue;
            result[n++] = entry.getObjectId();
        }
        if (n < ids.size()) {
            int[] tmp = new int[n];
            System.arraycopy(result, 0, tmp, 0, n);
            result = tmp;
        }
        return result;
    }

    @Override
    public InternalStoreId getInternalStoreId(int id) {
        CacheEntry entry = this.resolveCMID(id);
        InternalStoreId storeId = entry.getStoreId2();
        if (storeId == null || this.storeIdMap.get(storeId) != entry) {
            return null;
        }
        return storeId;
    }

    @Override
    public void updateBooleanProperty(int objectId, int property, boolean value) {
        CacheEntry entry = this.getObjectWithId(objectId);
        switch (property) {
            case 15: {
                entry.setHasRecipients(value);
                break;
            }
            case 16: {
                entry.setHasRecipientsEmail(value);
                break;
            }
            case 4: {
                entry.setHasSecurity(value);
                break;
            }
            case 9: {
                entry.setHasCredNamespace(value);
                break;
            }
            case 13: {
                entry.setHasMessage(value);
                break;
            }
            default: {
                throw new CacheException("Cache.UpdateBooleanProperty", "Invalid property specified.");
            }
        }
    }

    @Override
    public void updateIntProperty(int objectId, int property, int value) {
        if (property == 5) {
            this.linkObject(objectId, value, true, null);
        } else if (property == 6) {
            CacheEntry entry = this.getObjectWithId(objectId);
            Boolean disabled = null;
            if (0 != value) {
                disabled = 1 == value;
            }
            entry.setDisabled(disabled);
        } else if (property == 12) {
            CacheEntry entry = this.getObjectWithId(objectId);
            if (entry.getType() == CLSID.output) {
                entry.setOutputFormat(value);
            }
        } else if (property == 11) {
            CacheEntry entry = this.getObjectWithId(objectId);
            entry.setLocale(value);
        } else if (property == 14) {
            CacheEntry entry = this.getObjectWithId(objectId);
            if (entry.getType() == CLSID.deploymentDetail) {
                entry.setDeploymentObjectUsage(value);
            }
        } else if (property == 17) {
            CacheEntry entry = this.getObjectWithId(objectId);
            entry.setOwner(value);
        } else if (property == 18) {
            CacheEntry entry = this.getObjectWithId(objectId);
            entry.setTenantId(value);
        } else {
            throw new CacheException("Cache.UpdateIntProperty", "Invalid property specified.");
        }
    }

    @Override
    public void updateStringProperty(int objectId, int property, String value, int localeId) {
        CacheEntry entry = this.getObjectWithId(objectId);
        if (null != entry) {
            switch (property) {
                case 0: {
                    entry.addName(value, localeId);
                    break;
                }
                default: {
                    throw new RuntimeException("Cache.UpdateStringProperty: Invalid property specified.");
                }
            }
        }
    }

    @Override
    public void updateParentFormat(int objectId, int format) {
        CacheEntry entry = this.getObjectWithId(objectId);
        CacheEntry parentEntry = entry.getParent();
        parentEntry.setOutputFormat(format);
    }

    @Override
    public int getSpecialClassId(String className) {
        Integer classId = this.classNameToId.get(className);
        return classId != null ? classId : -1;
    }

    @Override
    public int getSpecialId(String key) {
        Integer value = this.specialIDs.get(key);
        if (null != value) {
            return value;
        }
        return -1;
    }

    private void putSpecialId(String key, int value) {
        this.specialIDs.put(key, new Integer(value));
    }

    void setCognosNSGuid(String value) {
        symCognosNSGuid = value;
    }

    void setCMCacheCallbacks(CMCacheCallbacks cmCallbacks) {
        this.cmCallbacks = cmCallbacks;
    }

    void setAAA(AAAProvider aaa) {
        this.aaa = aaa;
    }

    void setSpecialId(String key, int id) {
        this.specialIDs.put(key, new Integer(id));
    }

    @Override
    public void setUseAccessMan(boolean value) {
    }

    @Override
    public ICMLockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public String getSearchPath(int objectId) {
        return this.getSearchPath(objectId, this.defaultLocale);
    }

    @Override
    public String getStoreId(CacheEntry entry, boolean internalQuery) {
        if (!internalQuery && (entry.getHasExID() || this.isCognosGroupOrRole(entry))) {
            return this.getSearchPath(entry.getObjectId());
        }
        if (entry.getStoreId2() == null) {
            return null;
        }
        return entry.getStoreId2().stringValue();
    }

    @Override
    public CacheEntry quickLookup(CachedProperty property, String value) {
        PropertyCache propertyCache = this.propertyCaches.get(property);
        if (null == propertyCache) {
            return null;
        }
        return propertyCache.getEntry(value);
    }

    @Override
    public void setQuickLookupValue(CachedProperty property, String value, CacheEntry entry) {
        PropertyCache propertyCache = this.propertyCaches.get(property);
        if (null == propertyCache) {
            propertyCache = new PropertyCache(entry.isCachedPropertyCaseSensitive());
            this.propertyCaches.put(property, propertyCache);
        }
        propertyCache.putEntry(value, entry);
    }

    @Override
    public Object getLockMutex() {
        return CMLockManager.getLockHandler();
    }

    @Override
    public CacheLockCounts getLockCounts() {
        return this.lockCounts_;
    }

    @Override
    public String generateUniqueName(int objId) {
        return this.getObjectWithId(objId).generateUniqueName();
    }

    @Override
    public void buildNameFromCAMDefaultName(CacheEntry entry, String accmanName, List<String> names, List<Integer> locales) {
        ArrayList<String> tmpNames = new ArrayList<String>();
        entry.getMLProp().getAll(tmpNames, locales);
        for (int i = 0; i < locales.size(); ++i) {
            names.add(accmanName);
        }
    }

    @Override
    public LastEntryCache getLastEntryCache() {
        return this.lastEntryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(CSVWriter csv) {
        AbstractCacheEntry.dumpHeader(csv);
        Object object = this.getLockMutex();
        synchronized (object) {
            for (int i = 0; i < this.cacheIndex.size(); ++i) {
                CacheEntry entry = this.cacheIndex.get(i);
                if (entry == null || !(entry instanceof AbstractCacheEntry)) continue;
                ((AbstractCacheEntry)entry).dump(csv);
                csv.endRecord();
            }
        }
    }

    public void dump() {
        File logDir = CMEnvironment.getCRNLogsDir();
        String name = "cmcache_dump_" + DateUtils.getIsoDate((Calendar)DateUtils.getDSTNeutralCalendar());
        name = name.replace(":", "").replace("-", "").replace('.', '_');
        File f = new File(logDir, name + ".csv");
        try {
            if (f.createNewFile()) {
                FileOutputStream fos = new FileOutputStream(f);
                CSVWriter csv = new CSVWriter((Appendable)new OutputStreamWriter((OutputStream)fos, "utf-8"));
                this.dump(csv);
                csv.close();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public UniqueNameGenerator getUniqueNameGenerator() {
        return this.uniqueNameGenerator;
    }

    @Override
    public CachedProperty getCachedPropertyType(int property) {
        return this.cachedPropertyMap.get(new Integer(property));
    }

    Map<Integer, CachedProperty> createCachedPropertyMap() {
        HashMap<Integer, CachedProperty> map = new HashMap<Integer, CachedProperty>();
        map.put(new Integer(9), new CachedProperty());
        map.put(new Integer(15), new CachedProperty());
        map.put(new Integer(5), new CachedProperty());
        map.put(new Integer(14), new CachedProperty());
        map.put(new Integer(16), new CachedProperty());
        return map;
    }

    @Override
    public AAAProvider getAAAProvider() {
        return this.aaa;
    }

    public static class CLSID {
        public static int account;
        public static int dispatcher;
        public static int schedule;
        public static int history;
        public static int genericDocument;
        public static int namespace;
        public static int dataSource;
        public static int dataSourceCredential;
        public static int group;
        public static int role;
        public static int distributionList;
        public static int contact;
        public static int output;
        public static int deploymentDetail;
        public static int dataSourceSignon;
        public static int credential;
        public static int dataSourceConnection;
    }
}

