/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.CAM.AAAException;
import com.cognos.CAM.AAA_AznRequest_t;
import com.cognos.cm.cache.Cache;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheUtils;
import com.cognos.cm.cache.ICache;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.PoliciesCache;
import com.cognos.cm.cache.PolicyCacheEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheEntryFilter;
import com.cognos.cm.cache.query.CheckTraverseAccessTree;
import com.cognos.cm.cache.query.CheckTraverseAccessTreeEntry;
import com.cognos.cm.cache.query.ContextTenantIdFilter;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.cache.query.TenantListFilter;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.trustedServices.trustedService;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CacheAccessMan
implements ICacheAccessMan {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private boolean accManInitialized;
    private String authenticatedHandle;
    private String biBusHeader;
    private PoliciesCache policyCache = new PoliciesCache();
    private String[] applicationPermissions = EMPTY_STRING_ARRAY;
    private int[] userNamespacesArray;
    private ICache cache;
    private AAAProvider aaa;
    private int action;
    private CacheEntryFilter filter = CacheEntryFilter.NO_FILTERING;

    protected CacheAccessMan() {
        this(new Cache(), CMServlet.AAA);
    }

    public CacheAccessMan(ICache cache, AAAProvider provider) {
        this(cache, provider, 0);
    }

    public CacheAccessMan(ICache cache, AAAProvider provider, int action) {
        this.cache = cache;
        this.aaa = provider;
        this.setAction(action);
    }

    public CacheAccessMan(ICache cache, AAAProvider provider, String passportId, String biBusHeader, String[] permissions) {
        this(cache, provider, 0);
        this.setAuthenticatedHandle(passportId, biBusHeader);
        this.setPermissions(permissions);
    }

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
        this.setTenantFilter();
    }

    @Override
    public boolean isPolicyCheckingEnabled() {
        return this.authenticatedHandle != null;
    }

    protected void setPoliciesCache(PoliciesCache _policyCache) {
        this.policyCache = _policyCache;
    }

    @Override
    public boolean canAccessNamespace(int objectId) {
        CacheEntry entry = this.cache.getObjectWithId(objectId);
        if (entry != null) {
            String camid = entry.getQuickLookupProperty();
            return CMExecutionContext.get().isUserAuthenticatedIntoNamespace(camid);
        }
        return false;
    }

    @Override
    public boolean checkAccessPolicy(String permission, PolicyCacheEntry policyEntry) {
        int access = this.getPolicyAccess(permission, policyEntry);
        if (access > -1) {
            return access == 0;
        }
        if (policyEntry.getPolicyBytes() != null) {
            try {
                access = this.aaa.CheckAccess(this.authenticatedHandle, policyEntry.getPolicyBytes(), null, permission, this.biBusHeader);
            }
            catch (AAAException ex) {
                throw new CacheException("CacheAccessMan.checkAccessPolicy", ex);
            }
            this.updatePolicyAccess(permission, policyEntry, access);
            return access == 0;
        }
        return false;
    }

    private boolean policyMatchesObject(PolicyCacheEntry policy, int objectId) {
        if (null != policy) {
            return objectId == policy.getObjID() || !this.cache.getBooleanProperty(objectId, 4);
        }
        return false;
    }

    private boolean permissionIsOneOf(String permission, String ... set) {
        if (null != permission && null != set) {
            for (String p : set) {
                if (!permission.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private PolicyCacheEntry getPolicyFromDataStore(int policyObjectId) {
        PolicyCacheEntry policy = null;
        ResultSet rs = null;
        try {
            byte[] policyBytes;
            Blob policyBlob;
            rs = this.cache.getCMCallbacks().getPolicies(new int[]{policyObjectId});
            if (null != rs && rs.next() && (policyBlob = rs.getBlob(2)) != null && null != (policyBytes = policyBlob.getBytes(1L, (int)policyBlob.length()))) {
                policy = new PolicyCacheEntry();
                policy.initialize(policyObjectId, policyBytes);
            }
        }
        catch (Exception ex) {
            throw new CacheException("CacheAccessMan.getPolicyFromDataStore", ex);
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return policy;
    }

    @Override
    public boolean checkPermissionAccess(int objectId, String permission, MutableReference policyRef) {
        if (null == this.authenticatedHandle) {
            return true;
        }
        PolicyCacheEntry policy = null;
        if (null != policyRef) {
            policy = (PolicyCacheEntry)policyRef.getReference();
        }
        policy = this.getObjectPolicy(objectId, policy);
        if (null != policyRef) {
            policyRef.setValue(policy);
        }
        return this.checkPermission(permission, objectId, policy);
    }

    @Override
    public void checkAppActionAccess(List<Integer> permissionAccessResults, PolicyCacheEntry policy) throws AAAException {
        if (null == this.authenticatedHandle) {
            return;
        }
        int[] results = this.bulkCheckAccess(this.applicationPermissions, policy.getPolicyBytes());
        if (null == policy.appActions_) {
            policy.appActions_ = new int[this.applicationPermissions.length];
        }
        for (int i = 0; i < this.applicationPermissions.length; ++i) {
            policy.appActions_[i] = results[i];
            permissionAccessResults.add(i, new Integer(results[i]));
        }
    }

    int[] bulkCheckAccess(String[] permissions, byte[] policyBytes) throws AAAException {
        if (null == permissions || null == policyBytes) {
            return null;
        }
        AAA_AznRequest_t[] requests = new AAA_AznRequest_t[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            requests[i] = new AAA_AznRequest_t(policyBytes, permissions[i], 2, "");
        }
        this.aaa.BulkCheckAccess(this.authenticatedHandle, requests, this.biBusHeader);
        int[] results = new int[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            results[i] = requests[i].nAccess;
        }
        return results;
    }

    @Override
    public boolean checkDisabledAccessPolicy(PolicyCacheEntry policyEntry) {
        boolean canAccess = false;
        if (null != policyEntry) {
            if (policyEntry.iCanWrite_ == 0 || policyEntry.iCanSetPolicy_ == 0) {
                return true;
            }
            if (null == policyEntry.getPolicyBytes()) {
                return false;
            }
            if (null == this.authenticatedHandle) {
                return true;
            }
            try {
                int[] results = this.bulkCheckAccess(new String[]{"write", "setPolicy"}, policyEntry.getPolicyBytes());
                policyEntry.iCanWrite_ = results[0];
                policyEntry.iCanSetPolicy_ = results[1];
                if (results[0] == 0 || results[1] == 0) {
                    canAccess = true;
                }
            }
            catch (AAAException ex) {
                throw new CacheException("CacheAccessMan.checkDisabledAccessPolicy()", ex);
            }
        }
        return canAccess;
    }

    @Override
    public int checkSysAdminNamespaceAccess(int objectId, String permission) {
        int value = 0;
        if ("read".equals(permission)) {
            value = 1;
        } else if ("traverse".equals(permission) && this.canAccessNamespace(objectId)) {
            value = 1;
        }
        return value;
    }

    @Override
    public boolean checkTraverseAccessObject(int objectId, MutableReference policyRef) {
        return this.checkPermissionAccess(objectId, "traverse", policyRef);
    }

    @Override
    public boolean checkTraverseAccessPolicy(PolicyCacheEntry policy) {
        return this.checkAccessPolicy("traverse", policy);
    }

    @Override
    public void checkTraverseAccessTree(QueryObjectID_List ids) {
        int count = ids.size();
        if (count == 0 || this.authenticatedHandle == null) {
            return;
        }
        CheckTraverseAccessTreeEntry[] checkResults = new CheckTraverseAccessTreeEntry[count];
        CheckTraverseAccessTree checkTree = this.buildTraverseAccessTree(ids, checkResults);
        if (checkTree != null) {
            checkTree.checkAccess();
            this.trimInaccessibleObjects(checkResults, ids);
        } else {
            ids.empty();
        }
    }

    private CheckTraverseAccessTree buildTraverseAccessTree(QueryObjectID_List ids, CheckTraverseAccessTreeEntry[] checkResults) {
        int count = ids.size();
        int parentId = -1;
        boolean isEmpty = true;
        CheckTraverseAccessTreeEntry parent = null;
        CheckTraverseAccessTreeEntry root = this.createTreeNode(null, this.cache.getObjectWithId(0));
        for (int i = 0; i < count; ++i) {
            CacheEntry entry = ids.entryAt(i);
            if (entry.getParent().getObjectId() != parentId) {
                parentId = -1;
                ArrayList<CacheEntry> ancestors = new ArrayList<CacheEntry>();
                ancestors.addAll(this.cache.getParents(entry));
                parent = root;
                for (int n = ancestors.size() - 2; n >= 0; --n) {
                    parent = this.createTreeNode(parent, (CacheEntry)ancestors.get(n));
                }
            }
            if (parent == null) continue;
            checkResults[i] = this.createTreeNode(parent, entry);
            isEmpty = false;
            parentId = entry.getParent().getObjectId();
        }
        return isEmpty ? null : new CheckTraverseAccessTree(this, root);
    }

    private CheckTraverseAccessTreeEntry createTreeNode(CheckTraverseAccessTreeEntry parent, CacheEntry entry) {
        CheckTraverseAccessTreeEntry treeEntry;
        if (entry.getObjectId() == -1) {
            return null;
        }
        if (!CacheAccessMan.isValidTenancyBranch(entry)) {
            return null;
        }
        int cmid = entry.getObjectId();
        if (parent != null && (treeEntry = parent.findChild(cmid)) != null) {
            return treeEntry;
        }
        PolicyCacheEntry policy = entry.getHasSecurity() ? this.findPolicy(cmid) : null;
        CheckTraverseAccessTreeEntry treeEntry2 = new CheckTraverseAccessTreeEntry(cmid, policy);
        if (parent != null) {
            parent.addChild(treeEntry2);
        }
        return treeEntry2;
    }

    private static boolean isValidTenancyBranch(CacheEntry entry) {
        return CMExecutionContext.get().canSeeObjectsWithTenantId(entry.getTenantId());
    }

    private void trimInaccessibleObjects(CheckTraverseAccessTreeEntry[] checkResults, QueryObjectID_List ids) {
        int i;
        int parentId = -1;
        boolean lastParentFailed = false;
        PolicyCacheEntry acquiredPolicy = null;
        ArrayList<Integer> removedItems = new ArrayList<Integer>();
        int count = ids.size();
        for (i = 0; i < count; ++i) {
            CheckTraverseAccessTreeEntry entry = checkResults[i];
            boolean failed = true;
            if (entry != null) {
                CheckTraverseAccessTreeEntry parent = entry.getParent();
                if (parent.getObjectID() != parentId) {
                    parentId = parent.getObjectID();
                    lastParentFailed = failed = parent.isAccessDenied();
                    if (!failed) {
                        acquiredPolicy = this.getAcquiredPolicy(parent);
                    }
                } else {
                    failed = lastParentFailed;
                }
            }
            if (failed) {
                removedItems.add(i);
                continue;
            }
            ids.setAcquiredPolicyAt(i, acquiredPolicy);
        }
        if (!removedItems.isEmpty()) {
            for (i = removedItems.size() - 1; i >= 0; --i) {
                ids.remove((Integer)removedItems.get(i));
            }
        }
    }

    private PolicyCacheEntry getAcquiredPolicy(CheckTraverseAccessTreeEntry parent) {
        while (parent != null) {
            if (parent.hasPolicy()) {
                return parent.getPolicy();
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public PolicyCacheEntry findPolicy(int objectId) {
        return this.policyCache.findPolicy(objectId);
    }

    @Override
    public void getAndCachePolicies(List<Integer> getPoliciesBuffer) {
        int[] policyIdArray = CacheUtils.toArray(getPoliciesBuffer);
        try {
            ResultSet rs = this.cache.getCMCallbacks().getPolicies(policyIdArray);
            if (null != rs) {
                while (rs.next()) {
                    int policyObjectId = rs.getInt(1);
                    Blob blob = rs.getBlob(2);
                    byte[] policyBytes = null;
                    if (null != blob && null != (policyBytes = blob.getBytes(1L, (int)blob.length()))) {
                        this.policyCache.addPolicy(policyObjectId, policyBytes);
                    }
                    if (policyBytes != null) continue;
                    CacheException warning = new CacheException("WARNING: No policy data found. policyObjectId=" + policyObjectId + " policyBytes=" + policyBytes);
                    CMIndications.logException(warning);
                }
                rs.close();
            }
        }
        catch (Exception ex) {
            throw new CacheException("CacheAccessMan.getAndCachePolicies()", ex);
        }
    }

    @Override
    public PolicyCacheEntry getObjectPolicy(int objectId, PolicyCacheEntry policy) {
        if (null == policy || !this.policyMatchesObject(policy, objectId)) {
            int policyObjectId = this.cache.getPolicyObject(objectId);
            policy = this.findPolicy(objectId);
            if (null == policy) {
                policy = this.getPolicyFromDataStore(policyObjectId);
            }
        }
        return policy;
    }

    private int getPolicyAccess(String sAction, PolicyCacheEntry policy) {
        if ("read".equals(sAction) && policy.iCanRead_ > -1) {
            return policy.iCanRead_;
        }
        if ("write".equals(sAction) && policy.iCanWrite_ > -1) {
            return policy.iCanWrite_;
        }
        if ("traverse".equals(sAction) && policy.iCanTraverse_ > -1) {
            return policy.iCanTraverse_;
        }
        if ("setPolicy".equals(sAction) && policy.iCanSetPolicy_ > -1) {
            return policy.iCanSetPolicy_;
        }
        if (this.applicationPermissions.length > 0 && policy.appActions_ != null) {
            for (int i = 0; i < this.applicationPermissions.length; ++i) {
                if (!this.applicationPermissions[i].equals(sAction) || policy.appActions_[i] <= -1) continue;
                return policy.appActions_[i];
            }
        }
        return -1;
    }

    public void initialize(String sInitDoc) {
        if (!this.accManInitialized) {
            this.accManInitialized = true;
            try {
                this.aaa.Initialize(sInitDoc, null, null);
            }
            catch (AAAException ex) {
                throw new CacheException("CacheAccessMan.initialize()", ex);
            }
        }
    }

    @Override
    public void setPermissions(String[] permissions) {
        this.applicationPermissions = permissions == null ? EMPTY_STRING_ARRAY : Arrays.copyOf(permissions, permissions.length);
    }

    @Override
    public void setAuthenticatedHandle(String authenticatedHandle, String biBusHeader) {
        this.authenticatedHandle = authenticatedHandle;
        this.biBusHeader = biBusHeader;
    }

    @Override
    public void setTrustedService(trustedService service) {
    }

    @Override
    public void terminate(String sTerminateDoc) {
        if (this.accManInitialized) {
            this.accManInitialized = false;
            try {
                this.aaa.Terminate(sTerminateDoc, null);
            }
            catch (AAAException aAAException) {
                // empty catch block
            }
        }
    }

    @Override
    public void updatePolicyAccess(String permission, PolicyCacheEntry policy, int access) {
        if ("read".equals(permission)) {
            policy.iCanRead_ = access;
        } else if ("traverse".equals(permission)) {
            policy.iCanTraverse_ = access;
        } else if ("write".equals(permission)) {
            policy.iCanWrite_ = access;
        } else if ("setPolicy".equals(permission)) {
            policy.iCanSetPolicy_ = access;
        }
        for (int i = 0; i < this.applicationPermissions.length; ++i) {
            if (!this.applicationPermissions[i].equals(permission)) continue;
            if (null == policy.appActions_) {
                policy.appActions_ = new int[this.applicationPermissions.length];
                Arrays.fill(policy.appActions_, -1);
            }
            policy.appActions_[i] = access;
        }
    }

    private boolean checkPermission(String permission, int objectId, PolicyCacheEntry policy) {
        if (policy == null) {
            return false;
        }
        if (!this.checkAccessPolicy(permission, policy)) {
            return this.cache.currentUserIsObjectOwner(objectId);
        }
        if (this.cache.isObjectDisabled(objectId) && !this.permissionIsOneOf(permission, "write", "setPolicy") && !this.checkDisabledAccessPolicy(policy)) {
            return this.cache.currentUserIsObjectOwner(objectId);
        }
        return true;
    }

    @Override
    public CacheEntryFilter getFilter() {
        return this.filter;
    }

    private void setFilter(CacheEntryFilter filter) {
        this.filter = filter;
    }

    @Override
    public String getPassportId() {
        return this.authenticatedHandle;
    }

    @Override
    public String[] getPermissions() {
        return this.applicationPermissions;
    }

    @Override
    public void setPermissions(List<String> permissions) {
        if (permissions != null) {
            this.setPermissions(permissions.toArray(new String[permissions.size()]));
        }
    }

    private void setTenantFilter() {
        CacheEntryFilter filter;
        int action = this.getAction();
        if (this.isMultiTenantDeploymentQuery(action)) {
            DeploymentExecutionContext deploymentContext = DeploymentExecutionContext.get();
            filter = new TenantListFilter(deploymentContext.getTenantIDIntList());
        } else {
            filter = this.isNonFilteredAction(action) || this.isNotFilteringContext() ? CacheEntryFilter.NO_FILTERING : new ContextTenantIdFilter();
        }
        this.setFilter(filter);
    }

    private boolean isNotFilteringContext() {
        CMExecutionContext context = CMExecutionContext.get();
        if (ConfigurationFactory.getConfig().namesHaveTenantScope()) {
            return context.hasUnfilteredAdminAccess();
        }
        return !this.isRestrictedViewAdministrator() && !this.isPolicyCheckingEnabled();
    }

    private boolean isRestrictedViewAdministrator() {
        CMExecutionContext context = CMExecutionContext.get();
        return !context.hasUnfilteredAdminAccess() && (context.getCurrentUserIsAdministrator() || context.isTenantAdministrator());
    }

    private boolean isMultiTenantDeploymentQuery(int action) {
        if (action == 10) {
            DeploymentExecutionContext deploymentContext = DeploymentExecutionContext.get();
            return deploymentContext.isMultiTenantDeployment() && deploymentContext.getTenantIDIntList() != null;
        }
        return false;
    }

    private boolean isNonFilteredAction(int action) {
        return action == 2 || action == 8;
    }
}

