/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CacheException;
import com.cognos.cm.server.AdvancedSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CacheFreeList {
    protected CacheFreeListBlock firstBlock_;
    private CacheFreeListBlock lastBlock_;
    private int numIDsAllocated_;

    private void unlink(CacheFreeListBlock block) {
        if (block == null) {
            throw new IllegalStateException();
        }
        CacheFreeListBlock left = block.prevFree;
        CacheFreeListBlock right = block.nextFree;
        if (block == this.firstBlock_) {
            this.firstBlock_ = right;
        }
        if (block == this.lastBlock_) {
            this.lastBlock_ = left;
        }
        if (left != null) {
            left.nextFree = right;
        }
        if (right != null) {
            right.prevFree = left;
        }
    }

    private boolean canMerge(CacheFreeListBlock lowerBound, CacheFreeListBlock upperBound) {
        boolean bMergeable = false;
        if (lowerBound != null && upperBound != null && upperBound.firstObj - lowerBound.lastObj == 1) {
            bMergeable = true;
        }
        return bMergeable;
    }

    private void merge(CacheFreeListBlock lowerBound, CacheFreeListBlock upperBound) {
        upperBound.firstObj = lowerBound.firstObj;
        this.unlink(lowerBound);
    }

    private void insert(CacheFreeListBlock left, CacheFreeListBlock right, int blk) {
        this.insert(left, right, blk, blk);
    }

    private void insert(CacheFreeListBlock left, CacheFreeListBlock right, int blk1, int blk2) {
        CacheFreeListBlock middle = new CacheFreeListBlock(blk1, blk2);
        if (this.firstBlock_ == null) {
            this.firstBlock_ = this.lastBlock_ = middle;
        } else {
            if (right == this.firstBlock_) {
                this.firstBlock_ = middle;
            }
            if (left == this.lastBlock_) {
                this.lastBlock_ = middle;
            }
            middle.nextFree = right;
            middle.prevFree = left;
            if (right != null) {
                right.prevFree = middle;
            }
            if (left != null) {
                left.nextFree = middle;
            }
        }
    }

    private void append(CacheFreeListBlock left, int blk) {
        CacheFreeListBlock right = left == null ? null : left.nextFree;
        this.insert(left, right, blk);
    }

    private void prepend(CacheFreeListBlock right, int blk) {
        CacheFreeListBlock left = right == null ? null : right.prevFree;
        this.insert(left, right, blk);
    }

    protected CacheFreeListBlock findEntry(int blk) {
        CacheFreeListBlock entry;
        block4: {
            int distanceLast;
            entry = null;
            if (this.firstBlock_ == null) break block4;
            int distanceFirst = Math.abs(blk - this.firstBlock_.firstObj);
            if (distanceFirst < (distanceLast = Math.abs(this.lastBlock_.firstObj - blk))) {
                entry = this.firstBlock_;
                while (entry != null && !entry.contains(blk)) {
                    entry = entry.nextFree;
                }
            } else {
                entry = this.lastBlock_;
                while (entry != null && !entry.contains(blk)) {
                    entry = entry.prevFree;
                }
            }
        }
        return entry;
    }

    public CacheFreeList(long num_objs) {
        this.lastBlock_ = this.firstBlock_ = new CacheFreeListBlock(0, (int)num_objs);
        this.numIDsAllocated_ = 0;
    }

    void clear() {
        this.firstBlock_ = null;
        this.lastBlock_ = null;
    }

    public int allocateBlock() {
        if (this.firstBlock_ == null) {
            throw new CacheException("CacheFreeList.allocateFromBlock", "free list is empty.");
        }
        CacheFreeListBlock block = AdvancedSettings.CMCACHE_ENABLEIDRECYCLING ? this.firstBlock_ : this.lastBlock_;
        return this.allocateFromBlock(block);
    }

    private int allocateFromBlock(CacheFreeListBlock theBlock) {
        int obj = theBlock.firstObj;
        ++theBlock.firstObj;
        if (theBlock.firstObj > theBlock.lastObj) {
            this.unlink(theBlock);
        }
        ++this.numIDsAllocated_;
        return obj;
    }

    public int allocateBlock(int blk) {
        CacheFreeListBlock entry = this.findEntry(blk);
        if (entry == null) {
            throw new CacheException("CacheFreeList.allocateBlock()", "Either block is already allocated, or cache can not allocate block for the object.");
        }
        if (blk == entry.firstObj) {
            ++entry.firstObj;
            if (entry.firstObj > entry.lastObj) {
                this.unlink(entry);
            }
        } else if (blk == entry.lastObj) {
            --entry.lastObj;
        } else {
            CacheFreeListBlock left = entry;
            CacheFreeListBlock right = entry.nextFree;
            CacheFreeListBlock middle = new CacheFreeListBlock(blk + 1, left.lastObj);
            middle.prevFree = entry;
            middle.nextFree = right;
            left.nextFree = middle;
            left.lastObj = blk - 1;
            if (left == this.lastBlock_) {
                this.lastBlock_ = middle;
            } else {
                right.prevFree = middle;
            }
        }
        ++this.numIDsAllocated_;
        return blk;
    }

    private int[] getContiguousChunk(List<Integer> ids, int pos) {
        int curr;
        int chunkStart;
        int chunkEnd = chunkStart = ids.get(pos).intValue();
        int chunkLength = 1;
        for (int i = pos + 1; i < ids.size() && (curr = ids.get(i).intValue()) == chunkStart + chunkLength++; ++i) {
            chunkEnd = curr;
        }
        return new int[]{chunkStart, chunkEnd};
    }

    public void freeBlocks(ArrayList<Integer> blksToFree) {
        Collections.sort(blksToFree);
        CacheFreeListBlock curr = this.firstBlock_;
        int pos = 0;
        while (pos < blksToFree.size()) {
            int[] chunk = this.getContiguousChunk(blksToFree, pos);
            int firstBlock = chunk[0];
            int lastBlock = chunk[1];
            pos += lastBlock - firstBlock + 1;
            CacheFreeListBlock left = null;
            CacheFreeListBlock right = curr;
            while (right != null && right.nextFree != null && right.firstObj < lastBlock) {
                right = right.nextFree;
            }
            left = right.prevFree;
            if (right.lastObj < firstBlock) {
                left = right;
                right = null;
            }
            if (left != null) {
                curr = left;
            }
            if (left != null && left.lastObj + 1 == firstBlock) {
                left.lastObj = lastBlock;
                if (!this.canMerge(left, right)) continue;
                this.merge(left, right);
                curr = right;
                continue;
            }
            if (right != null && right.firstObj - 1 == lastBlock) {
                right.firstObj = firstBlock;
                continue;
            }
            this.insert(left, right, firstBlock, lastBlock);
        }
    }

    public void freeBlock(int blk) {
        CacheFreeListBlock upperBound = this.firstBlock_;
        CacheFreeListBlock lowerBound = null;
        while (upperBound != null && upperBound.firstObj < blk) {
            lowerBound = upperBound;
            upperBound = upperBound.nextFree;
        }
        if (upperBound != null && upperBound.contains(blk) || lowerBound != null && lowerBound.contains(blk)) {
            throw new CacheException("CacheFreeList.freeBlock()", "Illegal attempt to free an unallocated id: " + blk);
        }
        if (upperBound != null && blk == upperBound.firstObj - 1) {
            upperBound.firstObj = blk;
            if (this.canMerge(lowerBound, upperBound)) {
                this.merge(lowerBound, upperBound);
            }
        } else if (lowerBound != null && blk == lowerBound.lastObj + 1) {
            lowerBound.lastObj = blk;
        } else if (upperBound != null) {
            this.prepend(upperBound, blk);
        } else {
            this.append(lowerBound, blk);
        }
        --this.numIDsAllocated_;
    }

    public int numAllocatedBlocks() {
        return this.numIDsAllocated_;
    }

    public int computeNumAllocatedObjects() {
        int numAllocated = 0;
        int lastFree = 0;
        CacheFreeListBlock fleThis = this.firstBlock_;
        while (fleThis != null) {
            numAllocated = fleThis.firstObj - lastFree;
            lastFree = fleThis.lastObj;
            fleThis = fleThis.nextFree;
        }
        return numAllocated;
    }

    public int computeNumBuckets() {
        int nBuckets = 0;
        CacheFreeListBlock entry = this.firstBlock_;
        while (entry != null) {
            ++nBuckets;
            entry = entry.nextFree;
        }
        return nBuckets;
    }

    public AllocatedObjectsIterator getAllocatedObjects() {
        return new AllocatedObjectsIterator(this.firstBlock_);
    }

    protected class CacheFreeListBlock {
        private int firstObj;
        private int lastObj;
        private CacheFreeListBlock nextFree;
        private CacheFreeListBlock prevFree;

        public CacheFreeListBlock(int first, int last) {
            this.firstObj = first;
            this.lastObj = last;
        }

        public boolean contains(int id) {
            return this.firstObj <= id && id <= this.lastObj;
        }

        int getFirst() {
            return this.firstObj;
        }

        int getLast() {
            return this.lastObj;
        }
    }

    public class AllocatedObjectsIterator {
        private CacheFreeListBlock curBlock_;
        private int curObjectId_;

        public AllocatedObjectsIterator(CacheFreeListBlock first) {
            this.curBlock_ = first;
            this.curObjectId_ = 0;
        }

        public boolean hasNext() {
            return this.curObjectId_ != this.curBlock_.firstObj || this.curBlock_.nextFree != null;
        }

        public int next() {
            while (this.curObjectId_ == this.curBlock_.firstObj) {
                if (this.curBlock_.nextFree == null) {
                    throw new IllegalStateException();
                }
                this.curObjectId_ = this.curBlock_.lastObj + 1;
                this.curBlock_ = this.curBlock_.nextFree;
            }
            return this.curObjectId_++;
        }
    }
}

