/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.Cache;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheTypes;
import com.cognos.cm.cache.CacheUtils;
import com.cognos.cm.cache.MLProp;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.dbstore.statement.BaseDialect;
import com.cognos.cm.dbstore.statement.StatementFormatter;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMStringLocale;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CacheLoader {
    private TableLoader[] beforeLink = new TableLoader[]{new CMOBJECTS_Loader(), new CMSTOREIDS_Loader(), new CMOBJNAMES_Loader(), new CMOBJPROPS1_Loader(), new CMOBJPROPS54_Loader(), new CMPOLICIES_Loader(), new CMOBJPROPS25_Loader(), new CMOBJPROPS14_Loader(), new CMOBJPROPS11_Loader(), new CMOBJPROPS6_Loader(), new CMOBJPROPS2_Loader(), new CMREFORD1_Loader(), new CMREFNOORD1_Loader(), new CMOBJPROPS89_Loader()};
    private TableLoader[] afterLink = new TableLoader[]{new CMREFNOORD2_Loader()};
    private final Cache cache;
    private final CMDbConnection connection;
    private final StatementFormatter formatter;
    private boolean hasErrors = false;
    private int fetchSize = -1;

    public CacheLoader(Cache cache, CMDbConnection con) {
        this.cache = cache;
        this.connection = con;
        BaseDialect dialect = BaseDialect.getDialect(CMDbConnection.getDbmsInfo());
        this.formatter = new StatementFormatter(dialect);
        this.getFetchSize();
    }

    public int load() {
        int count = 0;
        try {
            this.loadTables(this.beforeLink);
            count = this.linkEntries();
            this.loadTables(this.afterLink);
        }
        catch (SQLException e) {
            throw new CacheException("Cache initialization failed", e);
        }
        if (this.hasErrors) {
            this.error("Cache errors detected. Please run consistency check");
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables(TableLoader[] loaders) throws SQLException {
        for (TableLoader tl : loaders) {
            Statement st = this.connection.createStatement();
            this.setFetchSize(st);
            ResultSet rs = null;
            try {
                String statement = this.getStatement(tl);
                rs = st.executeQuery(statement);
                this.processResult(tl, rs);
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(st);
            }
        }
    }

    private void setFetchSize(Statement st) {
        if (this.fetchSize > 0) {
            try {
                st.setFetchSize(this.fetchSize);
            }
            catch (SQLException e) {
                this.error("Unable to set statement fetch size: " + e.getMessage());
            }
        }
    }

    private void getFetchSize() {
        String fetchsizeOpt = System.getProperty("cmcacheFetchSize");
        if (fetchsizeOpt != null && !"".equalsIgnoreCase(fetchsizeOpt)) {
            try {
                this.fetchSize = Integer.valueOf(fetchsizeOpt);
            }
            catch (NumberFormatException e) {
                this.error("System property cmcacheFetchSize has invalid value:" + fetchsizeOpt);
            }
        }
    }

    private String getStatement(TableLoader tl) {
        String statement = tl.statement;
        if (tl.isTemplate) {
            statement = this.formatter.format(statement);
        }
        return statement;
    }

    private void processResult(TableLoader tl, ResultSet rs) throws SQLException {
        while (rs.next()) {
            try {
                tl.processResult(rs);
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            catch (Exception e) {
                this.hasErrors = true;
                this.error(e.getMessage());
            }
        }
    }

    int linkEntries() {
        int size = this.cache.cacheIndex.size();
        CacheEntry entry = this.cache.getObjectWithId(0);
        if (entry == null) {
            this.error("Can't locate root entry!");
            return 0;
        }
        entry.setOwner(-1);
        int count = 1;
        for (int i = 1; i < size; ++i) {
            entry = this.cache.getObjectWithId(i);
            if (entry == null) continue;
            ++count;
            if (entry.getParent() != CacheTypes.UNSET || !this.linkChain(entry)) continue;
            this.validateEntry(entry);
        }
        return count;
    }

    private boolean linkChain(CacheEntry entry) {
        int cmid = entry.getObjectId();
        int pcmid = entry.getOwner();
        entry.setOwner(-1);
        if (pcmid == -1) {
            if (entry.getHasExclusiveLock()) {
                this.logInvalidEntry(cmid, "loop detected");
            } else {
                this.logInvalidEntry(cmid, "parent is missing");
            }
            return false;
        }
        CacheEntry parent = this.cache.getObjectWithId(pcmid);
        if (parent == null) {
            this.logInvalidEntry(cmid, "invalid parent (PCMID=" + pcmid + ")");
            return false;
        }
        boolean result = true;
        if (pcmid != 0 && parent.getParent() == CacheTypes.UNSET) {
            entry.setHasExclusiveLock(true);
            result = this.linkChain(parent);
            entry.setHasExclusiveLock(false);
        }
        if (result) {
            parent.linkChild(entry);
        }
        return result;
    }

    private boolean validateEntry(CacheEntry entry) {
        MLProp name;
        boolean isValid = true;
        if (entry.getStoreId2() == null) {
            this.logInvalidEntry(entry.getObjectId(), "storeID is missing");
            isValid = false;
        }
        if ((name = entry.getMLProp()) == null || name.size() == 0) {
            this.logInvalidEntry(entry.getObjectId(), "name is missing");
            isValid = false;
        }
        return isValid;
    }

    private void error(String message) {
        CMIndications.Audit_Message(message);
    }

    protected void logInvalidEntry(int cmid, String reason) {
        String msg = String.format("Invalid entry (CMID=%d): %s", cmid, reason);
        this.error(msg);
        this.hasErrors = true;
    }

    class CMOBJPROPS89_Loader
    extends CachedPropertyLoader {
        CMOBJPROPS89_Loader() {
            super("CMOBJPROPS89", "DOCID", CMObjectClass.GENERICDOCUMENT);
        }
    }

    class CMOBJPROPS2_Loader
    extends CachedPropertyLoader {
        CMOBJPROPS2_Loader() {
            super("CMOBJPROPS2", "TASKID", CMObjectClass.SCHEDULE);
        }
    }

    class CMOBJPROPS6_Loader
    extends CachedPropertyLoader {
        CMOBJPROPS6_Loader() {
            super("CMOBJPROPS6", "DISPATCHERPATH", CMObjectClass.DISPATCHER);
        }
    }

    class CMOBJPROPS11_Loader
    extends CachedPropertyLoader {
        CMOBJPROPS11_Loader() {
            super("CMOBJPROPS11", "EVENTID", CMObjectClass.HISTORY);
        }
    }

    abstract class CachedPropertyLoader
    extends TableLoader {
        int clsID;

        CachedPropertyLoader(String table, String column, CMObjectClass cls) {
            super(String.format("select CMID, %2$s from %1$s where %2$s is not null", table, column));
            this.clsID = cls.getID();
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            if (entry.getType() == this.clsID) {
                String value = rs.getString(2);
                entry.setCachedPropertyValue(value);
            }
        }
    }

    class CMOBJPROPS54_Loader
    extends TableLoader {
        CMOBJPROPS54_Loader() {
            super("select CMID, FORMAT, OLOCALEID from CMOBJPROPS54");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CMStringLocale sLocale;
            CacheEntry entry = this.getCacheEntry(rs);
            if (CMObjectClass.OUTPUT.getID() == entry.getType()) {
                int format = rs.getInt(2);
                if (rs.wasNull()) {
                    format = 255;
                }
                entry.setOutputFormat(format);
            }
            int localeid = rs.getInt(3);
            if (!rs.wasNull() && localeid != 0 && (sLocale = CMDbStoreStringLocales.findLocale((short)localeid)) != null) {
                entry.setLocale(localeid |= ((CMDbStoreStringLocale)sLocale).getMappedID() << 16);
            }
        }
    }

    class CMOBJPROPS1_Loader
    extends TableLoader {
        CMOBJPROPS1_Loader() {
            super("select CMID, OBJID from CMOBJPROPS1 where OBJID is not null");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            String camid = rs.getString(2);
            entry.setCachedPropertyValue(camid);
            if (!CacheUtils.isTimeBasedCamId(camid)) {
                entry.setHasExID(true);
            }
        }
    }

    class CMREFNOORD1_Loader
    extends TableLoader {
        CMREFNOORD1_Loader() {
            super("select CMID from CMREFNOORD1 where PROPID=9");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            entry.setHasCredNamespace(true);
        }
    }

    class CMREFNOORD2_Loader
    extends TableLoader {
        CMREFNOORD2_Loader() {
            super("select CMID, REFCMID from CMREFNOORD2");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            int owner = rs.getInt(2);
            entry.setOwner(owner);
        }
    }

    class CMREFORD1_Loader
    extends TableLoader {
        CMREFORD1_Loader() {
            super("select CMID from CMREFORD1 where PROPID=26");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            entry.setHasRecipients(true);
        }
    }

    class CMOBJPROPS14_Loader
    extends TableLoader {
        CMOBJPROPS14_Loader() {
            super("select CMID from CMOBJPROPS14 where $lobNotNull{RECIPSEMAIL}", true);
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            entry.setHasRecipientsEmail(true);
        }
    }

    class CMOBJPROPS25_Loader
    extends TableLoader {
        CMOBJPROPS25_Loader() {
            super("select CMID, (case when $lobIsNull{MESSAGE} then 0 else 1 end), DEPLOYOBJUSAGE from CMOBJPROPS25", true);
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            int hasMessage = rs.getInt(2);
            int usage = rs.getInt(3);
            entry.setHasMessage(hasMessage != 0);
            entry.setDeploymentObjectUsage(usage);
        }
    }

    class CMPOLICIES_Loader
    extends TableLoader {
        CMPOLICIES_Loader() {
            super("select CMID from CMPOLICIES where $lobNotNull{POLICIES}", true);
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            entry.setHasSecurity(true);
        }
    }

    class CMOBJNAMES_Loader
    extends TableLoader {
        CMOBJNAMES_Loader() {
            super("select CMID, NAME, LOCALEID, ISDEFAULT, MAPDLOCALEID from CMOBJNAMES");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            CacheEntry entry = this.getCacheEntry(rs);
            String name = rs.getString(2);
            if (rs.wasNull() || name.length() == 0) {
                StringBuilder buf = new StringBuilder();
                buf.append("Missing object name (CMID=").append(entry.getObjectId()).append(")");
                name = buf.toString();
                CacheLoader.this.error(name);
                CacheLoader.this.hasErrors = true;
            }
            int localeid = rs.getInt(3);
            boolean isDefault = rs.getBoolean(4);
            if (isDefault) {
                localeid |= 1;
            }
            int mappedLocaleId = rs.getInt(5);
            if (!rs.wasNull()) {
                localeid |= mappedLocaleId << 16;
            }
            entry.addName(name, localeid);
        }
    }

    class CMSTOREIDS_Loader
    extends TableLoader {
        CMSTOREIDS_Loader() {
            super("select CMID, STOREID from CMSTOREIDS");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            int cmid = rs.getInt(1);
            String storeId = rs.getString(2);
            if (!CacheLoader.this.cache.setStoreId(cmid, storeId)) {
                throw new CacheException("Duplicate storeID: " + storeId);
            }
        }
    }

    class CMOBJECTS_Loader
    extends TableLoader {
        CMOBJECTS_Loader() {
            super("select CMID, PCMID, VERSION, CLASSID, DISABLED, TENANTID from CMOBJECTS order by CMID");
        }

        @Override
        void processResult(ResultSet rs) throws SQLException {
            int cmid = rs.getInt(1);
            int pcmid = rs.getInt(2);
            int version = rs.getInt(3);
            int classid = rs.getInt(4);
            Boolean disabled = null;
            boolean bvalue = rs.getBoolean(5);
            if (!rs.wasNull()) {
                disabled = bvalue;
            }
            int tenantid = rs.getInt(6);
            CacheEntry entry = CacheLoader.this.cache.createEntry(tenantid, cmid, classid);
            entry.freeNames();
            entry.setDisabled(disabled);
            entry.setVersionNumber(version);
            entry.setOwner(pcmid);
            entry.setOutputFormat(255);
        }
    }

    abstract class TableLoader {
        String statement;
        boolean isTemplate;

        TableLoader(String st) {
            this(st, false);
        }

        TableLoader(String st, boolean templ) {
            this.statement = st;
            this.isTemplate = templ;
        }

        CacheEntry getCacheEntry(ResultSet rs) throws SQLException {
            int cmid = rs.getInt(1);
            CacheEntry entry = CacheLoader.this.cache.getObjectWithId(cmid);
            if (entry == null) {
                String msg = String.format("Table %s contains invalid CMID: %d", this.getTableNameFromClass(), cmid);
                throw new CacheException(msg);
            }
            return entry;
        }

        private String getTableNameFromClass() {
            String tableName = this.getClass().getName();
            int start = tableName.lastIndexOf(46) + 1;
            int end = tableName.indexOf(95, start);
            return tableName.substring(start, end);
        }

        abstract void processResult(ResultSet var1) throws SQLException;
    }
}

