/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CacheLockCounts {
    private static final int SHARED_ALL_DESCENDANTS_LOCKS = 1;
    private static final int SHARED_EXCLUSIVE_DESCENDANT_LOCKS = 2;
    private static final int SHARED_LOCKS = 3;
    private Map<Integer, LockCounts> lockCounts_ = Collections.synchronizedMap(new HashMap());

    public int getSharedAllDescendantsLocksCount(int objectId) {
        LockCounts counts = this.getCounts(objectId);
        if (counts == null) {
            return 0;
        }
        return counts.getSharedAllDescendantsLocksCount();
    }

    public int getSharedExclusiveDescendantLocksCount(int objectId) {
        LockCounts counts = this.getCounts(objectId);
        if (counts == null) {
            return 0;
        }
        return counts.getSharedExclusiveDescendantLocksCount();
    }

    public int getSharedLocksCount(int objectId) {
        LockCounts counts = this.getCounts(objectId);
        if (counts == null) {
            return 0;
        }
        return counts.getSharedLocksCount();
    }

    public void setSharedAllDescendantsLocksCount(int objectId, int count) {
        this.setLockCount(1, objectId, count);
    }

    public void setSharedExclusiveDescendantLocksCount(int objectId, int count) {
        this.setLockCount(2, objectId, count);
    }

    public void setSharedLocksCount(int objectId, int count) {
        this.setLockCount(3, objectId, count);
    }

    private void setLockCount(int lockType, int objectId, int count) {
        LockCounts counts = this.getCounts(objectId);
        if (counts == null) {
            if (count == 0) {
                return;
            }
            counts = this.createNewCounts(objectId);
        }
        this.setLockCount(counts, lockType, count, objectId);
    }

    private void setLockCount(LockCounts counts, int lockType, int count, int objectId) {
        switch (lockType) {
            case 1: {
                counts.setSharedAllDescendantsLocksCount(count);
                break;
            }
            case 2: {
                counts.setSharedExclusiveDescendantLocksCount(count);
                break;
            }
            case 3: {
                counts.setSharedLocksCount(count);
            }
        }
        if (count == 0) {
            this.tryRemoveCountsObject(counts, objectId);
        }
    }

    private LockCounts createNewCounts(int objectId) {
        LockCounts count = new LockCounts();
        this.lockCounts_.put(new Integer(objectId), count);
        return count;
    }

    private void tryRemoveCountsObject(LockCounts counts, int id) {
        if (counts.allCountsZero()) {
            this.lockCounts_.remove(new Integer(id));
        }
    }

    private LockCounts getCounts(int objectId) {
        return this.lockCounts_.get(new Integer(objectId));
    }

    void reset() {
        this.lockCounts_ = Collections.synchronizedMap(new HashMap());
    }

    boolean hasCountEntry(int i) {
        return this.getCounts(i) != null;
    }

    private static class LockCounts {
        private int sharedAllDescendantsLocksCount = 0;
        private int sharedExclusiveDescendantLocksCount = 0;
        private int sharedLocksCount = 0;

        private LockCounts() {
        }

        public int getSharedAllDescendantsLocksCount() {
            return this.sharedAllDescendantsLocksCount;
        }

        public void setSharedLocksCount(int count) {
            this.sharedLocksCount = count;
        }

        public void setSharedExclusiveDescendantLocksCount(int count) {
            this.sharedExclusiveDescendantLocksCount = count;
        }

        public boolean allCountsZero() {
            return this.sharedAllDescendantsLocksCount == 0 && this.sharedExclusiveDescendantLocksCount == 0 && this.sharedLocksCount == 0;
        }

        public void setSharedAllDescendantsLocksCount(int count) {
            this.sharedAllDescendantsLocksCount = count;
        }

        public int getSharedLocksCount() {
            return this.sharedLocksCount;
        }

        public int getSharedExclusiveDescendantLocksCount() {
            return this.sharedExclusiveDescendantLocksCount;
        }
    }
}

