/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CCacheLog;
import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.ICacheLockHandler;
import com.cognos.cm.cache.LockHandleCache;
import com.cognos.cm.cache.LockHandlerHandle;
import com.cognos.cm.cache.MutableReference;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.query.CacheEntryIterator;
import com.cognos.cm.cache.query.QueryObjectID_List;
import com.cognos.cm.locking.AbstractLockHandler;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.LockHandlerJavaImpl;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;

public class CacheLockHandlerJavaImpl
implements ICacheLockHandler {
    static final int LH_INVALID_LOCKHANDLE = -1;
    static final int LH_DELETED_OBJECTID = -1;
    static final int LH_REMOVE_ALL_LOCKS = -1;
    protected static boolean bLog_;
    private static ICacheLockHandler gblLockHandler;
    private AbstractLockHandler lockHandler_ = new LockHandlerJavaImpl();
    protected LockHandleCache handleCache_;
    final String codeErrLockHandlerInvalidState = "cmErrLockHandlerInvalidState";
    final String codeLockHandlerState = "cmLockHandlerState";
    final String codeLockManagerObjectIsLocked = "cmLMObjectIsLocked";
    final String codeLMUnexpectedUnlockX = "cmLMUnexpectedUnlockX";
    final String codeLMUnexpectedUnlockShared = "cmLMUnexpectedUnlockShared";
    final String codeLMUnexpectedUnlockDescendant = "cmLMUnexpectedUnlockDescendant";
    final String codeLMUnexpectedUnlockXAncestor = "cmLMUnexpectedUnlockXAncestor";
    final String codeLockHandlerRemoveHeldLocksBeforeDelete = "cmLockHandlerRemoveHeldLocksBeforeDelete";

    private static void LogLockMsg(String msgCode, int id) {
        if (CCacheLog.getGlobalCCacheLog().isLoggingEnabled() && bLog_) {
            String pPath = CMCacheJavaImpl.gblCache.getSearchPath(id, null);
            CCacheLog.getGlobalCCacheLog().logJavaMsgString(msgCode, "Path", pPath, true);
        }
    }

    public static void LogLockErrorMsg(String msgCode, int id, int type) {
        if (CCacheLog.getGlobalCCacheLog().isLoggingEnabled() && bLog_) {
            String mode = CacheLockHandlerJavaImpl.getTypeStr(type);
            String pPath = CMCacheJavaImpl.gblCache.getSearchPath(id, null);
            CCacheLog.getGlobalCCacheLog().logJavaMsg2Strings(msgCode, "Path", pPath, "Mode", mode, true);
        }
    }

    public static void LogLock(int id, int type) {
        String msg = null;
        switch (type) {
            case 0: {
                msg = "cmLockHandlerLockShared";
                break;
            }
            case 1: {
                msg = "cmLockHandlerLockSharedDescendant";
                break;
            }
            case 3: {
                msg = "cmLockHandlerLockExclusive";
                break;
            }
            case 2: {
                msg = "cmLockHandlerLockSharedExclusiveDescendant";
                break;
            }
            case 6: {
                msg = "cmLockHandlerLockChildMutex";
            }
        }
        CacheLockHandlerJavaImpl.LogLockMsg(msg, id);
    }

    public static void LogUnlock(int id, int lockType) {
        String msg = null;
        switch (lockType) {
            case 0: {
                msg = "cmLockHandlerUnlockShared";
                break;
            }
            case 1: {
                msg = "cmLockHandlerUnlockSharedDescendant";
                break;
            }
            case 3: {
                msg = "cmLockHandlerUnlockExclusive";
                break;
            }
            case 2: {
                msg = "cmLockHandlerUnlockSharedExclusiveDescendant";
                break;
            }
            case 6: {
                msg = "cmLockHandlerUnlockChildMutex";
            }
        }
        CacheLockHandlerJavaImpl.LogLockMsg(msg, id);
    }

    private void LockObjEntry(int objid, CacheEntry objEntry, int lockType, LockHandlerHandle lockHandle) throws CMLockHandlerDenied {
        lockHandle.Add(objid, objEntry, lockType);
        CacheLockHandlerJavaImpl.LogLock(objid, lockType);
    }

    private int UnlockObjEntry(int objid, CacheEntry objEntry, int lockType, LockHandlerHandle lockHandle) throws CMLockHandlerDenied {
        return this.UnlockObjEntry(objid, objEntry, lockType, lockHandle, 1);
    }

    private int UnlockObjEntry(int objid, CacheEntry objEntry, int lockType, LockHandlerHandle lockHandle, int lockCount) throws CMLockHandlerDenied {
        lockCount = lockHandle.Remove(objid, lockType, lockCount);
        return lockCount;
    }

    @Override
    public void acquireLocks(int lockHandle, QueryObjectID_List queryObjects, int lockTypeArg, int iParentLocksAcquired) throws CMLockHandlerDenied {
        this.acquireLocks(lockHandle, CacheEntryIterator.create(queryObjects), lockTypeArg);
    }

    @Override
    public void acquireLocks(int lockHandle, int[] objects, int iNumObjects, int lockTypeArg, int iParentLocksAcquired) throws CMLockHandlerDenied {
        this.acquireLocks(lockHandle, CacheEntryIterator.create(objects, iNumObjects), lockTypeArg);
    }

    @Override
    public void acquireLocks(int lockHandle, Iterable<CacheEntry> entries, int lockTypeArg) throws CMLockHandlerDenied {
        if (lockTypeArg == 5) {
            return;
        }
        LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(lockHandle);
        try {
            for (CacheEntry entry : entries) {
                this.acquireLock(handle, entry.getObjectId(), new MutableReference(entry), lockTypeArg);
            }
        }
        catch (CMLockHandlerDenied | RuntimeException e) {
            handle.releaseAllLocks();
            throw e;
        }
    }

    private void acquireLock(LockHandlerHandle lockHandle, int objid, MutableReference entry, int lockTypeArg) throws CMLockHandlerDenied {
        CacheEntry cacheEntry = (CacheEntry)entry.getReference();
        int primaryLockType = lockTypeArg;
        if (lockTypeArg == 4) {
            if (objid != 0) {
                cacheEntry = cacheEntry.getParent();
                objid = cacheEntry.getObjectId();
            }
            primaryLockType = 3;
        } else if (lockTypeArg == 7) {
            if (objid != 0) {
                this.acquireLock(lockHandle, cacheEntry.getParent().getObjectId(), new MutableReference(cacheEntry.getParent()), 6);
            }
            primaryLockType = 3;
        }
        entry.setValue(cacheEntry);
        int primary_objid = objid;
        CacheEntry primary_cacheEntry = cacheEntry;
        this.LockObjEntry(primary_objid, primary_cacheEntry, primaryLockType, lockHandle);
        int ancestorLockType = CacheLockHandlerJavaImpl.getAncestorLockType(primaryLockType);
        try {
            while (objid != 0) {
                cacheEntry = cacheEntry.getParent();
                objid = cacheEntry.getObjectId();
                this.LockObjEntry(objid, cacheEntry, ancestorLockType, lockHandle);
            }
        }
        catch (CMLockHandlerDenied e) {
            this.dump(lockHandle.handlerID_, "acquireLocks:undo-locks-begin");
            this.UnlockObjEntry(primary_objid, primary_cacheEntry, primaryLockType, lockHandle);
            int failed_objid = objid;
            objid = primary_cacheEntry.getParent().getObjectId();
            cacheEntry = primary_cacheEntry.getParent();
            while (objid != failed_objid) {
                this.UnlockObjEntry(objid, cacheEntry, ancestorLockType, lockHandle);
                objid = cacheEntry.getParent().getObjectId();
                cacheEntry = cacheEntry.getParent();
            }
            this.dump(lockHandle.handlerID_, "acquireLocks:undo-locks-end");
            throw e;
        }
        entry.setValue(cacheEntry);
    }

    private static int getAncestorLockType(int lockType) {
        int ancestorLockType = 0;
        if (lockType == 3) {
            ancestorLockType = 2;
        }
        return ancestorLockType;
    }

    @Override
    public void initialize(AbstractLockHandler lockhandler, boolean bLog) {
        this.handleCache_ = new LockHandleCache(AdvancedSettings.MAX_LOCK_HANDLES);
        bLog_ = bLog;
        if (bLog_) {
            CCacheLog.getGlobalCCacheLog().initJavaLogging();
            CCacheLog.getGlobalCCacheLog().setLogging(true);
        }
        this.lockHandler_ = lockhandler;
    }

    @Override
    public int getCurrentHandle() throws CMException {
        return this.lockHandler_.getCurrentHandle();
    }

    @Override
    public boolean hasExclLocks(int iHandle) {
        LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(iHandle);
        return handle.hasExclusiveLocks_;
    }

    @Override
    public int allocateHandle() {
        int iHandle = this.handleCache_.allocateHandle();
        this.dump(iHandle, "allocateHandle");
        return iHandle;
    }

    @Override
    public void releaseAllLocks(int iHandle) {
        this._releaseAllLocks(iHandle);
        this.dump(iHandle, "releaseAllLocks");
    }

    private void _releaseAllLocks(int iHandle) {
        LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(iHandle);
        handle.releaseAllLocks();
    }

    @Override
    public void releaseHandle(int iHandle) {
        this._releaseAllLocks(iHandle);
        this.dump(iHandle, "releaseHandle");
        this.handleCache_.releaseHandle(iHandle);
    }

    @Override
    public void finishedProtectedMutex(int iHandle) {
        LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(iHandle);
        handle.atomicLockComplete_ = true;
        this.dump(iHandle, "finishedProtectedMutex");
    }

    @Override
    public void removeHeldLocksBeforeDelete(int objId) throws CMException {
        CacheEntry cacheEntry = CMCacheJavaImpl.gblCache.getObjectWithId(objId);
        int lockHandle = this.getCurrentHandle();
        if (lockHandle < 0) {
            return;
        }
        LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(lockHandle);
        int idx = handle.contains(objId);
        if (idx < 0) {
            return;
        }
        this.dump(lockHandle, "removeHeldLocksBeforeDelete(1)");
        int sharedCount = 0;
        sharedCount += this.UnlockObjEntry(objId, cacheEntry, 0, handle, -1);
        sharedCount += this.UnlockObjEntry(objId, cacheEntry, 1, handle, -1);
        sharedCount += this.UnlockObjEntry(objId, cacheEntry, 6, handle, -1);
        int exclusiveCount = this.UnlockObjEntry(objId, cacheEntry, 3, handle, -1);
        while (objId != 0) {
            cacheEntry = cacheEntry.getParent();
            objId = cacheEntry.getObjectId();
            this.UnlockObjEntry(objId, cacheEntry, 0, handle, sharedCount);
            this.UnlockObjEntry(objId, cacheEntry, 2, handle, exclusiveCount);
        }
        this.dump(lockHandle, "removeHeldLocksBeforeDelete(2)");
        handle.markAsDeleted(idx);
    }

    public static final String getTypeStr(int lockType) {
        String mode = null;
        switch (lockType) {
            case 0: {
                mode = "shared";
                break;
            }
            case 1: {
                mode = "shared descendant";
                break;
            }
            case 3: {
                mode = "exclusive";
                break;
            }
            case 4: {
                mode = "parent exclusive";
                break;
            }
            case 5: {
                mode = "locks already acquired";
                break;
            }
            case 2: {
                mode = "shared for descendant exclusive";
                break;
            }
            case 6: {
                mode = "child mutex";
                break;
            }
            case 7: {
                mode = "parent child mutex";
            }
        }
        return mode;
    }

    @Override
    public void dump(int lockhandle, String where) {
        this.dump(lockhandle, where, false);
    }

    @Override
    public void dump(int lockHandle, String where, boolean bCritical) {
        if (System.getProperty("com.cognos.cm.debug", "false").equalsIgnoreCase("true")) {
            if (!CCacheLog.getGlobalCCacheLog().isLoggingEnabled() || !bLog_ && !bCritical) {
                return;
            }
            StringBuffer buf = new StringBuffer();
            if (lockHandle != -1) {
                buf.append(" handle=").append(lockHandle).append(",");
            }
            buf.append(" operation=").append(where);
            buf.append("\r\n");
            int max_dump_handles = 10;
            for (int i = 0; i < max_dump_handles; ++i) {
                LockHandlerHandle handle = this.handleCache_.lockHandleIDToPtr(i);
                if (i == lockHandle) {
                    buf.append("*LockHandle[").append(i).append("]: ");
                } else {
                    buf.append(" LockHandle[").append(i).append("]: ");
                }
                handle.dump(buf);
                buf.append("\r\n");
            }
            String msgStr = buf.toString();
            String logMsgCode = "cmLockHandlerState";
            if (bCritical) {
                logMsgCode = "cmErrLockHandlerInvalidState";
            }
            CCacheLog.getGlobalCCacheLog().logJavaMsgString(logMsgCode, "State", msgStr, true);
        }
    }

    public static void setGlobalLockHandler(ICacheLockHandler gblLockHandler) {
        CacheLockHandlerJavaImpl.gblLockHandler = gblLockHandler;
    }

    public static ICacheLockHandler getGlobalLockHandler() {
        return gblLockHandler;
    }

    static {
        gblLockHandler = new CacheLockHandlerJavaImpl();
    }
}

