/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.ISymbolTable;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class InternedStrings
implements ISymbolTable {
    protected WeakHashMap<String, WeakReference<String>> map;

    public InternedStrings() {
        this(65535, 1.0f);
    }

    public InternedStrings(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized String lookup(String string) {
        WeakReference<String> tableRef = this.map.get(string);
        String tableString = null;
        if (tableRef != null) {
            tableString = (String)tableRef.get();
        }
        return tableString;
    }

    @Override
    public synchronized String allocate(String key) {
        String symbol = null;
        WeakReference<String> tableRef = this.map.get(key);
        if (tableRef != null) {
            symbol = (String)tableRef.get();
        }
        if (symbol == null) {
            this.map.put(key, new WeakReference<String>(key));
            symbol = key;
        }
        return symbol;
    }
}

