/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.LastEntryMap;
import com.cognos.cm.cache.SimpleLastEntryMap;
import com.cognos.cm.cache.TenantedLastEntryMap;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.server.CMExecutionContext;

public class LastEntryCache {
    private final SimpleLastEntryMap simpleCache = new SimpleLastEntryMap();
    private final TenantedLastEntryMap tenantedCache = new TenantedLastEntryMap();

    public synchronized void setLastEntry(CacheEntry parentEntry, CacheEntry lastEntry) {
        int tenantId = this.getCurrentUserTenantId();
        this.getMap(parentEntry).put(parentEntry, lastEntry, tenantId);
    }

    public synchronized CacheEntry getLastEntry(CacheEntry parentEntry, int classId) {
        int tenantId = this.getCurrentUserTenantId();
        return this.getMap(parentEntry).get(parentEntry, classId, tenantId);
    }

    public synchronized void clearLastEntryOfClass(CacheEntry parentEntry, int classId, int tenantId) {
        this.getMap(parentEntry).remove(parentEntry, classId, tenantId);
    }

    public synchronized void clearAllLastEntries(CacheEntry parentEntry) {
        this.getMap(parentEntry).remove(parentEntry);
    }

    public boolean canBeCached(CacheEntry parentEntry) {
        if (parentEntry.getHasChildWithPolicy()) {
            return false;
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.isMultitenancyEnabled()) {
            if (parentEntry.getTenantId() != 0) {
                return true;
            }
            if (ctx.hasUnfilteredAdminAccess()) {
                return false;
            }
            if (this.userCanSeeObjectsBelongingToMultipleTenants(ctx)) {
                return false;
            }
        }
        return true;
    }

    private boolean userCanSeeObjectsBelongingToMultipleTenants(CMExecutionContext ctx) {
        int[] readTenantIds = ctx.getReadTenantIds();
        if (readTenantIds != null) {
            int count = 0;
            for (int tenant : readTenantIds) {
                if (tenant == 0 || ++count != 2) continue;
                return true;
            }
        }
        return false;
    }

    private LastEntryMap getMap(CacheEntry entry) {
        return this.maybeSharedMultitenant(entry) ? this.tenantedCache : this.simpleCache;
    }

    boolean maybeSharedMultitenant(CacheEntry entry) {
        return CMExecutionContext.get().isMultitenancyEnabled() && entry.getTenantId() == 0;
    }

    private Integer getCurrentUserTenantId() {
        return CMExecutionContext.get().getCurrentUserTenantId();
    }
}

