/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CacheFreeList;
import com.cognos.cm.cache.LockHandlerHandle;
import java.util.Map;
import java.util.TreeMap;

class LockHandleCache {
    private static final int CMCACHE_MAX_OBJECTS = 10000000;
    private int max_objects_;
    private Map<Integer, LockHandlerHandle> cacheEntries_ = new TreeMap<Integer, LockHandlerHandle>();
    private CacheFreeList freelist_;

    public LockHandleCache(long max_num_objs) {
        this.max_objects_ = max_num_objs > 0L ? (int)max_num_objs : 10000000;
        if (max_num_objs > 0L) {
            this.max_objects_ = (int)(max_num_objs + 255L) & 0xFFFFFF00;
        }
        this.freelist_ = new CacheFreeList(this.max_objects_);
    }

    public LockHandlerHandle lockHandleIDToPtr(int id) {
        if (id > this.max_objects_) {
            throw new IllegalStateException();
        }
        Integer key = new Integer(id);
        LockHandlerHandle entry = this.cacheEntries_.get(key);
        if (entry == null) {
            entry = new LockHandlerHandle(id);
            this.cacheEntries_.put(key, entry);
        }
        return entry;
    }

    public int allocateHandle() {
        int lh = this.freelist_.allocateBlock();
        this.lockHandleIDToPtr(lh);
        return lh;
    }

    public void releaseHandle(int id) {
        this.cacheEntries_.remove(id);
        this.freelist_.freeBlock(id);
    }
}

