/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.LockHandlerObjectID_ListEntry;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.cache.entry.InvalidCacheEntry;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockHandlerDenied;
import java.util.ArrayList;
import java.util.List;

class LockHandlerHandle {
    public boolean hasExclusiveLocks_;
    public boolean atomicLockComplete_;
    public List<LockHandlerObjectID_ListEntry> objList_;
    public int handlerID_;

    public LockHandlerHandle(int id) {
        this.initializeX(id);
    }

    private void initializeX(int id) {
        this.hasExclusiveLocks_ = false;
        this.atomicLockComplete_ = false;
        this.objList_ = new ArrayList<LockHandlerObjectID_ListEntry>(100);
        this.handlerID_ = id;
    }

    public int Add(int id, CacheEntry cacheEntry, int type) throws CMLockHandlerDenied {
        LockHandlerObjectID_ListEntry entry;
        if (cacheEntry == null || cacheEntry instanceof InvalidCacheEntry) {
            if (CMIndicationGlobals.bLockManagerLogEnabled) {
                CMIndications.logException("Trace.CM.TLM", 30000, new CacheException("LockHandlerHandle:Add: Invalid cache entry: " + id));
            }
            return this.objList_.size();
        }
        int id_idx = this.contains(id);
        if (id_idx == -1) {
            id_idx = this.objList_.size();
            entry = new LockHandlerObjectID_ListEntry();
            entry.init(id, cacheEntry);
            entry.resetCounters();
            this.objList_.add(entry);
        } else {
            entry = this.objList_.get(id_idx);
        }
        this.hasExclusiveLocks_ = entry.acquireLockType(type, this.atomicLockComplete_);
        return this.objList_.size();
    }

    public int Remove(int id, int lockType, int lockCount) throws CMLockHandlerDenied {
        int numLocks = 0;
        int id_idx = this.contains(id);
        if (id_idx == -1) {
            return 0;
        }
        LockHandlerObjectID_ListEntry entry = this.objList_.get(id_idx);
        numLocks = entry.releaseLockType(lockType, lockCount);
        return numLocks;
    }

    public int size() {
        return this.objList_.size();
    }

    public void releaseAllLocks() {
        Exception e = null;
        for (int i = 0; i < this.objList_.size(); ++i) {
            LockHandlerObjectID_ListEntry entry = this.objList_.get(i);
            try {
                entry.releaseAllLocks();
                continue;
            }
            catch (Exception ignore) {
                e = ignore;
            }
        }
        this.objList_.clear();
        if (e != null) {
            CMIndications.logException(e);
        }
    }

    public LockHandlerObjectID_ListEntry element_at(int i) {
        return this.objList_.get(i);
    }

    public int id_at(int i) {
        return this.objList_.get((int)i).id;
    }

    public void markAsDeleted(int i) {
        LockHandlerObjectID_ListEntry item = this.objList_.get(i);
        item.resetCounters();
        item.id = -1;
        item.cacheEntry_ = null;
    }

    public int contains(int id) {
        for (int i = 0; i < this.objList_.size(); ++i) {
            if (id != this.objList_.get((int)i).id) continue;
            return i;
        }
        return -1;
    }

    public void dump(StringBuffer buf) {
        buf.append("flags=[");
        if (this.hasExclusiveLocks_) {
            buf.append("X");
        } else {
            buf.append("-");
        }
        if (this.atomicLockComplete_) {
            buf.append("A");
        } else {
            buf.append("-");
        }
        buf.append("] ");
        buf.append("numObjects=").append(this.objList_.size());
        if (this.objList_.size() > 0) {
            buf.append(": ").append("\r\n");
        } else {
            buf.append(".");
        }
        for (int i = 0; i < this.objList_.size(); ++i) {
            LockHandlerObjectID_ListEntry entry = this.objList_.get(i);
            buf.append("    Lock[").append(i).append("]: ");
            entry.dump(buf);
            if (i + 1 >= this.objList_.size()) continue;
            buf.append("\r\n");
        }
    }

    public void empty() {
        this.hasExclusiveLocks_ = false;
        this.atomicLockComplete_ = false;
        this.objList_.clear();
    }
}

