/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.cache.CacheException;
import com.cognos.cm.cache.CacheLockHandlerJavaImpl;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.locking.CMLockHandlerDenied;

class LockHandlerObjectID_ListEntry {
    static final String codeErrLockHandlerInvalidState = "cmErrLockHandlerInvalidState";
    static final String codeLockHandlerState = "cmLockHandlerState";
    static final String codeLockManagerObjectIsLocked = "cmLMObjectIsLocked";
    static final String codeLMUnexpectedUnlockX = "cmLMUnexpectedUnlockX";
    static final String codeLMUnexpectedUnlockShared = "cmLMUnexpectedUnlockShared";
    static final String codeLMUnexpectedUnlockDescendant = "cmLMUnexpectedUnlockDescendant";
    static final String codeLMUnexpectedUnlockXAncestor = "cmLMUnexpectedUnlockXAncestor";
    static final String codeLockHandlerRemoveHeldLocksBeforeDelete = "cmLockHandlerRemoveHeldLocksBeforeDelete";
    public int id;
    public CacheEntry cacheEntry_;
    private int sharedLocksCount;
    private int sharedAllDescendantsLocksCount;
    private int sharedExclusiveDescendantLocksCount;
    private int exclusiveLocksCount;
    private int childMutexLocksCount;

    LockHandlerObjectID_ListEntry() {
    }

    public void init(int id, CacheEntry entry) {
        this.id = id;
        this.cacheEntry_ = entry;
    }

    public void resetCounters() {
        this.sharedLocksCount = 0;
        this.sharedAllDescendantsLocksCount = 0;
        this.sharedExclusiveDescendantLocksCount = 0;
        this.exclusiveLocksCount = 0;
        this.childMutexLocksCount = 0;
    }

    public boolean isDeleted() {
        return this.id == -1;
    }

    protected boolean ancestorsAreLockedByOthers(int mask) {
        CacheEntry entry = this.cacheEntry_;
        while (!entry.isRoot()) {
            if (!this.cacheEntryIsLockedByOthers(entry = entry.getParent(), mask)) continue;
            return true;
        }
        return false;
    }

    protected boolean cacheEntryIsLockedByOthers(int mask) {
        return this.cacheEntryIsLockedByOthers(this.cacheEntry_, mask);
    }

    protected boolean cacheEntryIsLockedByOthers(CacheEntry entry, int mask) {
        if (0 != (mask & 8) && entry.getHasExclusiveLock() && 0 == this.exclusiveLocksCount) {
            return true;
        }
        if (0 != (mask & 1) && entry.getSharedLocksCount() > this.sharedLocksCount) {
            return true;
        }
        if (0 != (mask & 2) && entry.getSharedExclusiveDescendantLocksCount() > this.sharedExclusiveDescendantLocksCount) {
            return true;
        }
        if (0 != (mask & 4) && entry.getSharedAllDescendantsLocksCount() > this.sharedAllDescendantsLocksCount) {
            return true;
        }
        return 0 != (mask & 0x10) && entry.getHasChildMutex() && 0 == this.childMutexLocksCount;
    }

    public void releaseAllLocks() {
        if (this.isDeleted()) {
            return;
        }
        if (0 < this.exclusiveLocksCount) {
            this.cacheEntry_.setHasExclusiveLock(false);
        }
        if (0 < this.childMutexLocksCount) {
            this.cacheEntry_.setHasChildMutex(false);
        }
        this.cacheEntry_.setSharedAllDescendantsLocksCount(this.cacheEntry_.getSharedAllDescendantsLocksCount() - this.sharedAllDescendantsLocksCount);
        this.cacheEntry_.setSharedExclusiveDescendantLocksCount(this.cacheEntry_.getSharedExclusiveDescendantLocksCount() - this.sharedExclusiveDescendantLocksCount);
        this.cacheEntry_.setSharedLocksCount(this.cacheEntry_.getSharedLocksCount() - this.sharedLocksCount);
        this.resetCounters();
    }

    protected String sp(int id) {
        return CMCacheJavaImpl.gblCache.getSearchPath(id, null);
    }

    public boolean acquireLockType(int lockType, boolean detectDeadLock) throws CMLockHandlerDenied {
        switch (lockType) {
            case 0: {
                if (this.cacheEntryIsLockedByOthers(8)) {
                    throw new CMLockHandlerDenied(false, this.sp(this.id), codeLockManagerObjectIsLocked);
                }
                this.cacheEntry_.setSharedLocksCount(this.cacheEntry_.getSharedLocksCount() + 1);
                ++this.sharedLocksCount;
                break;
            }
            case 1: {
                if (this.cacheEntryIsLockedByOthers(26)) {
                    throw new CMLockHandlerDenied(false, this.sp(this.id), codeLockManagerObjectIsLocked);
                }
                this.cacheEntry_.setSharedAllDescendantsLocksCount(this.cacheEntry_.getSharedAllDescendantsLocksCount() + 1);
                ++this.sharedAllDescendantsLocksCount;
                break;
            }
            case 2: {
                if (this.cacheEntryIsLockedByOthers(12)) {
                    throw new CMLockHandlerDenied(false, this.sp(this.id), codeLockManagerObjectIsLocked);
                }
                this.cacheEntry_.setSharedExclusiveDescendantLocksCount(this.cacheEntry_.getSharedExclusiveDescendantLocksCount() + 1);
                ++this.sharedExclusiveDescendantLocksCount;
                break;
            }
            case 6: {
                if (this.cacheEntryIsLockedByOthers(28) || this.ancestorsAreLockedByOthers(4)) {
                    throw new CMLockHandlerDenied(false, this.sp(this.id), codeLockManagerObjectIsLocked);
                }
                this.cacheEntry_.setHasChildMutex(true);
                ++this.childMutexLocksCount;
                break;
            }
            case 3: {
                if (this.cacheEntryIsLockedByOthers(-1) || this.ancestorsAreLockedByOthers(4)) {
                    throw new CMLockHandlerDenied(false, this.sp(this.id), codeLockManagerObjectIsLocked);
                }
                this.cacheEntry_.setHasExclusiveLock(true);
                ++this.exclusiveLocksCount;
                break;
            }
            case 4: {
                throw new CacheException("LockHandler::LockObjEntry", "Invalid lock type EXCLUSIVEPARENT");
            }
            case 5: {
                throw new CacheException("LockHandler::LockObjEntry", "Invalid lock type HAVEBEENACQUIRED");
            }
            default: {
                throw new CacheException("LockHandler::LockObjEntry", "Invalid lock type");
            }
        }
        return this.exclusiveLocksCount > 0;
    }

    public int releaseLockType(int lockType, int numLocks) throws CMLockHandlerDenied {
        boolean isDelete = numLocks < 0;
        switch (lockType) {
            case 3: {
                if (isDelete) {
                    numLocks = this.exclusiveLocksCount;
                    this.exclusiveLocksCount = 0;
                } else {
                    --this.exclusiveLocksCount;
                    if (0 > this.exclusiveLocksCount) {
                        CacheLockHandlerJavaImpl.LogLockErrorMsg(codeLMUnexpectedUnlockX, this.id, lockType);
                        this.cacheEntry_.setHasExclusiveLock(false);
                        throw new CMLockHandlerDenied(true, this.sp(this.id), codeLMUnexpectedUnlockX);
                    }
                }
                if (0 != this.exclusiveLocksCount) break;
                this.cacheEntry_.setHasExclusiveLock(false);
                break;
            }
            case 1: {
                if (isDelete) {
                    numLocks = this.sharedAllDescendantsLocksCount;
                    this.sharedAllDescendantsLocksCount = 0;
                } else {
                    this.sharedAllDescendantsLocksCount -= numLocks;
                    if (0 > this.sharedAllDescendantsLocksCount) {
                        throw new CacheException("LockHandler::UnlockObjEntry", "sharedAllDescendantsLocksCount < 0");
                    }
                }
                if (this.cacheEntry_.getSharedAllDescendantsLocksCount() < numLocks) {
                    CacheLockHandlerJavaImpl.LogLockErrorMsg(codeLMUnexpectedUnlockDescendant, this.id, lockType);
                    throw new CMLockHandlerDenied(true, this.sp(this.id), codeLMUnexpectedUnlockDescendant);
                }
                this.cacheEntry_.setSharedAllDescendantsLocksCount(this.cacheEntry_.getSharedAllDescendantsLocksCount() - numLocks);
                break;
            }
            case 2: {
                if (isDelete) {
                    numLocks = this.sharedExclusiveDescendantLocksCount;
                    this.sharedExclusiveDescendantLocksCount = 0;
                } else {
                    this.sharedExclusiveDescendantLocksCount -= numLocks;
                    if (0 > this.sharedExclusiveDescendantLocksCount) {
                        throw new CacheException("LockHandler::UnlockObjEntry", "sharedExclusiveDescendantLocksCount < 0");
                    }
                }
                if (this.cacheEntry_.getSharedExclusiveDescendantLocksCount() < numLocks) {
                    CacheLockHandlerJavaImpl.LogLockErrorMsg(codeLMUnexpectedUnlockXAncestor, this.id, lockType);
                    throw new CMLockHandlerDenied(true, this.sp(this.id), codeLMUnexpectedUnlockXAncestor);
                }
                this.cacheEntry_.setSharedExclusiveDescendantLocksCount(this.cacheEntry_.getSharedExclusiveDescendantLocksCount() - numLocks);
                break;
            }
            case 6: {
                if (isDelete) {
                    numLocks = this.childMutexLocksCount;
                    this.childMutexLocksCount = 0;
                } else {
                    this.childMutexLocksCount -= numLocks;
                    if (0 > this.childMutexLocksCount) {
                        throw new CacheException("LockHandler::UnlockObjEntry", "childMutexLocksCount < 0");
                    }
                }
                if (0 != this.childMutexLocksCount) break;
                this.cacheEntry_.setHasChildMutex(false);
                break;
            }
            case 0: {
                if (isDelete) {
                    numLocks = this.sharedLocksCount;
                    this.sharedLocksCount = 0;
                } else {
                    this.sharedLocksCount -= numLocks;
                    if (0 > this.sharedLocksCount) {
                        throw new CacheException("LockHandler::UnlockObjEntry", "sharedLocksCount < 0");
                    }
                }
                if (this.cacheEntry_.getSharedLocksCount() < numLocks) {
                    CacheLockHandlerJavaImpl.LogLockErrorMsg(codeLMUnexpectedUnlockShared, this.id, lockType);
                    throw new CMLockHandlerDenied(true, this.sp(this.id), codeLMUnexpectedUnlockShared);
                }
                this.cacheEntry_.setSharedLocksCount(this.cacheEntry_.getSharedLocksCount() - numLocks);
                break;
            }
            default: {
                throw new CacheException("LockHandler::UnlockObjEntry", "Invalid lock type specified");
            }
        }
        return numLocks;
    }

    private void dumpExclusiveLock(StringBuffer out, CacheEntry cacheEntry) {
        out.append("X(");
        out.append(this.exclusiveLocksCount);
        out.append("/");
        out.append(cacheEntry.getHasExclusiveLock());
        out.append(")");
    }

    private void dumpExclusiveDescendant(StringBuffer out, CacheEntry cacheEntry) {
        out.append("SXD(");
        out.append(this.sharedExclusiveDescendantLocksCount);
        out.append("/");
        out.append(cacheEntry.getSharedExclusiveDescendantLocksCount());
        out.append(")");
    }

    private void dumpShared(StringBuffer out, CacheEntry cacheEntry) {
        out.append("S(");
        out.append(this.sharedLocksCount);
        out.append("/");
        out.append(cacheEntry.getSharedLocksCount());
        out.append(")");
    }

    private void dumpDescendant(StringBuffer out, CacheEntry cacheEntry) {
        out.append("SD(");
        out.append(this.sharedAllDescendantsLocksCount);
        out.append("/");
        out.append(cacheEntry.getSharedAllDescendantsLocksCount());
        out.append(")");
    }

    private void dumpChildMutex(StringBuffer out, CacheEntry cacheEntry) {
        out.append("CMUX(");
        out.append(this.childMutexLocksCount);
        out.append("/");
        out.append(cacheEntry.getHasChildMutex());
        out.append(")");
    }

    public void dump(StringBuffer out) {
        if (this.id == -1) {
            out.append("*deleted*");
            return;
        }
        out.append("id=");
        out.append(this.id);
        CacheEntry cacheEntry = null;
        String path = null;
        try {
            cacheEntry = CMCacheJavaImpl.gblCache.getObjectWithId(this.id);
            path = CMCacheJavaImpl.gblCache.getSearchPath(this.id, null);
        }
        catch (Throwable th) {
            out.append("*deleted*");
            return;
        }
        out.append(" type=[");
        if (0 != this.exclusiveLocksCount || cacheEntry.getHasExclusiveLock()) {
            this.dumpExclusiveLock(out, cacheEntry);
        }
        if (0 != this.sharedExclusiveDescendantLocksCount || 0 != cacheEntry.getSharedExclusiveDescendantLocksCount()) {
            this.dumpExclusiveDescendant(out, cacheEntry);
        }
        if (0 != this.sharedLocksCount || 0 != cacheEntry.getSharedLocksCount()) {
            this.dumpShared(out, cacheEntry);
        }
        if (0 != this.sharedAllDescendantsLocksCount || 0 != cacheEntry.getSharedAllDescendantsLocksCount()) {
            this.dumpDescendant(out, cacheEntry);
        }
        if (0 != this.childMutexLocksCount || cacheEntry.getHasChildMutex()) {
            this.dumpChildMutex(out, cacheEntry);
        }
        out.append("] ");
        out.append(path);
    }

    protected int getSharedLocksCount() {
        return this.sharedLocksCount;
    }

    protected int getChildMutexLocksCount() {
        return this.childMutexLocksCount;
    }

    protected int getSharedAllDescendantsLocksCount() {
        return this.sharedAllDescendantsLocksCount;
    }

    protected int getSharedExclusiveDescendantLocksCount() {
        return this.sharedExclusiveDescendantLocksCount;
    }

    protected int getExclusiveLocksCount() {
        return this.exclusiveLocksCount;
    }
}

