/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.ISymbolTable;
import com.cognos.cm.cache.InternedStrings;
import com.cognos.cm.cache.MLEntryStringValue;
import com.cognos.cm.cache.MLEntryTimestampValue;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;

public abstract class MLEntry {
    private static ISymbolTable defaultSymbolTable = new InternedStrings();
    private static final int LOCALE_MASK = 65534;
    protected int localeCode;
    private MLEntry next;

    protected static void clearSymbolTable() {
        defaultSymbolTable.clear();
    }

    public static MLEntry createMLEntry(String value, int locale) {
        return MLEntry.createMLEntry(defaultSymbolTable, value, locale);
    }

    private static MLEntry createMLEntry(ISymbolTable stringsTable, String value, int locale) {
        MLEntry entry;
        if (MLEntryTimestampValue.disqualify(value)) {
            entry = new MLEntryStringValue(stringsTable.allocate(value), locale);
        } else {
            try {
                entry = new MLEntryTimestampValue(value, locale);
            }
            catch (IllegalArgumentException ex) {
                entry = new MLEntryStringValue(stringsTable.allocate(value), locale);
            }
        }
        return entry;
    }

    public static int getLocale(int localeCode) {
        return 0xFFFE & localeCode;
    }

    static int getMappedLocale(int localeCode) {
        return MLEntry.getLocale(localeCode >> 16);
    }

    static boolean isDefault(int localeCode) {
        return CMDbStoreStringLocales.isDefaultLocale(localeCode);
    }

    protected MLEntry(int localeCode) {
        this.localeCode = localeCode;
    }

    public int getLocaleCode() {
        return this.localeCode;
    }

    int getLocale() {
        return MLEntry.getLocale(this.localeCode);
    }

    int getMappedLocale() {
        return MLEntry.getMappedLocale(this.localeCode);
    }

    boolean isDefault() {
        return MLEntry.isDefault(this.localeCode);
    }

    boolean matchesLocale(int localeCode) {
        return MLEntry.getLocale(localeCode) == this.getLocale();
    }

    public abstract String getValue();

    abstract boolean compareValue(String var1);

    abstract boolean compareEntry(MLEntry var1);

    MLEntry getNext() {
        return this.next;
    }

    void setNext(MLEntry entry) {
        this.next = entry;
    }

    public int compareTo(MLEntry other) {
        if (this instanceof MLEntryTimestampValue) {
            if (other instanceof MLEntryTimestampValue) {
                MLEntryTimestampValue thisTimestamp = (MLEntryTimestampValue)this;
                MLEntryTimestampValue otherTimestamp = (MLEntryTimestampValue)other;
                return thisTimestamp.comparison(otherTimestamp);
            }
            return 1;
        }
        if (other instanceof MLEntryTimestampValue) {
            return -1;
        }
        MLEntryStringValue thisStringValue = (MLEntryStringValue)this;
        MLEntryStringValue otherStringValue = (MLEntryStringValue)other;
        return thisStringValue.comparison(otherStringValue);
    }
}

