/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.MLEntry;
import com.cognos.cm.constants.CMError;

public class MLEntryStringValue
extends MLEntry {
    private String value;

    MLEntryStringValue(String value, int localeCode) {
        super(localeCode);
        if (value == null) {
            throw new RuntimeException(CMError.getMessage("cmCacheNullValueForMLEntry", null, null));
        }
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    boolean compareValue(String value) {
        if (null == value) {
            return false;
        }
        return value.equalsIgnoreCase(this.value);
    }

    @Override
    public boolean compareEntry(MLEntry entry) {
        if (this == entry) {
            return true;
        }
        if (entry == null) {
            return false;
        }
        if (this.getClass() != entry.getClass()) {
            return false;
        }
        MLEntryStringValue other = (MLEntryStringValue)entry;
        return !(this.value == null ? other.value != null : !this.value.equalsIgnoreCase(other.value));
    }

    public int comparison(MLEntryStringValue other) {
        if (other == null) {
            return 1;
        }
        return this.value.compareTo(other.value);
    }

    public String toString() {
        return this.value;
    }
}

