/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.MLEntry;
import com.cognos.cmutils.date.DateUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MLEntryTimestampValue
extends MLEntry {
    private long timestampValue;
    private int uniqueValue = -1;
    private static ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setTimeZone(DateUtils.getUTCTimeZone());
            format.setLenient(false);
            return format;
        }
    };

    public static void resetThreadLocalData() {
        dateFormatThreadLocal.remove();
    }

    private DateFormat getDateFormat() {
        return dateFormatThreadLocal.get();
    }

    MLEntryTimestampValue(String value, int localeCode) {
        super(localeCode);
        this.setValue(value);
    }

    public MLEntryTimestampValue(Date date) {
        this(date, -1, 0);
    }

    public MLEntryTimestampValue(long timestampValue) {
        this(timestampValue, -1, 0);
    }

    public MLEntryTimestampValue(Date date, int localeCode) {
        this(date.getTime(), -1, localeCode);
    }

    MLEntryTimestampValue(Date date, int uniqueValue, int localeCode) {
        this(date.getTime(), uniqueValue, localeCode);
    }

    MLEntryTimestampValue(MLEntryTimestampValue other) {
        this(other.timestampValue, other.uniqueValue, other.localeCode);
    }

    MLEntryTimestampValue(long timestampValue, int uniqueValue, int localeCode) {
        super(localeCode);
        this.timestampValue = timestampValue;
        this.uniqueValue = uniqueValue;
    }

    private void parseTimestampPortion(String value, String portion) throws IllegalArgumentException {
        try {
            Date date = this.getDateFormat().parse(portion);
            this.timestampValue = date.getTime();
        }
        catch (ParseException ex) {
            this.raiseIllegalArgumentException(value, "timestamp", ex);
        }
    }

    private void parseUniquePortion(String value, String portion) throws IllegalArgumentException {
        try {
            this.uniqueValue = Integer.parseInt(portion);
        }
        catch (NumberFormatException ex) {
            this.raiseIllegalArgumentException(value, portion, ex);
        }
    }

    @Override
    public String getValue() {
        String name = this.getDateFormat().format(new Date(this.timestampValue));
        if (0 <= this.uniqueValue) {
            name = name + "." + String.valueOf(this.uniqueValue);
        }
        return name;
    }

    public String toString() {
        return this.getValue();
    }

    public long getTimestampValue() {
        return this.timestampValue;
    }

    private void setValue(String value) throws IllegalArgumentException {
        if (24 > value.length()) {
            throw new IllegalArgumentException("The timestamp-based name '" + value + "' is invalid.");
        }
        if (24 < value.length()) {
            this.parseUniquePortion(value, value.substring(25));
        } else {
            this.uniqueValue = -1;
        }
        this.parseTimestampPortion(value, value.substring(0, 24));
    }

    private void raiseIllegalArgumentException(String value, String portion, Exception ex) throws IllegalArgumentException {
        String msg = "The " + portion + " portion of the timestamp-based name '" + value + "' could not be parsed.";
        IllegalArgumentException ex2 = new IllegalArgumentException(msg);
        ex2.initCause(ex);
        throw ex2;
    }

    @Override
    boolean compareValue(String value) {
        if (null == value) {
            return false;
        }
        String regex = "[12]\\d{3}?-[01]\\d-[0-3]\\d[tT][0-2]\\d:[0-5]\\d:[0-6]\\d.\\d{3}?[zZ](\\.\\d+)?";
        if (value.matches("[12]\\d{3}?-[01]\\d-[0-3]\\d[tT][0-2]\\d:[0-5]\\d:[0-6]\\d.\\d{3}?[zZ](\\.\\d+)?")) {
            return value.equalsIgnoreCase(this.getValue());
        }
        return false;
    }

    @Override
    public boolean compareEntry(MLEntry entry) {
        if (entry.getClass() != this.getClass()) {
            return false;
        }
        MLEntryTimestampValue other = (MLEntryTimestampValue)entry;
        return this.timestampValue == other.timestampValue && this.uniqueValue == other.uniqueValue;
    }

    public int comparison(MLEntryTimestampValue other) {
        if (other == null) {
            return 1;
        }
        if (this.timestampValue == other.timestampValue) {
            return this.uniqueValue - other.uniqueValue;
        }
        long delta = this.timestampValue - other.timestampValue;
        return delta < 0L ? -1 : 1;
    }

    public void advanceTime(long delta) {
        this.timestampValue += delta;
    }

    public void incrementUniqueValue() {
        ++this.uniqueValue;
    }

    public void setTimestamp(MLEntryTimestampValue timestampEntry) {
        this.timestampValue = timestampEntry.timestampValue;
        this.uniqueValue = timestampEntry.uniqueValue;
    }

    public static boolean disqualify(String value) {
        if (24 > value.length()) {
            return true;
        }
        return !Character.isDigit(value.charAt(0));
    }

    public int getUniqueValue() {
        return this.uniqueValue;
    }
}

