/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.MLEntry;
import java.util.List;

public class MLProp {
    private MLEntry head;
    private MLEntry maxEntry;

    public void add(String value, int localeCode) {
        MLEntry newEntry = MLEntry.createMLEntry(value, localeCode);
        if (this.head == null) {
            this.head = this.maxEntry = newEntry;
        } else {
            MLEntry l;
            if (newEntry.compareTo(this.maxEntry) > 0) {
                this.maxEntry = newEntry;
            }
            if ((l = this.findAndReplace(newEntry)) != null) {
                l.setNext(newEntry);
            } else if (this.maxEntry == null) {
                this.updateMaxEntry();
            }
        }
    }

    private void updateMaxEntry() {
        for (MLEntry p = this.head; p != null; p = p.getNext()) {
            if (p.compareTo(this.maxEntry) <= 0) continue;
            this.maxEntry = p;
        }
    }

    private MLEntry findAndReplace(MLEntry replacement) {
        MLEntry l = null;
        for (MLEntry p = this.head; p != null; p = p.getNext()) {
            if (p.matchesLocale(replacement.localeCode)) {
                replacement.setNext(p.getNext());
                if (l == null) {
                    this.head = replacement;
                } else {
                    l.setNext(replacement);
                }
                if (p == this.maxEntry) {
                    this.maxEntry = null;
                }
                return null;
            }
            l = p;
        }
        return l;
    }

    public void setAll(List<String> values, List<Integer> locales) {
        this.clear();
        MLEntry l = null;
        for (int i = 0; i < values.size(); ++i) {
            MLEntry p = MLEntry.createMLEntry(values.get(i), locales.get(i));
            if (p.compareTo(this.maxEntry) > 0) {
                this.maxEntry = p;
            }
            if (l == null) {
                this.head = p;
            } else {
                l.setNext(p);
            }
            l = p;
        }
    }

    public void clear() {
        this.head = null;
        this.maxEntry = null;
    }

    public String get(int locale) {
        for (MLEntry p = this.head; null != p; p = p.getNext()) {
            if (!p.matchesLocale(locale)) continue;
            return p.getValue();
        }
        return null;
    }

    public boolean containsValue(String value) {
        if (value == null) {
            return false;
        }
        for (MLEntry p = this.head; null != p; p = p.getNext()) {
            if (!p.compareValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(MLEntry other) {
        if (other == null) {
            return false;
        }
        for (MLEntry p = this.head; null != p; p = p.getNext()) {
            if (!p.compareEntry(other)) continue;
            return true;
        }
        return false;
    }

    public MLEntry getDefaultEntry(int[] locales) {
        MLEntry mappedEntry = null;
        MLEntry defaultEntry = null;
        for (int i = 0; i < locales.length; ++i) {
            int localeId = MLEntry.getLocale(locales[i]);
            for (MLEntry p = this.head; null != p; p = p.getNext()) {
                if (localeId == p.getLocale()) {
                    return p;
                }
                if (0 != i) continue;
                if (p.getMappedLocale() == MLEntry.getLocale(locales[locales.length - 1])) {
                    mappedEntry = p;
                }
                if (!p.isDefault()) continue;
                defaultEntry = p;
            }
        }
        if (null == mappedEntry) {
            if (null != defaultEntry) {
                mappedEntry = defaultEntry;
            } else if (null != this.head) {
                mappedEntry = this.head;
            }
        }
        return mappedEntry;
    }

    public void getAll(List<String> values, List<Integer> locales) {
        for (MLEntry p = this.head; null != p; p = p.getNext()) {
            values.add(p.getValue());
            locales.add(new Integer(p.getLocaleCode()));
        }
    }

    public int size() {
        int size = 0;
        for (MLEntry p = this.head; null != p; p = p.getNext()) {
            ++size;
        }
        return size;
    }

    public MLEntry getFirst() {
        return this.head;
    }

    public MLEntry getMaxEntry() {
        return this.maxEntry;
    }
}

