/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.entry.CacheEntry;
import java.util.HashMap;
import java.util.Map;

public class PropertyCache {
    private final Map<String, CacheEntry> entries = new HashMap<String, CacheEntry>();
    private boolean caseSensitive = false;

    public PropertyCache(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void clear() {
        this.entries.clear();
    }

    public CacheEntry getEntry(String key) {
        if (key == null) {
            return null;
        }
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return this.entries.get(key);
    }

    public CacheEntry putEntry(String key, CacheEntry entry) {
        if (key == null) {
            return null;
        }
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return this.entries.put(key, entry);
    }

    public int size() {
        return this.entries.size();
    }
}

