/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.LastEntryMap;
import com.cognos.cm.cache.entry.CacheEntry;
import java.util.HashMap;
import java.util.Map;

class TenantedLastEntryMap
extends LastEntryMap {
    private Map<CacheEntry, Map<Integer, CacheEntry[]>> data = new HashMap<CacheEntry, Map<Integer, CacheEntry[]>>();

    TenantedLastEntryMap() {
    }

    @Override
    public void put(CacheEntry parent, CacheEntry child, int tenantId) {
        CacheEntry[] afterInsert;
        CacheEntry[] lastEntries;
        Map<Integer, CacheEntry[]> perTenantMap = this.data.get(parent);
        if (perTenantMap == null) {
            perTenantMap = new HashMap<Integer, CacheEntry[]>();
            this.data.put(parent, perTenantMap);
        }
        if ((lastEntries = perTenantMap.get(tenantId)) == null) {
            lastEntries = new CacheEntry[1];
            perTenantMap.put(tenantId, lastEntries);
        }
        if ((afterInsert = this.insertEntry(lastEntries, child)) != lastEntries) {
            perTenantMap.put(tenantId, afterInsert);
        }
    }

    @Override
    protected CacheEntry[] getEntries(CacheEntry parent, int tenantId) {
        Map<Integer, CacheEntry[]> perTenantMap = this.data.get(parent);
        if (perTenantMap == null) {
            return null;
        }
        return perTenantMap.get(tenantId);
    }

    @Override
    public void remove(CacheEntry parentEntry) {
        this.data.remove(parentEntry);
    }

    @Override
    public void remove(CacheEntry parent, int typeId, int tenantId) {
        Map<Integer, CacheEntry[]> perTenantMap = this.data.get(parent);
        if (perTenantMap == null) {
            return;
        }
        if (tenantId == 0) {
            for (CacheEntry[] entries : perTenantMap.values()) {
                this.removeEntry(entries, typeId);
            }
        } else {
            this.removeEntry(perTenantMap.get(tenantId), typeId);
        }
    }
}

