/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.cache;

import com.cognos.cm.cache.MLEntryTimestampValue;
import com.cognos.cm.cache.entry.CacheEntry;
import com.cognos.cm.util.CMDateUtils;

public class UniqueNameGenerator {
    public static final int UNKNOWN_EPOCH_TIME = -1;
    private final CMDateUtils.Clock clock;
    private long lastTimestamp;

    public UniqueNameGenerator() {
        this(CMDateUtils.getClock(), -1L);
    }

    public UniqueNameGenerator(long initialEpochTime) {
        this(CMDateUtils.getClock(), initialEpochTime);
    }

    protected UniqueNameGenerator(CMDateUtils.Clock clock, long initialEpochTime) {
        this.clock = clock;
        this.lastTimestamp = initialEpochTime;
    }

    public long nextTimestamp() {
        return this.advanceTimestamp(this.clock.getTimeMillis());
    }

    public MLEntryTimestampValue getTimestampValue(CacheEntry parentEntry) {
        long clockSkew;
        MLEntryTimestampValue lastChildName = parentEntry.getLatestChildTimestamp();
        long lastChildTimestamp = this.getLastChildTimestamp(lastChildName);
        long timestamp = this.nextTimestamp();
        if (timestamp == lastChildTimestamp) {
            timestamp = this.nextTimestamp();
        }
        if ((clockSkew = lastChildTimestamp - timestamp) > 0L) {
            timestamp = lastChildTimestamp + 1L + clockSkew;
        }
        return new MLEntryTimestampValue(timestamp);
    }

    private long getLastChildTimestamp(MLEntryTimestampValue lastChildName) {
        return lastChildName != null ? lastChildName.getTimestampValue() : -1L;
    }

    private synchronized long advanceTimestamp(long currentTime) {
        this.lastTimestamp = this.lastTimestamp == -1L || currentTime > this.lastTimestamp ? currentTime : ++this.lastTimestamp;
        return this.lastTimestamp;
    }
}

